/*
 * Decompiled with CFR 0.152.
 */
package tigase.stun;

import de.javawi.jstun.attribute.ChangeRequest;
import de.javawi.jstun.attribute.ChangedAddress;
import de.javawi.jstun.attribute.MappedAddress;
import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.ResponseAddress;
import de.javawi.jstun.attribute.SourceAddress;
import de.javawi.jstun.attribute.UnknownAttribute;
import de.javawi.jstun.attribute.UnknownMessageAttributeException;
import de.javawi.jstun.header.MessageHeader;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.util.Address;
import java.net.DatagramPacket;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.stun.StatisticsCollector;
import tigase.stun.StunSocket;

public class StunServerReceiverThread
extends Thread {
    private static final Logger log = Logger.getLogger(StunServerReceiverThread.class.getCanonicalName());
    private StunSocket changedIP;
    private StunSocket changedPort;
    private StunSocket changedPortIP;
    private StunSocket receiverSocket;
    private boolean shutdown;
    private StatisticsCollector statsCollector;

    public StunServerReceiverThread(StunSocket receiver, Vector<StunSocket> sockets, StatisticsCollector statsCollector) {
        this.receiverSocket = receiver;
        this.statsCollector = statsCollector;
        for (StunSocket socket : sockets) {
            if (socket.getLocalPort() != this.receiverSocket.getLocalPort() && socket.getLocalAddress() == this.receiverSocket.getLocalAddress()) {
                this.changedPort = socket;
            }
            if (socket.getLocalPort() != this.receiverSocket.getLocalPort() && socket.getLocalAddress() != this.receiverSocket.getLocalAddress()) {
                this.changedPortIP = socket;
            }
            if (socket.getLocalPort() != this.receiverSocket.getLocalPort() || socket.getLocalAddress() == this.receiverSocket.getLocalAddress()) continue;
            this.changedIP = socket;
        }
    }

    @Override
    public void run() {
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                DatagramPacket packet = new DatagramPacket(new byte[200], 200);
                this.receiverSocket.receive(packet);
                this.statsCollector.packetReceived();
                MessageHeader header = MessageHeader.parseHeader((byte[])packet.getData());
                try {
                    DatagramPacket send;
                    byte[] data;
                    SourceAddress sa;
                    header.parseAttributes(packet.getData());
                    if (header.getType() != MessageHeaderInterface.MessageHeaderType.BindingRequest) continue;
                    ChangeRequest cr = (ChangeRequest)header.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ChangeRequest);
                    if (cr == null) {
                        throw new MessageAttributeException("Message attribute change request is not set.");
                    }
                    ResponseAddress ra = (ResponseAddress)header.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ResponseAddress);
                    MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingResponse);
                    sendMH.setTransactionID(header.getTransactionID());
                    MappedAddress ma = new MappedAddress();
                    ma.setAddress(new Address(packet.getAddress().getAddress()));
                    ma.setPort(packet.getPort());
                    sendMH.addMessageAttribute((MessageAttribute)ma);
                    ChangedAddress ca = new ChangedAddress();
                    ca.setAddress(new Address(this.changedPortIP.getExternalAddress().getAddress()));
                    ca.setPort(this.changedPortIP.getExternalPort());
                    sendMH.addMessageAttribute((MessageAttribute)ca);
                    if (cr.isChangePort() && !cr.isChangeIP()) {
                        sa = new SourceAddress();
                        sa.setAddress(new Address(this.changedPort.getExternalAddress().getAddress()));
                        sa.setPort(this.changedPort.getExternalPort());
                        sendMH.addMessageAttribute((MessageAttribute)sa);
                        data = sendMH.getBytes();
                        send = new DatagramPacket(data, data.length);
                        if (ra != null) {
                            send.setPort(ra.getPort());
                            send.setAddress(ra.getAddress().getInetAddress());
                        } else {
                            send.setPort(packet.getPort());
                            send.setAddress(packet.getAddress());
                        }
                        this.changedPort.send(send);
                        continue;
                    }
                    if (!cr.isChangePort() && cr.isChangeIP()) {
                        sa = new SourceAddress();
                        sa.setAddress(new Address(this.changedIP.getExternalAddress().getAddress()));
                        sa.setPort(this.changedIP.getExternalPort());
                        sendMH.addMessageAttribute((MessageAttribute)sa);
                        data = sendMH.getBytes();
                        send = new DatagramPacket(data, data.length);
                        if (ra != null) {
                            send.setPort(ra.getPort());
                            send.setAddress(ra.getAddress().getInetAddress());
                        } else {
                            send.setPort(packet.getPort());
                            send.setAddress(packet.getAddress());
                        }
                        this.changedIP.send(send);
                        continue;
                    }
                    if (!cr.isChangePort() && !cr.isChangeIP()) {
                        sa = new SourceAddress();
                        sa.setAddress(new Address(this.receiverSocket.getExternalAddress().getAddress()));
                        sa.setPort(this.receiverSocket.getExternalPort());
                        sendMH.addMessageAttribute((MessageAttribute)sa);
                        data = sendMH.getBytes();
                        send = new DatagramPacket(data, data.length);
                        if (ra != null) {
                            send.setPort(ra.getPort());
                            send.setAddress(ra.getAddress().getInetAddress());
                        } else {
                            send.setPort(packet.getPort());
                            send.setAddress(packet.getAddress());
                        }
                        this.receiverSocket.send(send);
                        continue;
                    }
                    if (!cr.isChangePort() || !cr.isChangeIP()) continue;
                    sa = new SourceAddress();
                    sa.setAddress(new Address(this.changedPortIP.getExternalAddress().getAddress()));
                    sa.setPort(this.changedPortIP.getExternalPort());
                    sendMH.addMessageAttribute((MessageAttribute)sa);
                    data = sendMH.getBytes();
                    send = new DatagramPacket(data, data.length);
                    if (ra != null) {
                        send.setPort(ra.getPort());
                        send.setAddress(ra.getAddress().getInetAddress());
                    } else {
                        send.setPort(packet.getPort());
                        send.setAddress(packet.getAddress());
                    }
                    this.changedPortIP.send(send);
                }
                catch (UnknownMessageAttributeException umae) {
                    umae.printStackTrace();
                    MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingErrorResponse);
                    sendMH.setTransactionID(header.getTransactionID());
                    UnknownAttribute ua = new UnknownAttribute();
                    ua.addAttribute(umae.getType());
                    sendMH.addMessageAttribute((MessageAttribute)ua);
                    byte[] data = sendMH.getBytes();
                    DatagramPacket send = new DatagramPacket(data, data.length);
                    send.setPort(packet.getPort());
                    send.setAddress(packet.getAddress());
                    this.receiverSocket.send(send);
                }
            }
            catch (Exception ex) {
                log.log(Level.FINE, "error processing received socket data", ex);
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }
}

