/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.converter;

import java.sql.PreparedStatement;
import tigase.db.DataRepository;
import tigase.db.DataRepositoryPool;
import tigase.db.TigaseDBException;
import tigase.db.converter.DataRepoPool;

public class QueryExecutor {
    private DataRepoPool dataRepoPool;

    public <X> X executeQuery(String preparedStatementId, QueryFunction<PreparedStatement, X> fun) throws Exception {
        DataRepository dataRepositoryFromPool = this.dataRepoPool.takeRepoHandle(null);
        if (DataRepositoryPool.class.isAssignableFrom(dataRepositoryFromPool.getClass())) {
            throw new TigaseDBException("Wrong DataRepositoryImplementation");
        }
        PreparedStatement preparedStatement = dataRepositoryFromPool.getPreparedStatement(0, preparedStatementId);
        X apply = fun.apply(preparedStatement);
        this.dataRepoPool.addRepo(dataRepositoryFromPool);
        return apply;
    }

    void initialise(DataRepoPool dataRepoPool) {
        this.dataRepoPool = dataRepoPool;
    }

    @FunctionalInterface
    public static interface QueryFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

