/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.processors;

import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.MessageArchiveVHostItemExtension;
import tigase.archive.Settings;
import tigase.archive.StoreMethod;
import tigase.archive.StoreMuc;
import tigase.archive.processors.AbstractMAMProcessor;
import tigase.archive.processors.MAM2Processor;
import tigase.archive.processors.Xep0136MessageArchivingProcessor;
import tigase.archive.processors.Xep0313MessageArchiveManagementProcessor;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AuthRepository;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.server.xmppsession.UserConnectedEvent;
import tigase.util.cache.LRUConcurrentCache;
import tigase.util.datetime.TimestampHelper;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostItemImpl;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.ElementMatcher;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.JabberIqPrivacy;
import tigase.xmpp.impl.MessageDeliveryLogic;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Id(value="message-archive")
@Handles(value={@Handle(path={"message"}, xmlns="jabber:client")})
@Bean(name="message-archive", parents={Xep0136MessageArchivingProcessor.class, Xep0313MessageArchiveManagementProcessor.class, MAM2Processor.class}, active=true, exportable=true)
public class MessageArchivePlugin
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc,
SessionManager.MessageArchive,
Initializable,
UnregisterAware {
    public static final String DEFAULT_SAVE = "default-save";
    public static final String MUC_SAVE = "muc-save";
    public static final String OWNER_JID = "owner";
    public static final String ARCHIVE = "message-archive";
    public static final String MSG_ARCHIVE_PATHS = "msg-archive-paths";
    protected static final String ID = "message-archive";
    protected static final String SETTINGS = "message-archive/settings";
    private static final Logger log = Logger.getLogger(MessageArchivePlugin.class.getCanonicalName());
    private static final String AUTO = "auto";
    private static final String DEFAULT_STORE_METHOD_KEY = "default-store-method";
    private static final String REQUIRED_STORE_METHOD_KEY = "required-store-method";
    private static final String STORE_MUC_MESSAGES_KEY = "store-muc-messages";
    private static final String[] MESSAGE_HINTS_NO_STORE = new String[]{"message", "no-store"};
    private static final String[] MESSAGE_HINTS_NO_PERMANENT_STORE = new String[]{"message", "no-permanent-store"};
    private static final String MESSAGE_HINTS_XMLNS = "urn:xmpp:hints";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final TimestampHelper timestampHelper = new TimestampHelper();
    @ConfigField(desc="Message archiving component JID", alias="component-jid")
    protected JID componentJid = null;
    @Inject
    private UserRepository userRepository;
    @ConfigField(desc="Cache size", alias="size")
    private int cacheSize = 10000;
    private LRUConcurrentCache<BareJID, Settings> cache = new LRUConcurrentCache(this.cacheSize);
    @ConfigField(desc="Ignore PubSub notifications sent to full JID", alias="ignore-pubsub-events-full-jid")
    protected boolean ignorePubSubEventsFullJid = true;
    @ConfigField(desc="Matchers selecting messages that will be archived", alias="msg-archive-paths")
    private ElementMatcher[] archivingMatchers = new ElementMatcher[]{new ElementMatcher(new String[]{"message", "result"}, "urn:xmpp:mam:1", false), new ElementMatcher(new String[]{"message", "result"}, "urn:xmpp:mam:2", false), new ElementMatcher(new String[]{"message"}, true, "urn:xmpp:carbons:2", null, false), new ElementMatcher(new String[]{"message", "no-store"}, "urn:xmpp:hints", false), new ElementMatcher(new String[]{"message", "body"}, null, true), new ElementMatcher(new String[]{"message", "store"}, "urn:xmpp:hints", true), new ElementMatcher(new String[]{"message"}, false, null, (String[][])new String[][]{{"type", "headline"}}, false), new ElementMatcher(new String[]{"message"}, true, "http://jabber.org/protocol/chatstates", null, false), new ElementMatcher(new String[]{"message"}, null, true)};
    @ConfigField(desc="Global default store method", alias="default-store-method")
    private StoreMethod globalDefaultStoreMethod = StoreMethod.Message;
    @ConfigField(desc="Global required store method", alias="required-store-method")
    private StoreMethod globalRequiredStoreMethod = StoreMethod.False;
    @ConfigField(desc="Store MUC messages in archive using automatic archiving", alias="store-muc-messages")
    private StoreMuc globalStoreMucMessages = StoreMuc.User;
    @ConfigField(desc="Store MIX messages in a local user archive", alias="store-mix-messages")
    private boolean globalStoreMixMessages = true;
    @Inject
    private MessageDeliveryLogic message;
    private RosterAbstract rosterUtil = RosterFactory.getRosterImplementation((boolean)true);
    @Inject
    private EventBus eventBus;
    @Inject
    private VHostManagerIfc vHostManager;
    @Inject(nullAllowed=true)
    private List<AbstractMAMProcessor> mamProcessors = new ArrayList<AbstractMAMProcessor>();
    private boolean stanzaIdSupport = false;
    private boolean archiveOffline = true;
    private SessionManagerHandler loginHandler = new SessionManagerHandler(){

        public JID getComponentId() {
            return MessageArchivePlugin.this.getComponentJid();
        }

        public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
        }

        public void handleDomainChange(String domain, XMPPResourceConnection conn) {
        }

        public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
        }

        public void handlePresenceSet(XMPPResourceConnection conn) {
        }

        public void handleResourceBind(XMPPResourceConnection conn) {
        }

        public boolean isLocalDomain(String domain, boolean includeComponents) {
            return false;
        }
    };
    @Inject
    private AuthRepository authRepository;
    private final JID offlineConnectionId = JID.jidInstanceNS((String)"offline-connection", (String)DNSResolverFactory.getInstance().getDefaultHost());

    public boolean isArchivingOfMixMessageEnabled() {
        return this.globalStoreMixMessages;
    }

    public void setArchiveOffline(boolean archiveOffline) {
        this.archiveOffline = archiveOffline;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        if (this.cache.limit() != cacheSize) {
            this.cache = new LRUConcurrentCache(cacheSize);
        }
    }

    public void setMamProcessors(List<AbstractMAMProcessor> mamProcessors) {
        if (mamProcessors != null) {
            this.mamProcessors = mamProcessors;
            this.stanzaIdSupport = mamProcessors.stream().anyMatch(AbstractMAMProcessor::hasStanzaIdSupport);
        } else {
            this.mamProcessors = Collections.emptyList();
            this.stanzaIdSupport = false;
        }
    }

    public MessageArchivePlugin() {
        this.componentJid = JID.jidInstanceNS((String)"message-archive", (String)DNSResolverFactory.getInstance().getDefaultHost(), null);
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        try {
            this.processMessage(packet, session, results);
        }
        catch (NotAuthorizedException ex) {
            log.log(Level.FINE, "NotAuthorizedException for packet: {0}", packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    public String[] getArchivingMatchers() {
        String[] result = new String[this.archivingMatchers.length];
        for (int i = 0; i < this.archivingMatchers.length; ++i) {
            result[i] = this.archivingMatchers[i].toString();
        }
        return result;
    }

    public void setArchivingMatchers(String[] matcherStrs) {
        ArrayList<ElementMatcher> matchers = new ArrayList<ElementMatcher>();
        for (String matcherStr : matcherStrs) {
            ElementMatcher matcher = ElementMatcher.create((String)matcherStr);
            if (matcher == null) continue;
            matchers.add(matcher);
        }
        this.archivingMatchers = matchers.toArray(new ElementMatcher[0]);
    }

    public JID getComponentJid() {
        return this.componentJid;
    }

    public void setComponentJid(JID componentJid) {
        this.componentJid = componentJid;
    }

    public StoreMethod getDefaultStoreMethod(Optional<MessageArchiveVHostItemExtension> maExt) {
        return maExt.flatMap(MessageArchiveVHostItemExtension::getDefaultStoreMethod).orElse(this.globalDefaultStoreMethod);
    }

    public StoreMethod getRequiredStoreMethod(Optional<MessageArchiveVHostItemExtension> maExt) {
        return maExt.flatMap(MessageArchiveVHostItemExtension::getRequiredStoreMethod).orElse(this.globalRequiredStoreMethod);
    }

    public Settings getSettings(BareJID account, XMPPResourceConnection session) throws NotAuthorizedException {
        if (session == null) {
            Settings settings = (Settings)this.cache.get((Object)account);
            if (settings == null) {
                settings = this.loadSettings((node, key) -> this.userRepository.getData(account, node, key), (node, key, value) -> {
                    if (value != null) {
                        this.userRepository.setData(account, node, key, value);
                    } else {
                        this.userRepository.removeData(account, node, key);
                    }
                }, () -> Optional.ofNullable(this.vHostManager.getVHostItem(account.getDomain())));
                this.cache.put((Object)account, (Object)settings);
            }
            return settings;
        }
        Settings storeMethod = (Settings)session.getCommonSessionData(SETTINGS);
        if (storeMethod == null) {
            storeMethod = this.loadSettings(session);
        }
        return storeMethod;
    }

    public StoreMuc getRequiredStoreMucMessages(XMPPResourceConnection session) {
        return Optional.ofNullable((MessageArchiveVHostItemExtension)session.getDomain().getExtension(MessageArchiveVHostItemExtension.class)).flatMap(MessageArchiveVHostItemExtension::getSaveMuc).orElse(this.globalStoreMucMessages);
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
    }

    @HandleEvent
    protected void userConnected(UserConnectedEvent event) {
        this.cache.remove((Object)event.getUserJid().getBareJID());
    }

    public Settings loadSettings(XMPPResourceConnection session) throws NotAuthorizedException {
        Settings settings = this.loadSettings((node, key) -> session.getData(node, key, null), (node, key, value) -> {
            if (value != null) {
                session.setData(node, key, value);
            } else {
                session.removeData(node, key);
            }
        }, () -> Optional.ofNullable(session.getDomain()));
        session.putCommonSessionData(SETTINGS, (Object)settings);
        return settings;
    }

    public Settings loadSettings(RepoStringSupplier dataSupplier, RepoStringConsumer dataConsumer, Supplier<Optional<VHostItem>> vhostSupplier) throws NotAuthorizedException {
        Settings settings = new Settings();
        boolean conversion = false;
        Optional<VHostItem> vhost = vhostSupplier.get();
        Optional<MessageArchiveVHostItemExtension> maExt = vhost.map(item -> (MessageArchiveVHostItemExtension)item.getExtension(MessageArchiveVHostItemExtension.class));
        try {
            String prefs = dataSupplier.get("message-archive", "settings");
            if (prefs != null) {
                settings.parse(prefs);
            } else {
                Optional<Boolean> auto = Optional.ofNullable(dataSupplier.get(SETTINGS, AUTO)).map(Boolean::parseBoolean);
                if (auto.isPresent()) {
                    conversion = true;
                    settings.setAuto(auto.get());
                    StoreMuc storeMuc = this.globalStoreMucMessages;
                    if (this.globalStoreMucMessages == StoreMuc.User) {
                        String val = dataSupplier.get(SETTINGS, MUC_SAVE);
                        storeMuc = val == null ? maExt.flatMap(MessageArchiveVHostItemExtension::getSaveMuc).orElse(StoreMuc.False) : StoreMuc.valueof(val);
                    }
                    switch (storeMuc) {
                        case True: {
                            settings.setArchiveMucMessages(true);
                            break;
                        }
                        case False: {
                            settings.setArchiveMucMessages(true);
                            break;
                        }
                    }
                    StoreMethod storeMethod = Optional.ofNullable(dataSupplier.get(SETTINGS, DEFAULT_SAVE)).map(StoreMethod::valueof).orElseGet(() -> this.getDefaultStoreMethod(maExt));
                    settings.setStoreMethod(storeMethod);
                }
            }
            StoreMethod requiredStoreMethod = this.getRequiredStoreMethod(maExt);
            if (settings.updateRequirements(requiredStoreMethod, this.globalStoreMucMessages) || conversion) {
                dataConsumer.set("message-archive", "settings", settings.serialize());
                if (conversion) {
                    dataConsumer.set(SETTINGS, AUTO, null);
                    dataConsumer.set(SETTINGS, DEFAULT_STORE_METHOD_KEY, null);
                    dataConsumer.set(SETTINGS, MUC_SAVE, null);
                }
            }
        }
        catch (UserNotFoundException ex) {
            log.log(Level.FINEST, "User does not exist", ex);
        }
        catch (RepositoryException ex) {
            log.log(Level.WARNING, "Exception reading settings from database", ex);
        }
        return settings;
    }

    public void generateStableId(Packet packet) {
        if (packet.getStableId() == null) {
            if (packet.getType() == StanzaType.groupchat && packet.getElemChild("mix") == null) {
                String subject;
                StringBuilder sb = new StringBuilder();
                if (packet.getStanzaFrom() != null) {
                    sb.append(packet.getStanzaFrom().toString());
                }
                sb.append(":");
                Element delay = packet.getElemChild("delay", "urn:xmpp:delay");
                if (packet.getElemChild("subject") == null && packet.getStanzaId() != null) {
                    sb.append(packet.getStanzaId());
                }
                long ts = System.currentTimeMillis();
                if (delay != null) {
                    try {
                        Date stamp = this.timestampHelper.parseTimestamp(delay.getAttributeStaticStr("stamp"));
                        if (stamp != null) {
                            ts = stamp.getTime();
                        }
                    }
                    catch (ParseException stamp) {
                        // empty catch block
                    }
                }
                sb.append(":").append(ts / 60000L);
                String body = packet.getElement().getChildCData(new String[]{"message", "body"});
                if (body != null) {
                    sb.append(body);
                }
                if ((subject = packet.getElement().getCDataStaticStr(new String[]{"message", "subject"})) != null) {
                    sb.append(subject);
                }
                packet.setStableId(UUID.nameUUIDFromBytes(sb.toString().getBytes(StandardCharsets.UTF_8)).toString());
                return;
            }
            packet.setStableId(UUID.randomUUID().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStableId(Packet packet, XMPPResourceConnection session) {
        block9: {
            if (this.stanzaIdSupport) {
                try {
                    if (!this.willArchive(packet, session)) break block9;
                    try {
                        Packet packet2 = packet;
                        synchronized (packet2) {
                            String by = session == null ? Optional.ofNullable(packet.getStanzaTo()).map(JID::getBareJID).map(BareJID::toString).get() : session.getBareJID().toString();
                            String stableId = packet.getStableId();
                            if (stableId != null && packet.getElement().findChild(this.stanzaIdMatcher(by)) == null) {
                                Element stanzaIdEl = new Element("stanza-id");
                                stanzaIdEl.setXMLNS("urn:xmpp:sid:0");
                                stanzaIdEl.setAttribute("id", stableId);
                                stanzaIdEl.setAttribute("by", by);
                                packet.getElement().addChild((XMLNodeIfc)stanzaIdEl);
                            }
                        }
                    }
                    catch (NotAuthorizedException ex) {
                        return;
                    }
                }
                catch (NotAuthorizedException ex) {
                    if (!log.isLoggable(Level.FINEST)) break block9;
                    log.log(Level.FINEST, "Session is not authorized yet:" + session, ex);
                }
            }
        }
    }

    protected Element.Matcher<Element> stanzaIdMatcher(String by) {
        return el -> el.getName() == "stanza-id" && el.getXMLNS() == "urn:xmpp:sid:0" && by.equals(el.getAttributeStaticStr("by"));
    }

    public boolean willArchive(Packet packet, XMPPResourceConnection session) throws NotAuthorizedException {
        if (packet.getStanzaFrom() == null) {
            return false;
        }
        if (session != null) {
            return this.willArchive(packet, session.isUserId(packet.getStanzaFrom().getBareJID()) ? packet.getStanzaTo() : packet.getStanzaFrom(), this.getSettings(session.getBareJID(), session), () -> Optional.ofNullable(session.getDomain()), jid -> {
                try {
                    return this.rosterUtil.containsBuddy(session, jid);
                }
                catch (TigaseDBException | NotAuthorizedException ex) {
                    log.log(Level.WARNING, session.toString() + ", could not load roster to verify if sender/recipient is in roster, skipping archiving of packet: " + packet, ex);
                    return false;
                }
            });
        }
        if (!this.archiveOffline) {
            return false;
        }
        BareJID userJid = packet.getStanzaTo().getBareJID();
        return this.willArchive(packet, packet.getStanzaFrom(), this.getSettings(userJid, null), () -> Optional.ofNullable(this.vHostManager.getVHostItem(userJid.getDomain())), jid -> {
            try {
                JabberIqPrivacy.OfflineResourceConnection session1 = new JabberIqPrivacy.OfflineResourceConnection(this.offlineConnectionId, this.userRepository, this.authRepository, this.loginHandler);
                VHostItemImpl vhost = new VHostItemImpl(userJid.getDomain());
                session1.setDomain((VHostItem)vhost);
                session1.authorizeJID(userJid, false);
                XMPPSession parentSession = new XMPPSession(userJid.getLocalpart());
                session1.setParentSession(parentSession);
                return this.rosterUtil.containsBuddy((XMPPResourceConnection)session1, jid);
            }
            catch (TigaseDBException | TigaseStringprepException | NotAuthorizedException ex) {
                log.log(Level.WARNING, session.toString() + ", could not load roster to verify if sender/recipient is in roster, skipping archiving of packet: " + packet, ex);
                return false;
            }
        });
    }

    public boolean willArchive(Packet packet, JID buddyJid, Settings settings, Supplier<Optional<VHostItem>> vhostItemSupplier, Predicate<JID> isInRoster) throws NotAuthorizedException {
        StoreMethod requiredStoreMethod;
        if (C2SDeliveryErrorProcessor.isDeliveryError((Packet)packet)) {
            log.log(Level.FINEST, "not processong packet as it is delivery error = {0}", packet);
            return false;
        }
        Optional<VHostItem> vhostItem = vhostItemSupplier.get();
        if (!vhostItem.isPresent()) {
            return false;
        }
        String domain = vhostItem.get().getVhost().getDomain();
        if (packet.getElement().findChild(el -> el.getName() == "delay" && el.getXMLNS() == "urn:xmpp:delay" && domain.equals(el.getAttributeStaticStr("from"))) != null && this.archiveOffline) {
            return false;
        }
        StanzaType type = packet.getType();
        if (type == null) {
            type = StanzaType.normal;
        }
        Element body = packet.getElement().findChildStaticStr(Message.MESSAGE_BODY_PATH);
        if (!settings.isAutoArchivingEnabled()) {
            return false;
        }
        if ((packet.getAttributeStaticStr(MESSAGE_HINTS_NO_STORE, "xmlns") == MESSAGE_HINTS_XMLNS || packet.getAttributeStaticStr(MESSAGE_HINTS_NO_PERMANENT_STORE, "xmlns") == MESSAGE_HINTS_XMLNS) && (requiredStoreMethod = this.getRequiredStoreMethod(vhostItemSupplier.get().map(vHostItem -> (MessageArchiveVHostItemExtension)vHostItem.getExtension(MessageArchiveVHostItemExtension.class)))) == StoreMethod.False) {
            return false;
        }
        switch (type) {
            case groupchat: {
                Element mix = packet.getElemChild("mix", "urn:xmpp:mix:core:1");
                if (mix != null) {
                    if (!this.isArchivingOfMixMessageEnabled()) {
                        return false;
                    }
                    if (!isInRoster.test(buddyJid)) {
                        return false;
                    }
                } else if (!settings.archiveMucMessages()) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "not storing message as archiving of MUC messages is disabled: {0}", packet);
                    }
                    return false;
                }
                if (packet.getStanzaTo() == null || !buddyJid.getBareJID().equals((Object)packet.getStanzaTo().getBareJID())) break;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "not storing message sent to MUC room from user = {0}", packet.toString());
                }
                return false;
            }
        }
        switch (settings.getStoreMethod()) {
            case False: {
                if (!log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "not logging packet due to storage method: {0}, {1}", new Object[]{settings.getStoreMethod(), packet});
                return false;
            }
            case Body: {
                if (body != null || !log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "not logging packet as there is not body element: ", new Object[]{settings.getStoreMethod(), packet});
                return false;
            }
        }
        boolean archive = false;
        for (ElementMatcher matcher : this.archivingMatchers) {
            if (!matcher.matches(packet)) continue;
            archive = matcher.getValue();
            break;
        }
        if (!archive) {
            return false;
        }
        if (this.ignorePubSubEventsFullJid && packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null && packet.getElemChild("event", "http://jabber.org/protocol/pubsub#event") != null) {
            return false;
        }
        if (settings.archiveOnlyForContactsInRoster()) {
            if (packet.getStanzaTo() == null || packet.getStanzaFrom() == null) {
                return false;
            }
            if (!isInRoster.test(buddyJid)) {
                return false;
            }
        }
        return true;
    }

    private void processMessage(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        if (!this.willArchive(packet, session)) {
            return;
        }
        BareJID userJid = session == null ? packet.getStanzaTo().getBareJID() : session.getBareJID();
        Settings settings = this.getSettings(userJid, session);
        this.storeMessage(packet, userJid, settings, results);
    }

    private void storeMessage(Packet packet, BareJID owner, Settings settings, Queue<Packet> results) throws NotAuthorizedException {
        Packet result = packet.copyElementOnly();
        result.setPacketFrom(JID.jidInstance((BareJID)owner));
        result.setPacketTo(this.componentJid);
        result.setStableId(packet.getStableId());
        result.getElement().addAttribute(OWNER_JID, owner.toString());
        switch (settings.getStoreMethod()) {
            case Body: {
                Element message = result.getElement();
                block11: for (Element elem : message.getChildren()) {
                    switch (elem.getName()) {
                        case "body": {
                            continue block11;
                        }
                        case "delay": {
                            continue block11;
                        }
                    }
                    message.removeChild(elem);
                }
                break;
            }
        }
        Element stanzaIdEl = result.getElement().findChild(this.stanzaIdMatcher(owner.toString()));
        if (stanzaIdEl != null) {
            result.getElement().removeChild(stanzaIdEl);
        }
        results.offer(result);
    }

    private static interface RepoStringConsumer {
        public void set(String var1, String var2, String var3) throws RepositoryException, NotAuthorizedException;
    }

    private static interface RepoStringSupplier {
        public String get(String var1, String var2) throws RepositoryException, NotAuthorizedException;
    }
}

