/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.util.sequencer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import tigase.workgroupqueues.util.sequencer.ISequenceAction;
import tigase.workgroupqueues.util.sequencer.RunCallback;

public abstract class Sequencer
implements RunCallback {
    private ArrayList<ISequenceAction> a = new ArrayList();

    public Sequencer add(ISequenceAction ... actions) {
        for (ISequenceAction iSequenceAction : actions) {
            this.a.add(iSequenceAction);
        }
        return this;
    }

    public Sequencer add(Collection<ISequenceAction> actions) {
        for (ISequenceAction iSequenceAction : actions) {
            this.a.add(iSequenceAction);
        }
        return this;
    }

    public Sequencer add(Sequencer sequencer) {
        for (ISequenceAction iSequenceAction : sequencer.a) {
            this.a.add(iSequenceAction);
        }
        return this;
    }

    @Override
    public abstract void onFailure();

    @Override
    public abstract void onFinish();

    public void run() {
        this.run(null);
    }

    public void run(RunCallback callback) {
        Iterator<ISequenceAction> iterator = this.a.iterator();
        this.a(iterator, callback);
    }

    private void a(final Iterator<ISequenceAction> iterator, final RunCallback runCallback) {
        if (!iterator.hasNext()) {
            try {
                if (runCallback != null) {
                    runCallback.onFinish();
                }
            }
            finally {
                this.onFinish();
            }
            return;
        }
        ISequenceAction iSequenceAction = iterator.next();
        if (iSequenceAction.skip()) {
            this.a(iterator, runCallback);
        } else {
            Callback callback = new Callback(){

                @Override
                public void failure() {
                    try {
                        if (runCallback != null) {
                            runCallback.onFailure();
                        }
                    }
                    finally {
                        Sequencer.this.onFailure();
                    }
                }

                @Override
                public void next() {
                    Sequencer.this.a(iterator, runCallback);
                }
            };
            iSequenceAction.execute(callback);
        }
    }

    public static interface Callback {
        public void failure();

        public void next();
    }
}

