/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.modules;

import java.util.function.Predicate;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.workgroupqueues.WorkgroupQueuesComponent;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="disco", active=true)
public class DiscoveryModule
extends tigase.component.modules.impl.DiscoveryModule {
    @Inject
    private WorkgroupQueuesComponent component;
    @Inject
    private Store store;

    protected void processDiscoInfo(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (jid.getLocalpart() == null) {
            super.processDiscoInfo(packet, jid, node, senderJID);
        } else {
            this.a(packet, jid, node, senderJID);
        }
    }

    protected void processDiscoItems(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (node != null) {
            super.processDiscoItems(packet, jid, node, senderJID);
            return;
        }
        if (jid.getLocalpart() == null) {
            this.c(packet, jid, node, senderJID);
        } else {
            this.b(packet, jid, node, senderJID);
        }
    }

    private void a(Packet packet, JID jID, String string, JID jID2) throws ComponentException {
        WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(jID.getBareJID());
        if (workgroupQueueEntity == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Workgroup not found");
        }
        Element element = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
        element.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "name", "type"}, new String[]{this.component.getDiscoCategory(), workgroupQueueEntity.getJid().getLocalpart(), this.component.getDiscoCategoryType()}));
        element.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/disco#info"}));
        Element element2 = new Element("x", new String[]{"type"}, new String[]{"result"});
        element2.setXMLNS("jabber:x:data");
        element.addChild((XMLNodeIfc)element2);
        Element element3 = new Element("field", new String[]{"var", "type"}, new String[]{"FORM_TYPE", "hidden"});
        element3.addChild((XMLNodeIfc)new Element("value", "http://jabber.org/protocol/workgroup#workgroupinfo"));
        element2.addChild((XMLNodeIfc)element3);
        element3 = new Element("field", new String[]{"var", "label"}, new String[]{"workgroup#description", "Description"});
        element3.addChild((XMLNodeIfc)new Element("value", workgroupQueueEntity.getDescription()));
        element2.addChild((XMLNodeIfc)element3);
        this.write(packet.okResult(element, 0));
    }

    private void b(Packet packet, JID jID, String string, JID jID2) {
        Element element = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
        this.write(packet.okResult(element, 0));
    }

    private void c(Packet packet, JID jID, String string, JID jID2) {
        Element element = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
        this.store.getWorkgroupQueues().stream().filter(new Predicate(){

            public boolean test(Object o) {
                return false;
            }
        });
        this.store.getWorkgroupQueues().stream().filter(workgroupQueueEntity -> workgroupQueueEntity.getJid().getDomain().equals(jID.getDomain())).forEach(workgroupQueueEntity -> element.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{workgroupQueueEntity.getJid().toString(), workgroupQueueEntity.getJid().getLocalpart()})));
        this.write(packet.okResult(element, 0));
    }
}

