/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.StringUtilities;
import tigase.util.dns.DNSResolverFactory;
import tigase.vhosts.VHostItem;
import tigase.vhosts.filter.CustomDomainFilter;
import tigase.vhosts.filter.DomainFilterPolicy;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;

@Bean(name="domain-filter", parent=SessionManager.class, active=true)
public class DomainFilter
extends XMPPProcessor
implements XMPPPacketFilterIfc,
XMPPPreprocessorIfc {
    public static final String ALLOWED_DOMAINS_KEY = "allowed-domains";
    public static final String ALLOWED_DOMAINS_LIST_KEY = "allowed-domains-list";
    protected static final String ID = "domain-filter";
    private static final Logger log = Logger.getLogger(DomainFilter.class.getName());
    private static final String[][] ELEMENTS = ALL_PATHS;
    private static final String[] XMLNSS = new String[]{"*"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static String local_hostname = DNSResolverFactory.getInstance().getDefaultHost();

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Filtering (packet): {0}", packet);
        }
        if (session == null || results == null || results.size() == 0) {
            return;
        }
        try {
            DomainFilterPolicy domains = this.getDomains(session);
            if (domains == DomainFilterPolicy.ALL) {
                return;
            }
            ArrayDeque<Packet> errors = new ArrayDeque<Packet>(1);
            Iterator<Packet> it = results.iterator();
            while (it.hasNext()) {
                Packet res = (Packet)it.next();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Filtering (result): {0}", res);
                }
                if (domains == DomainFilterPolicy.BLOCK) {
                    if (res.getType() == StanzaType.error || (res.getStanzaFrom() == null || session.isUserId(res.getStanzaFrom().getBareJID())) && (res.getStanzaTo() == null || session.isUserId(res.getStanzaTo().getBareJID()))) continue;
                    this.removePacket(it, res, errors, "Communication blocked.");
                    continue;
                }
                String outDomain = null;
                if (res.getStanzaTo() != null) {
                    outDomain = res.getStanzaTo().getDomain();
                }
                switch (domains) {
                    case LOCAL: {
                        if (outDomain != null && !session.isLocalDomain(outDomain, true) && !outDomain.equals(local_hostname)) {
                            this.removePacket(it, res, errors, "You can only communicate within the server local domains.");
                            if (!log.isLoggable(Level.FINEST)) break;
                            log.log(Level.FINEST, "LOCAL Domains only, blocking packet (filter): {0}", res);
                            break;
                        }
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "LOCAL Domains only, packet not blocked (filter): {0}", res);
                        break;
                    }
                    case OWN: {
                        if (outDomain != null && !outDomain.equals(local_hostname) && !outDomain.endsWith(session.getDomain().getVhost().getDomain())) {
                            this.removePacket(it, res, errors, "You can only communicate within your own domain.");
                            if (!log.isLoggable(Level.FINEST)) break;
                            log.log(Level.FINEST, "OWN Domain only, blocking packet (filter): {0}", res);
                            break;
                        }
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "OWN Domain only, packet not blocked (filter): {0}", res);
                        break;
                    }
                    case CUSTOM: {
                        String[] customRules = this.getDomainsList(session);
                        if (outDomain == null || outDomain.equals(local_hostname) || res.getType() != null && res.getType().equals((Object)StanzaType.error) || res.getStanzaFrom() == null && res.getStanzaTo() != null && session.isUserId(res.getStanzaTo().getBareJID())) break;
                        boolean isAlowed = CustomDomainFilter.isAllowed(res.getStanzaFrom(), res.getStanzaTo(), customRules);
                        if (!isAlowed) {
                            this.removePacket(it, res, errors, "Your packet was blocked by server filtering rules - FORBIDDEN");
                            if (!log.isLoggable(Level.FINEST)) break;
                            log.log(Level.FINEST, "CUSTOM filtering rules for domain {0}, blocking packet (filter): {1}, rules: {2}", new Object[]{outDomain, res, Arrays.asList(customRules)});
                            break;
                        }
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "CUSTOM filtering rules for domain {0}, packet not blocked (filter): {1}, rules: {2}", new Object[]{outDomain, res, Arrays.asList(customRules)});
                        break;
                    }
                    case BLACKLIST: {
                        String[] blacklistedDomains = this.getDomainsList(session);
                        boolean blacklist_match = false;
                        if (outDomain == null || outDomain.equals(local_hostname)) break;
                        for (String domain : blacklistedDomains) {
                            if (domain != outDomain) continue;
                            blacklist_match = true;
                            break;
                        }
                        if (blacklist_match) {
                            this.removePacket(it, res, errors, "You attempted to communicate with the blacklisted domain - FORBIDDEN");
                            if (!log.isLoggable(Level.FINEST)) break;
                            log.log(Level.FINEST, "BLACKLIST domain {1}, blocking packet (filter): {0}", new Object[]{res, outDomain});
                            break;
                        }
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "BLACKLIST domain {1], packet not blocked (filter): {0}", new Object[]{res, outDomain});
                        break;
                    }
                    case LIST: {
                        String[] allowedDomains = this.getDomainsList(session);
                        boolean found = false;
                        if (outDomain == null || outDomain.equals(local_hostname)) break;
                        for (String domain : allowedDomains) {
                            if (domain != outDomain) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.removePacket(it, res, errors, "You can only communicate within selected list of domains.");
                            if (!log.isLoggable(Level.FINEST)) break;
                            log.log(Level.FINEST, "LIST Domain only {1}, blocking packet (filter): {0}", new Object[]{res, outDomain});
                            break;
                        }
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "LIST Domain only {1}, packet not blocked (filter): {0}", new Object[]{res, outDomain});
                    }
                }
            }
            results.addAll(errors);
        }
        catch (NotAuthorizedException domains) {
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Can''t access user repository.", ex);
        }
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing: {0}", packet);
        }
        boolean stop = false;
        if (session == null || session.isServerSession()) {
            return stop;
        }
        try {
            DomainFilterPolicy domains = this.getDomains(session);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "DOMAINS setting is: {0}", domains.name());
            }
            if (domains == DomainFilterPolicy.ALL) {
                return stop;
            }
            String outDomain = packet.getStanzaFrom() != null ? packet.getStanzaFrom().getDomain() : null;
            try {
                if (session.getConnectionId().equals((Object)packet.getPacketFrom())) {
                    outDomain = packet.getStanzaTo() != null ? packet.getStanzaTo().getDomain() : null;
                }
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.WARNING, "No connection id for session, even though this is not a server session: {0}, request: {1}", new Object[]{session, packet});
            }
            switch (domains) {
                case BLOCK: {
                    if (packet.getType() == StanzaType.error || packet.getStanzaFrom() == null || session.isUserId(packet.getStanzaFrom().getBareJID()) && (packet.getStanzaTo() == null || session.isUserId(packet.getStanzaTo().getBareJID()))) {
                        return stop;
                    }
                    this.removePacket(null, packet, results, "Communication blocked.");
                    stop = true;
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "BLOCK, blocking packet: {0}", packet);
                    break;
                }
                case LOCAL: {
                    if (outDomain != null && !session.isLocalDomain(outDomain, true)) {
                        this.removePacket(null, packet, results, "You can only communicate within the server local domains.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "LOCAL Domains only {1}, blocking packet: {0}", new Object[]{packet, outDomain});
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "LOCAL Domains only {1}, packet not blocked: {0}", new Object[]{packet, outDomain});
                    break;
                }
                case OWN: {
                    if (outDomain != null && !outDomain.equals(local_hostname) && !outDomain.endsWith(session.getDomain().getVhost().getDomain())) {
                        this.removePacket(null, packet, results, "You can only communicate within your own domain.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "OWN Domain only {1}, blocking packet: {0}", new Object[]{packet, outDomain});
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "OWN Domain only {1}, packet not blocked: {0}", new Object[]{packet, outDomain});
                    break;
                }
                case CUSTOM: {
                    String[] customRules = this.getDomainsList(session);
                    if (outDomain == null || outDomain.equals(local_hostname) || packet.getType() == StanzaType.error || packet.getStanzaFrom() == null && packet.getStanzaTo() != null && session.isUserId(packet.getStanzaTo().getBareJID())) {
                        log.log(Level.FINEST, "Skipping filtering system packet: {0}, outDomain: {1}, local_hostname: {2}", new Object[]{packet, outDomain, local_hostname});
                        break;
                    }
                    boolean isAlowed = CustomDomainFilter.isAllowed(packet.getStanzaFrom(), packet.getStanzaTo(), customRules);
                    if (!isAlowed) {
                        this.removePacket(null, packet, results, "Your packet was blocked by server filtering rules - FORBIDDEN");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "CUSTOM filtering rules {0}, blocking packet (filter): {1}", new Object[]{outDomain, packet});
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "CUSTOM filtering rules {0}, packet not blocked (filter): {1}", new Object[]{outDomain, packet});
                    break;
                }
                case BLACKLIST: {
                    String[] disallowedDomains = this.getDomainsList(session);
                    boolean blacklist_match = false;
                    if (outDomain == null || outDomain.equals(local_hostname)) break;
                    for (String domain : disallowedDomains) {
                        if (domain != outDomain) continue;
                        blacklist_match = true;
                        break;
                    }
                    if (blacklist_match) {
                        this.removePacket(null, packet, results, "You attempted to communicate with the blacklisted domain - FORBIDDEN");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "Packet to blacklisted domain {1}, blocking packet: {0}", new Object[]{packet, outDomain});
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "Packet NOT TO blacklisted domain {1}, NOT blocking packet: {0}", new Object[]{packet, outDomain});
                    break;
                }
                case LIST: {
                    String[] allowedDomains = this.getDomainsList(session);
                    boolean found = false;
                    if (outDomain == null || outDomain.equals(local_hostname)) break;
                    for (String domain : allowedDomains) {
                        if (domain != outDomain) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.removePacket(null, packet, results, "You can only communicate within selected list of domains.");
                        stop = true;
                        if (!log.isLoggable(Level.FINEST)) break;
                        log.log(Level.FINEST, "LISTED Domains only {1}, blocking packet: {0}", new Object[]{packet, outDomain});
                        break;
                    }
                    if (!log.isLoggable(Level.FINEST)) break;
                    log.log(Level.FINEST, "LISTED Domain only {1}, packet not blocked: {0}", new Object[]{packet, outDomain});
                }
            }
        }
        catch (NotAuthorizedException domains) {
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Can''t access user repository.", ex);
        }
        return stop;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    public DomainFilterPolicy getDomains(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        VHostItem domain = session.getDomain();
        DomainFilterPolicy domainFilterPolicy = (DomainFilterPolicy)((Object)session.getCommonSessionData(ALLOWED_DOMAINS_KEY));
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Domains read from user session: {0} for VHost: {1}", new Object[]{domainFilterPolicy, domain.getKey()});
        }
        if (domainFilterPolicy == null) {
            String dbDomains = session.getData(null, ALLOWED_DOMAINS_KEY, null);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Domains read from database: {0} for VHost: {1}", new Object[]{dbDomains, domain.getKey()});
            }
            if ((domainFilterPolicy = DomainFilterPolicy.valueof(dbDomains)) == null) {
                domainFilterPolicy = session.isAnonymous() ? DomainFilterPolicy.LOCAL : domain.getDomainFilter();
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Domains read from VHost item: {0} for VHost: {1}", new Object[]{domainFilterPolicy, domain.getKey()});
            }
            session.putCommonSessionData(ALLOWED_DOMAINS_KEY, (Object)domainFilterPolicy);
        }
        return domainFilterPolicy;
    }

    public String[] getDomainsList(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        VHostItem domain = session.getDomain();
        String[] domainsList = (String[])session.getCommonSessionData(ALLOWED_DOMAINS_LIST_KEY);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting list of domains from user session: {0} for VHost: {1}", new Object[]{domainsList != null ? Arrays.asList(domainsList) : "", domain.getKey()});
        }
        if (domainsList == null) {
            String dbDomains = session.getData(null, ALLOWED_DOMAINS_LIST_KEY, null);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Domains list read from database: {0} for VHost: {1}", new Object[]{dbDomains, domain.getKey()});
            }
            if (dbDomains != null) {
                domainsList = StringUtilities.stringToArrayOfString((String)dbDomains, (String)";");
            } else {
                domainsList = domain.getDomainFilterDomains();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Domains list read from VHost: {0} for VHost: {1}", new Object[]{domainsList != null ? Arrays.asList(domainsList) : "", domain.getKey()});
                }
            }
            if (domainsList == null) {
                domainsList = EMPTY_STRING_ARRAY;
            }
            session.putCommonSessionData(ALLOWED_DOMAINS_LIST_KEY, domainsList);
        }
        return domainsList;
    }

    private void removePacket(Iterator<Packet> it, Packet res, Queue<Packet> errors, String msg) {
        if (it != null) {
            it.remove();
        }
        try {
            errors.add(Authorization.FORBIDDEN.getResponseMessage(res, msg, true));
        }
        catch (PacketErrorTypeException ex) {
            log.log(Level.FINE, "Already error packet, dropping it..: {0}", res);
        }
    }
}

