/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.Kernel;
import tigase.stats.StatisticsArchivizerIfc;
import tigase.stats.StatisticsCollector;
import tigase.stats.StatisticsProvider;
import tigase.stats.db.CounterDataLoggerRepoBean;
import tigase.util.dns.DNSResolverFactory;

@Bean(name="counter-data-logger", parent=StatisticsCollector.class, active=false)
public class CounterDataLogger
implements StatisticsArchivizerIfc,
ConfigurationChangedAware,
Initializable,
RegistrarBean {
    private static final Logger log = Logger.getLogger(CounterDataLogger.class.getName());
    protected static String defaultHostname;
    @ConfigField(desc="Frequency")
    private long frequency = -1L;
    private long last_c2s_packets = 0L;
    private long last_ext_packets = 0L;
    private long last_iqs = 0L;
    private long last_messages = 0L;
    private long last_muc_packets = 0L;
    private long last_presences = 0L;
    private long last_pubsub_packets = 0L;
    private long last_s2s_packets = 0L;
    private long last_sm_packets = 0L;
    private long last_ws2s_packets = 0L;
    @Inject
    private CounterDataLoggerRepoBean repository;

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        defaultHostname = DNSResolverFactory.getInstance().getDefaultHost();
    }

    @Override
    public void execute(StatisticsProvider sp) {
        long c2s_packets = sp.getCompPackets("c2s");
        long ws2s_packets = sp.getCompPackets("ws2s");
        long ext_packets = sp.getCompPackets("ext");
        long iqs = sp.getCompIqs("sess-man");
        long messages = sp.getCompMessages("sess-man");
        long muc_packets = sp.getCompPackets("muc");
        long presences = sp.getCompPresences("sess-man");
        long pubsub_packets = sp.getCompPackets("pubsub");
        long s2s_packets = sp.getCompPackets("s2s");
        long sm_packets = sp.getSMPacketsNumber();
        int sm_connections = sp.getStats("sess-man", "Open user connections", 0);
        int sm_sessions = sp.getStats("sess-man", "Open user sessions", 0);
        this.repository.addStatsLogEntry(defaultHostname, sp.getCPUUsage(), sp.getHeapMemUsage(), sp.getUptime(), sp.getStats("vhost-man", "Number of VHosts", 0), sm_packets - this.last_sm_packets, muc_packets - this.last_muc_packets, pubsub_packets - this.last_pubsub_packets, c2s_packets - this.last_c2s_packets, ws2s_packets - this.last_ws2s_packets, s2s_packets - this.last_s2s_packets, ext_packets - this.last_ext_packets, presences - this.last_presences, messages - this.last_messages, iqs - this.last_iqs, sp.getRegistered(), sp.getCompConnections("c2s"), sp.getCompConnections("ws2s"), sp.getCompConnections("bosh"), sp.getCompConnections("s2s"), sm_connections, sm_sessions);
        this.last_c2s_packets = c2s_packets;
        this.last_ws2s_packets = ws2s_packets;
        this.last_ext_packets = ext_packets;
        this.last_iqs = iqs;
        this.last_messages = messages;
        this.last_muc_packets = muc_packets;
        this.last_presences = presences;
        this.last_pubsub_packets = pubsub_packets;
        this.last_s2s_packets = s2s_packets;
        this.last_sm_packets = sm_packets;
    }

    @Override
    public long getFrequency() {
        return this.frequency;
    }

    @Override
    public void initialize() {
        this.beanConfigurationChanged(Collections.emptyList());
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    @Override
    public void release() {
    }
}

