/*
 * Decompiled with CFR 0.152.
 */
package tigase.io.repo;

import java.io.CharArrayReader;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateUtil;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;

public class CertificateItem
extends RepositoryItemAbstract {
    public static final String PEM_CERTIFICATE_KEY = "pem-certificate";
    public static final String FINGERPRINT_KEY = "fingerprint";
    public static final String SERIALNUMBER_KEY = "serial-number";
    public static final String IS_DEFAULT_KEY = "is-default";
    public static final String ALIAS_KEY = "alias";
    public static final String REPO_ITEM_ELEM_NAME = "certificate";
    private static final Logger log = Logger.getLogger(CertificateItem.class.getName());
    private String alias;
    private CertificateEntry entry;
    private String fingerprint;
    private boolean isDefault;
    private String serialNumber;

    public CertificateItem() {
    }

    public CertificateItem(String alias, CertificateEntry entry) {
        Objects.requireNonNull(alias);
        Objects.requireNonNull(entry);
        if ("default".equals(alias)) {
            this.isDefault = true;
            this.alias = CertificateUtil.getCertCName((X509Certificate)((X509Certificate)entry.getCertificate().get()));
        } else {
            this.alias = alias;
        }
        this.entry = entry;
        try {
            if (entry.getCertificate().isPresent()) {
                Certificate certificate = (Certificate)entry.getCertificate().get();
                this.fingerprint = CertificateUtil.getCertificateFingerprint((Certificate)certificate);
                CertificateUtil.getCertificateSerialNumber((Certificate)certificate).ifPresent(serialNumber -> {
                    this.serialNumber = serialNumber.toString(16);
                });
            }
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            log.log(Level.WARNING, "Failing creating Certificate item", e);
        }
    }

    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(this.serialNumber);
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Optional<String> getFingerprint() {
        return Optional.ofNullable(this.fingerprint);
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Override
    public String getKey() {
        return this.getAlias();
    }

    @Override
    protected void setKey(String key) {
        this.setAlias(key);
    }

    @Override
    public String getElemName() {
        return REPO_ITEM_ELEM_NAME;
    }

    public CertificateEntry getCertificateEntry() {
        return this.entry;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void initFromCommand(Packet packet) {
        log.log(Level.FINEST, "Initiating item from command");
        super.initFromCommand(packet);
        this.alias = Command.getFieldValue(packet, ALIAS_KEY);
        this.fingerprint = Command.getFieldValue(packet, FINGERPRINT_KEY);
        this.serialNumber = Command.getFieldValue(packet, SERIALNUMBER_KEY);
        this.isDefault = Boolean.parseBoolean(Command.getFieldValue(packet, IS_DEFAULT_KEY));
        String pemCertificate = Command.getFieldValue(packet, PEM_CERTIFICATE_KEY);
        try {
            this.entry = CertificateUtil.parseCertificate((Reader)new CharArrayReader(pemCertificate.toCharArray()));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error while loading certificate from PEM format", e);
        }
    }

    @Override
    public void addCommandFields(Packet packet) {
        super.addCommandFields(packet);
        Command.addFieldValue(packet, ALIAS_KEY, this.alias);
        if (this.getFingerprint().isPresent()) {
            Command.addFieldValue(packet, FINGERPRINT_KEY, this.getFingerprint().get());
        }
        if (this.getSerialNumber().isPresent()) {
            Command.addFieldValue(packet, SERIALNUMBER_KEY, this.getSerialNumber().get());
        }
        Command.addFieldValue(packet, IS_DEFAULT_KEY, String.valueOf(this.isDefault));
        try {
            String pemCertificate = CertificateUtil.exportToPemFormat((CertificateEntry)this.entry);
            Command.addFieldValue(packet, PEM_CERTIFICATE_KEY, pemCertificate);
        }
        catch (CertificateEncodingException e) {
            log.log(Level.WARNING, "Error converting certificate entry to PEM format", e);
        }
    }

    @Override
    public void initFromElement(Element elem) {
        log.log(Level.FINEST, "Initiating item from element: " + elem);
        if (elem.getName() != REPO_ITEM_ELEM_NAME) {
            throw new IllegalArgumentException("Incorrect element name, expected: certificate");
        }
        super.initFromElement(elem);
        this.setAlias(elem.getAttributeStaticStr(ALIAS_KEY));
        this.setFingerprint(elem.getAttributeStaticStr(FINGERPRINT_KEY));
        this.setDefault(Boolean.parseBoolean(elem.getAttributeStaticStr(IS_DEFAULT_KEY)));
        String pemCertificate = elem.getCData();
        if (pemCertificate == null) {
            pemCertificate = elem.getAttributeStaticStr(PEM_CERTIFICATE_KEY);
        }
        if (pemCertificate == null) {
            throw new IllegalArgumentException("Certificate is missing - neither as element attribute or CData: " + elem);
        }
        try {
            this.entry = CertificateUtil.parseCertificate((Reader)new CharArrayReader(pemCertificate.toCharArray()));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error while loading certificate from PEM format: " + elem, e);
        }
        String serialNumberVal = elem.getAttributeStaticStr(SERIALNUMBER_KEY);
        if (serialNumberVal != null) {
            this.setSerialNumber(serialNumberVal);
        } else if (this.entry.getCertificate().isPresent()) {
            CertificateUtil.getCertificateSerialNumber((Certificate)((Certificate)this.entry.getCertificate().get())).ifPresent(serialNumber -> this.setSerialNumber(serialNumber.toString(16)));
        }
    }

    @Override
    public void initFromPropertyString(String propString) {
        throw new UnsupportedOperationException("Configuring via property string is not supported");
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    @Override
    public Element toElement() {
        Element elem = super.toElement();
        elem.addAttribute(ALIAS_KEY, this.alias);
        if (this.getFingerprint().isPresent()) {
            elem.addAttribute(FINGERPRINT_KEY, this.getFingerprint().get());
        }
        if (this.getSerialNumber().isPresent()) {
            elem.addAttribute(SERIALNUMBER_KEY, this.getSerialNumber().get());
        }
        elem.addAttribute(IS_DEFAULT_KEY, String.valueOf(this.isDefault()));
        try {
            String pemCertificate = CertificateUtil.exportToPemFormat((CertificateEntry)this.entry);
            elem.setCData(pemCertificate);
        }
        catch (CertificateEncodingException e) {
            log.log(Level.WARNING, "Error converting certificate entry to PEM format", e);
        }
        return elem;
    }

    public String toString() {
        return "CertificateItem{alias='" + this.alias + "', fingerprint='" + this.fingerprint + "', isDefault=" + this.isDefault + ", serialNumber='" + this.serialNumber + "'}";
    }

    @Override
    public String toPropertyString() {
        throw new UnsupportedOperationException("Configuring via property string is not supported");
    }
}

