/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import tigase.jaxmpp.core.client.SessionObject;

public class ConnectionConfiguration
extends tigase.jaxmpp.core.client.ConnectionConfiguration {
    ConnectionConfiguration(SessionObject sessionObject) {
        super(sessionObject);
    }

    public void setBoshService(String boshService) {
        this.sessionObject.setUserProperty("BOSH_SERVICE_URL_KEY", (Object)boshService);
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.sessionObject.setUserProperty("connectorType", (Object)connectionType.name());
    }

    public void setDisableTLS(boolean disabled) {
        this.sessionObject.setUserProperty("TLS_DISABLED", (Object)disabled);
    }

    public void setPort(int port) {
        this.sessionObject.setUserProperty("socket#ServerPort", (Object)port);
    }

    public void setProxy(String host, int port) {
        this.sessionObject.setUserProperty("PROXY_HOST_KEY", (Object)host);
        this.sessionObject.setUserProperty("PROXY_PORT_KEY", (Object)port);
    }

    public void setProxyType(Proxy.Type type) {
        this.sessionObject.setUserProperty("PROXY_TYPE_KEY", (Object)type);
    }

    public void setProxyUsernamePassword(final String username, final String password) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                String host = "" + ConnectionConfiguration.this.sessionObject.getProperty("PROXY_HOST_KEY");
                int port = (Integer)ConnectionConfiguration.this.sessionObject.getProperty("PROXY_PORT_KEY");
                if (this.getRequestingHost().equalsIgnoreCase(host) && port == this.getRequestingPort()) {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
                return null;
            }
        });
    }

    public void setServer(String server) {
        this.sessionObject.setUserProperty("socket#ServerHost", (Object)server);
    }

    public void setUseSASL(boolean useSASL) {
        this.sessionObject.setUserProperty("jaxmpp#forceNonSASL", (Object)(!useSASL ? 1 : 0));
    }

    public static enum ConnectionType {
        bosh,
        socket,
        websocket;

    }
}

