/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import groovy.json.JsonSlurper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import tigase.push.apns.APNSUtil;
import tigase.push.apns.ApnsDelegate;
import tigase.push.apns.ApnsNotification;
import tigase.push.apns.ApnsServiceException;
import tigase.xmpp.Authorization;

public class ApnsService {
    private static final Logger a = Logger.getLogger(ApnsService.class.getCanonicalName());
    private final String b;
    private final HttpClient c;

    private ApnsService(Builder builder) throws IOException {
        try {
            this.b = builder.c;
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("sunx509");
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            TrustManager[] trustManagerArray2 = new TrustManager[trustManagerArray.length + 1];
            for (int i = 0; i < trustManagerArray.length; ++i) {
                trustManagerArray2[i + 1] = trustManagerArray[i];
            }
            trustManagerArray2[0] = new SSLTrustManager(trustManagerFactory.getTrustManagers());
            sSLContext.init(builder.f.getKeyManagers(), trustManagerArray2, null);
            SSLParameters sSLParameters = sSLContext.getSupportedSSLParameters();
            sSLParameters.setApplicationProtocols(new String[]{"h2"});
            HttpClient.Builder builder2 = HttpClient.newBuilder().sslContext(sSLContext).sslParameters(sSLParameters);
            if (builder.e != null) {
                builder2.executor(builder.e);
            }
            this.c = builder2.version(HttpClient.Version.HTTP_2).build();
        }
        catch (Exception exception) {
            throw new IOException("Could not initialize HttpClient", exception);
        }
    }

    public CompletableFuture<String> push(ApnsNotification notification) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        this.push(notification, completableFuture);
        return completableFuture;
    }

    public void push(ApnsNotification notification, CompletableFuture<String> future) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create("https://" + this.b + "/3/device/" + notification.getDeviceId())).POST(HttpRequest.BodyPublishers.ofString(notification.getPayload().toPayloadString())).header("apns-id", notification.getId()).header("apns-expiration", "0").header("apns-priority", String.valueOf(notification.getPriority()));
        if (notification.getPushType() != ApnsNotification.PushType.voip) {
            builder.header("apns-push-type", notification.getPushType().name());
        }
        if (notification.getCollapseId() != null) {
            builder.header("apns-collapse-id", notification.getCollapseId());
        }
        if (notification.getTopic() != null) {
            builder.header("apns-topic", notification.getTopic());
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "trying to send push notification " + notification + " at " + this);
        }
        ((CompletableFuture)this.c.sendAsync(builder.build(), responseInfo -> HttpResponse.BodySubscribers.ofString(Charset.forName("UTF-8"))).thenAccept(httpResponse -> {
            ErrorCode errorCode;
            String string = httpResponse.headers().firstValue("apns-id").get();
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "GOT response " + httpResponse.statusCode() + " " + (String)httpResponse.body() + " apns-id " + string);
            }
            if ((errorCode = ErrorCode.fromStatus(httpResponse.statusCode())) == null) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "sent notification: " + notification.toString() + " at " + this);
                }
                future.complete(string);
            } else {
                Map map2 = (Map)new JsonSlurper().parse((Reader)new StringReader((String)httpResponse.body()));
                ErrorType errorType = Optional.ofNullable(map2).map(map -> map.get("reason")).map(Object::toString).map(ErrorType::from).orElse(ErrorType.unknownError);
                a.log(Level.FINEST, "failed to send notification: " + notification.toString() + " at " + this + ", error: " + errorCode.name() + ", response: " + (String)httpResponse.body());
                future.completeExceptionally((Throwable)((Object)new ApnsServiceException(errorCode, errorType)));
            }
        })).exceptionally(throwable -> {
            a.log(Level.FINEST, "failed to send notification: " + notification.toString() + " at " + this + ", exception thrown!", (Throwable)throwable);
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
    }

    public void stop() {
    }

    public String toString() {
        return "ApnsService{apnsEndoint='" + this.b + "'}";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class SSLTrustManager
    implements X509TrustManager {
        private static final String[] a = new String[]{"c0554bde87a075ec13a61f275983ae023957294b454caf0a9724e3b21b7935bc", "56e98deac006a729afa2ed79f9e419df69f451242596d2aaf284c74a855e352e", "7289c06dedd16b71a7dcca66578572e2e109b11d70ad04c2601b6743bc66d07b", "fae46000d8f7042558541e98acf351279589f83b6d3001c18442e4403d111849", "b5cf82d47ef9823f9aa78f123186c52e8879ea84b0f822c91d83e04279b78fd5", "e24f8e8c2185da2f5e88d4579e817c47bf6eafbc8505f0f960fd5a0df4473ad3", "3174d9092f9531c06026ba489891016b436d5ec02623f9aafe2009ecc3e4d557"};
        private static final byte[][] b = (byte[][])Arrays.stream(a).map(SSLTrustManager::hexDecode).toArray(n -> new byte[n][]);
        private final TrustManager[] c;

        public SSLTrustManager(TrustManager[] trustManagers) {
            this.c = trustManagers;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            Optional<X509TrustManager> optional = Arrays.stream(this.c).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst();
            if (optional.isEmpty()) {
                throw new CertificateException("Could not verify certificate validity");
            }
            optional.get().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.checkCertificateChainFingerprint(chain)) {
                return;
            }
            Optional<X509TrustManager> optional = Arrays.stream(this.c).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst();
            if (optional.isEmpty()) {
                throw new CertificateException("Could not verify certificate validity");
            }
            optional.get().checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        protected boolean checkCertificateChainFingerprint(X509Certificate[] chain) {
            try {
                for (int i = 0; i < chain.length; ++i) {
                    if (!this.checkCerificateFingerprint(chain[i])) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                a.log(Level.FINEST, "Could not check certificate fingerprint", throwable);
            }
            return false;
        }

        protected boolean checkCerificateFingerprint(X509Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
            byte[] byArray = SSLTrustManager.sha256(certificate.getPublicKey().getEncoded());
            return Arrays.stream(b).anyMatch(byArray2 -> Arrays.equals(byArray2, byArray));
        }

        public static byte[] hexDecode(String hex) {
            int n = hex.length();
            byte[] byArray = new byte[n / 2];
            for (int i = 0; i < n; i += 2) {
                byArray[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
            }
            return byArray;
        }

        public static byte[] sha256(byte[] data) throws NoSuchAlgorithmException {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return messageDigest.digest(data);
        }
    }

    public static enum ErrorType {
        badCollapseId,
        badDeviceToken,
        badExpirationDate,
        badMessageId,
        badPriority,
        badTopic,
        deviceTokenNotForTopic,
        duplicatedHeaders,
        idleTimeout,
        invalidPushType,
        missingDeviceToken,
        missingTopic,
        payloadEmpty,
        topicDisallowed,
        badCertificate,
        badCertificateEnvironment,
        expiredProviderToken,
        forbidden,
        invalidProviderToken,
        missingProviderToken,
        badPath,
        methodNotAllowed,
        unregistred,
        payloadTooLarge,
        tooManyProviderTokenUpdates,
        tooManyRequests,
        internalServerError,
        serviceUnavailable,
        shutdown,
        unknownError;


        public static ErrorType from(String type) {
            if (type == null) {
                return unknownError;
            }
            switch (type) {
                case "BadCollapseId": {
                    return badCollapseId;
                }
                case "BadDeviceToken": {
                    return badDeviceToken;
                }
                case "BadExpirationDate": {
                    return badExpirationDate;
                }
                case "BadMessageId": {
                    return badMessageId;
                }
                case "BadPriority": {
                    return badPriority;
                }
                case "BadTopic": {
                    return badTopic;
                }
                case "DeviceTokenNotForTopic": {
                    return deviceTokenNotForTopic;
                }
                case "DuplicateHeaders": {
                    return duplicatedHeaders;
                }
                case "IdleTimeout": {
                    return idleTimeout;
                }
                case "InvalidPushType": {
                    return invalidPushType;
                }
                case "MissingDeviceToken": {
                    return missingDeviceToken;
                }
                case "MissingTopic": {
                    return missingTopic;
                }
                case "PayloadEmpty": {
                    return payloadEmpty;
                }
                case "TopicDisallowed": {
                    return topicDisallowed;
                }
                case "BadCertificate": {
                    return badCertificate;
                }
                case "BadCertificateEnvironment": {
                    return badCertificateEnvironment;
                }
                case "ExpiredProviderToken": {
                    return expiredProviderToken;
                }
                case "Forbidden": {
                    return forbidden;
                }
                case "InvalidProviderToken": {
                    return invalidProviderToken;
                }
                case "MissingProviderToken": {
                    return missingProviderToken;
                }
                case "BadPath": {
                    return badPath;
                }
                case "MethodNotAllowed": {
                    return methodNotAllowed;
                }
                case "Unregistered": {
                    return unregistred;
                }
                case "PayloadTooLarge": {
                    return payloadTooLarge;
                }
                case "TooManyProviderTokenUpdates": {
                    return tooManyProviderTokenUpdates;
                }
                case "TooManyRequests": {
                    return tooManyRequests;
                }
                case "InternalServerError": {
                    return internalServerError;
                }
                case "ServiceUnavailable": {
                    return serviceUnavailable;
                }
                case "Shutdown": {
                    return shutdown;
                }
            }
            return unknownError;
        }

        public Authorization getErrorCondition() {
            switch (this) {
                case badDeviceToken: 
                case deviceTokenNotForTopic: 
                case unregistred: {
                    return Authorization.ITEM_NOT_FOUND;
                }
                case topicDisallowed: {
                    return Authorization.NOT_ALLOWED;
                }
                case payloadTooLarge: {
                    return Authorization.POLICY_VIOLATION;
                }
                case tooManyRequests: {
                    return Authorization.RESOURCE_CONSTRAINT;
                }
            }
            return Authorization.INTERNAL_SERVER_ERROR;
        }

        public boolean shouldRetry() {
            switch (this) {
                case internalServerError: 
                case serviceUnavailable: 
                case shutdown: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum ErrorCode {
        badRequest,
        authenticationFailure,
        invalidMethod,
        deviceTokenInactive,
        payloadTooLarge,
        tooManyRequestsForDeviceToken,
        internalServerError,
        serverShutdown;


        public static ErrorCode fromStatus(int statusCode) {
            switch (statusCode) {
                case 200: {
                    return null;
                }
                case 400: {
                    return badRequest;
                }
                case 403: {
                    return authenticationFailure;
                }
                case 405: {
                    return invalidMethod;
                }
                case 410: {
                    return deviceTokenInactive;
                }
                case 413: {
                    return payloadTooLarge;
                }
                case 429: {
                    return tooManyRequestsForDeviceToken;
                }
                case 500: {
                    return internalServerError;
                }
                case 503: {
                    return serverShutdown;
                }
            }
            return internalServerError;
        }
    }

    public static class Builder {
        private static final String a = "api.sandbox.push.apple.com";
        private static final String b = "api.push.apple.com";
        private String c = "api.push.apple.com";
        private ApnsDelegate d;
        private Executor e;
        private KeyManagerFactory f;

        private Builder() {
        }

        public Builder withAppleDestination(boolean value) {
            this.c = value ? b : a;
            return this;
        }

        public Builder withCert(String certificatePath, String base64certificate, String certificatePassword) throws IOException {
            if (base64certificate != null) {
                return this.withBase64Cert(base64certificate, certificatePassword);
            }
            if (certificatePath != null) {
                return this.withCert(certificatePath, certificatePassword);
            }
            return this;
        }

        public Builder withCert(String certPath, String certPass) throws IOException {
            try (FileInputStream fileInputStream = new FileInputStream(certPath);){
                Builder builder = this.withCert(fileInputStream, certPass);
                return builder;
            }
        }

        public Builder withCert(InputStream is, String certPass) throws IOException {
            KeyStore keyStore = APNSUtil.loadCertificate(is, certPass);
            return this.withCertificateKeyStore(keyStore, certPass);
        }

        public Builder withCertificateKeyStore(KeyStore keyStore, String keyStorePassword) throws IOException {
            try {
                this.f = KeyManagerFactory.getInstance("sunx509");
                this.f.init(keyStore, keyStorePassword.toCharArray());
                return this;
            }
            catch (Exception exception) {
                throw new IOException("Could not initialize key manager factory", exception);
            }
        }

        public ApnsService build() throws IOException {
            return new ApnsService(this);
        }

        public Builder withBase64Cert(String base64certificate, String certificatePassword) throws IOException {
            return this.withCert(APNSUtil.inputStreamFromBase64(base64certificate), certificatePassword);
        }
    }
}

