/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.db.TigaseDBException;
import tigase.http.upload.db.FileUploadRepository;
import tigase.http.upload.logic.Logic;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class QueryFilesCommandAbstract
implements AdHocCommand {
    private static final TimestampHelper timestampHelper = new TimestampHelper();
    @Inject
    private Logic logic;
    @Inject
    private FileUploadRepository repository;
    @Inject
    private AdHocCommandModule.ScriptCommandProcessor scriptCommandProcessor;
    protected final boolean isAdmin;

    protected QueryFilesCommandAbstract(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        if (request.isAction("cancel")) {
            response.cancelSession();
            return;
        }
        Optional<QueryType> queryType = this.isAdmin ? Optional.ofNullable(Command.getFieldValue((Packet)request.getIq(), (String)"type")).map(QueryType::valueOf) : Optional.of(QueryType.user);
        Optional<BareJID> user = this.isAdmin ? Optional.ofNullable(Command.getFieldValue((Packet)request.getIq(), (String)"jid")).map(BareJID::bareJIDInstanceNS) : Optional.of(request.getSender().getBareJID());
        Optional<String> domain = this.isAdmin ? Optional.ofNullable(Command.getFieldValue((Packet)request.getIq(), (String)"domain")) : Optional.empty();
        int limit = Optional.ofNullable(Command.getFieldValue((Packet)request.getIq(), (String)"limit")).map(Integer::parseInt).orElse(20);
        String afterId = Command.getFieldValue((Packet)request.getIq(), (String)"after-id");
        if (queryType.isEmpty() || queryType.filter(type -> type == QueryType.user).isPresent() && user.isEmpty() || queryType.filter(type -> type == QueryType.domain).isPresent() && domain.isEmpty()) {
            DataForm.Builder formBuilder = this.prepareQueryFormBuilder(queryType, user, domain, afterId, limit);
            response.getElements().add(formBuilder.build());
            response.setNewState(AdHocResponse.State.executing);
        } else {
            try {
                List<Object> slots = Collections.emptyList();
                switch (queryType.get()) {
                    case user: {
                        if (!request.getSender().getBareJID().equals((Object)user.get()) && !this.scriptCommandProcessor.isAllowed(this.getNode(), user.get().getDomain(), request.getSender())) {
                            throw new AdHocCommandException(Authorization.FORBIDDEN);
                        }
                        slots = this.repository.querySlots(user.get(), afterId, limit);
                        break;
                    }
                    case domain: {
                        if (!this.scriptCommandProcessor.isAllowed(this.getNode(), domain.get(), request.getSender())) {
                            throw new AdHocCommandException(Authorization.FORBIDDEN);
                        }
                        slots = this.repository.querySlots(domain.get(), afterId, limit);
                    }
                }
                DataForm.Builder formBuilder = this.prepareQueryFormBuilder(queryType, user, domain, afterId, limit);
                if (!slots.isEmpty()) {
                    formBuilder = formBuilder.withReported(reported -> {
                        reported.addField(DataForm.FieldType.TextSingle, "id").setLabel("ID").build();
                        reported.addField(DataForm.FieldType.TextSingle, "filename").setLabel("Filename").build();
                        reported.addField(DataForm.FieldType.TextSingle, "filesize").setLabel("File size").build();
                        reported.addField(DataForm.FieldType.TextSingle, "mimetype").setLabel("MIME Type").build();
                        reported.addField(DataForm.FieldType.TextSingle, "timestamp").setLabel("Timestamp").build();
                        reported.addField(DataForm.FieldType.TextSingle, "url").setLabel("URL").build();
                        if (this.isAdmin) {
                            reported.addField(DataForm.FieldType.JidSingle, "uploader").setLabel("Uploader").build();
                        }
                    });
                    for (FileUploadRepository.Slot slot : slots) {
                        formBuilder = formBuilder.withItem(item -> {
                            item.addField("id").setValue(slot.slotId).build();
                            item.addField("filename").setValue(XMLUtils.escape((String)slot.filename)).build();
                            item.addField("filesize").setValue(String.valueOf(slot.filesize)).build();
                            item.addField("mimetype").setValue(XMLUtils.escape((String)slot.contentType)).build();
                            item.addField("timestamp").setValue(timestampHelper.formatWithMs(slot.timestamp)).build();
                            item.addField("url").setValue(XMLUtils.escape((String)this.logic.getDownloadURI(request.getSender(), slot.slotId, slot.filename))).build();
                            if (this.isAdmin) {
                                item.addField("uploader").setValue(slot.uploader.toString()).build();
                            }
                        });
                    }
                }
                response.getElements().add(formBuilder.build());
                response.setNewState(AdHocResponse.State.executing);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new AdHocCommandException(Authorization.FEATURE_NOT_IMPLEMENTED);
            }
            catch (TigaseDBException tigaseDBException) {
                throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR);
            }
        }
    }

    protected DataForm.Builder prepareQueryFormBuilder(Optional<QueryType> queryType, Optional<BareJID> user, Optional<String> domain, String afterId, int limit) {
        DataForm.Builder formBuilder = new DataForm.Builder(Command.DataType.form).addInstructions(new String[]{"Please fill the form"});
        if (this.isAdmin) {
            if (queryType.isEmpty()) {
                formBuilder.withField(DataForm.FieldType.ListSingle, "type", field -> {
                    DataForm.Field.Builder builder = field.setLabel("Type").setOptions(QueryType.options(), QueryType.names());
                });
                return formBuilder;
            }
            formBuilder.withField(DataForm.FieldType.Hidden, "type", field -> {
                DataForm.Field.Builder builder = field.setValue((String)queryType.map(Enum::name).orElse(null));
            });
            switch (queryType.get()) {
                case user: {
                    formBuilder.withField(user.isPresent() ? DataForm.FieldType.Fixed : DataForm.FieldType.JidSingle, "jid", field -> {
                        DataForm.Field.Builder builder = field.setValue((String)user.map(BareJID::toString).orElse(null));
                    });
                    break;
                }
                case domain: {
                    formBuilder.withField(domain.isPresent() ? DataForm.FieldType.Fixed : DataForm.FieldType.TextSingle, "domain", field -> {
                        DataForm.Field.Builder builder = field.setLabel("Domain").setValue((String)domain.orElse(null));
                    });
                }
            }
        }
        return this.addPagingFields(formBuilder, afterId, limit);
    }

    protected DataForm.Builder addPagingFields(DataForm.Builder formBuilder, String afterId, int limit) {
        return formBuilder.withField(DataForm.FieldType.TextSingle, "after-id", field -> {
            DataForm.Field.Builder builder = field.setLabel("After slot with id").setValue(afterId);
        }).withField(DataForm.FieldType.TextSingle, "limit", field -> {
            DataForm.Field.Builder builder = field.setLabel("Limit of slots").setValue(String.valueOf(limit));
        });
    }

    public boolean isAllowedFor(JID jid) {
        return this.scriptCommandProcessor.isAllowed(this.getNode(), jid);
    }

    static enum QueryType {
        user,
        domain;


        String getLabel() {
            return String.valueOf(this.name().substring(0, 1).toUpperCase()) + this.name().substring(1);
        }

        static String[] options() {
            return (String[])Arrays.stream(QueryType.values()).sorted(Comparator.comparing(Enum::name)).map(Enum::name).toArray(String[]::new);
        }

        static String[] names() {
            return (String[])Arrays.stream(QueryType.values()).sorted(Comparator.comparing(Enum::name)).map(QueryType::getLabel).toArray(String[]::new);
        }
    }
}

