/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class XmlWriter {
    private final Writer w;
    private final List elements = new ArrayList();
    private boolean empty;
    private boolean endAttr = true;
    private boolean indent;

    public XmlWriter(Writer w) {
        this(w, true);
    }

    public XmlWriter(Writer w, boolean indent) {
        this.w = w;
        this.indent = indent;
    }

    public XmlWriter indent(int nb) throws IOException {
        if (this.indent) {
            while (nb-- > 0) {
                this.w.append("  ");
            }
        }
        return this;
    }

    public XmlWriter newLine() throws IOException {
        if (this.indent) {
            this.w.append("\n");
        }
        return this;
    }

    public XmlWriter element(String name) throws IOException {
        if (!this.endAttr) {
            this.endAttr = true;
            this.w.append(">");
        }
        if (!this.elements.isEmpty()) {
            this.newLine();
            this.indent(this.elements.size());
        }
        this.w.append("<").append(name);
        this.elements.add(name);
        this.empty = true;
        this.endAttr = false;
        return this;
    }

    public XmlWriter attribute(String name, Object value) throws IOException {
        if (value != null) {
            this.w.append(" ").append(name).append("='").append(XmlWriter.encode(value.toString())).append("'");
        }
        return this;
    }

    public XmlWriter end() throws IOException {
        return this.end(true);
    }

    public XmlWriter end(boolean indent) throws IOException {
        String name = (String)this.elements.remove(this.elements.size() - 1);
        if (!this.endAttr) {
            this.endAttr = true;
            this.w.append("/>");
        } else {
            if (indent && !this.empty) {
                this.newLine();
                this.indent(this.elements.size());
            }
            this.w.append("</").append(name).append(">");
        }
        this.empty = false;
        return this;
    }

    public XmlWriter text(Object value) throws IOException {
        if (!this.endAttr) {
            this.endAttr = true;
            this.w.append(">");
        }
        this.w.append(XmlWriter.encode(value.toString()));
        return this;
    }

    public XmlWriter textElement(String name, Object value) throws IOException {
        if (value != null) {
            this.element(name).text(value).end(false);
        }
        return this;
    }

    private static String encode(Object o) {
        String s = o != null ? o.toString() : "";
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;");
    }
}

