/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.bosh;

import java.net.URL;
import java.util.logging.Level;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.connector.AbstractBoshConnector;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.j2se.connectors.bosh.BoshWorker;
import tigase.xml.DomBuilderHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class BoshConnector
extends AbstractBoshConnector {
    public static final String URL_KEY = "bosh#url";
    private final DomBuilderHandler domHandler = new DomBuilderHandler();
    private final SimpleParser parser = SingletonFactory.getParserInstance();

    public BoshConnector(Context context) {
        super(context);
    }

    protected void processSendData(Element element) throws JaxmppException {
        BoshWorker worker = new BoshWorker(this.domHandler, this.parser, this.context.getSessionObject(), element){

            @Override
            protected void onError(int responseCode, String responseData, Element response, Throwable caught) throws JaxmppException {
                BoshConnector.this.onError(this, responseCode, responseData, response, caught);
            }

            @Override
            protected void onSuccess(int responseCode, String responseData, Element response) throws JaxmppException {
                BoshConnector.this.onResponse(this, responseCode, responseData, response);
            }

            @Override
            protected void onTerminate(int responseCode, String responseData, Element response) throws JaxmppException {
                BoshConnector.this.onTerminate(this, responseCode, responseData, response);
            }
        };
        this.addToRequests(worker);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Send: " + element.getAsString());
        }
        Thread t = new Thread((Runnable)((Object)worker));
        t.setDaemon(true);
        t.start();
    }

    public void start() throws JaxmppException {
        try {
            String u = (String)this.context.getSessionObject().getProperty("BOSH_SERVICE_URL_KEY");
            if (u == null) {
                throw new JaxmppException("BOSH service URL not defined!");
            }
            URL url = new URL(u);
            this.context.getSessionObject().setProperty(URL_KEY, (Object)url);
            super.start();
        }
        catch (JaxmppException e) {
            this.fireOnError(0, null, null, e, this.context.getSessionObject());
            throw e;
        }
        catch (Exception e) {
            this.fireOnError(0, null, null, e, this.context.getSessionObject());
            throw new JaxmppException((Throwable)e);
        }
    }
}

