/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.OfflineMessages;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.push.AbstractPushNotifications;
import tigase.xmpp.impl.push.PushNotificationsAware;
import tigase.xmpp.impl.push.PushNotificationsExtension;
import tigase.xmpp.impl.push.PushNotificationsFilter;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:push:0", parent=SessionManager.class, active=true, exportable=true)
@Id(value="urn:xmpp:push:0")
@DiscoFeatures(value={"urn:xmpp:push:0"})
@Handles(value={@Handle(path={"iq", "enable"}, xmlns="urn:xmpp:push:0"), @Handle(path={"iq", "disable"}, xmlns="urn:xmpp:push:0"), @Handle(path={"message"}, xmlns="jabber:client")})
public class PushNotifications
extends AbstractPushNotifications
implements XMPPProcessorIfc,
OfflineMessages.Notifier,
RegistrarBean {
    private static final Logger log = Logger.getLogger(PushNotifications.class.getCanonicalName());
    private Element[] discoFeatures = new Element[0];
    @Inject
    private ArrayList<PushNotificationsAware> awares = new ArrayList();
    @Inject
    private ArrayList<PushNotificationsExtension> triggers = new ArrayList();
    @Inject(nullAllowed=true)
    private ArrayList<PushNotificationsFilter> filters = new ArrayList();

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return this.discoFeatures;
    }

    public void setAwares(ArrayList<PushNotificationsAware> awares) {
        this.awares = awares;
    }

    public void setFilter(ArrayList<PushNotificationsFilter> filters) {
        this.filters = Optional.ofNullable(filters).orElseGet(ArrayList::new);
        this.refreshDiscoFeatures();
    }

    public void setTriggers(ArrayList<PushNotificationsExtension> triggers) {
        this.triggers = triggers;
        this.refreshDiscoFeatures();
    }

    protected void refreshDiscoFeatures() {
        this.discoFeatures = (Element[])Stream.concat(Arrays.stream(super.supDiscoFeatures(null)), this.awares.stream().map(PushNotificationsAware::getDiscoFeatures).flatMap(Arrays::stream)).toArray(Element[]::new);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository nonAuthUserRepository, Queue<Packet> results, Map<String, Object> map) throws XMPPException {
        try {
            if (packet.getElemName() == "message") {
                this.processMessage(packet, session, results::offer);
                return;
            }
            super.process(packet, session, nonAuthUserRepository, results, map);
        }
        catch (NotAuthorizedException ex) {
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Session is not authorized", true));
        }
        catch (TigaseDBException ex) {
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, true));
        }
    }

    @Override
    protected void processMessage(Packet packet, XMPPResourceConnection session, Consumer<Packet> consumer) throws NotAuthorizedException, TigaseDBException {
        super.processMessage(packet, session, consumer);
        if (session == null || !session.isAuthorized() || !this.shouldSendNotification(packet, session.getBareJID(), session)) {
            return;
        }
        this.sendPushNotification(session, packet);
    }

    @Override
    public void notifyNewOfflineMessage(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> map) {
        if (packet.getElemName() != "message") {
            return;
        }
        if (!this.shouldSendNotification(packet, packet.getStanzaTo().getBareJID(), session)) {
            return;
        }
        try {
            this.sendPushNotification(session, packet);
        }
        catch (UserNotFoundException ex) {
            log.log(Level.FINEST, "Could not send push notification for message " + packet, ex);
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Could not send push notification for message " + packet, ex);
        }
    }

    @Override
    public void notifyOfflineMessagesRetrieved(XMPPResourceConnection session, Queue<Packet> results) {
        try {
            BareJID userJid = session.getBareJID();
            Map<String, Element> pushServices = this.getPushServices(userJid);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Offline messages retrieved push notifications for JID: {0}, pushServices: {1}", new Object[]{userJid, pushServices});
            }
            if (pushServices.isEmpty()) {
                return;
            }
            this.notifyOfflineMessagesRetrieved(userJid, pushServices.values());
        }
        catch (UserNotFoundException | NotAuthorizedException ex) {
            log.log(Level.FINEST, "Could not send push notification about offline message retrieval by " + session, ex);
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Could not send push notification about offline message retrieval by " + session, ex);
        }
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    @Override
    protected Element createSettingsElement(JID jid, String node, Element enableElem, Element optionsForm) {
        Element settingsEl = super.createSettingsElement(jid, node, enableElem, optionsForm);
        for (PushNotificationsAware trigger : this.awares) {
            trigger.processEnableElement(enableElem, settingsEl);
        }
        return settingsEl;
    }

    protected void notifyOfflineMessagesRetrieved(BareJID userJid, Collection<Element> pushServices) {
        HashMap<Enum, Long> map = new HashMap<Enum, Long>();
        map.put(MsgRepository.MSG_TYPES.message, 0L);
        this.sendPushNotification(userJid, pushServices, null, null, map);
    }

    @Override
    protected Element prepareNotificationPayload(Element pushServiceSettings, Packet packet, long msgCount) {
        Element notification = super.prepareNotificationPayload(pushServiceSettings, packet, msgCount);
        for (PushNotificationsExtension trigger : this.triggers) {
            trigger.prepareNotificationPayload(pushServiceSettings, packet, msgCount, notification);
        }
        return notification;
    }

    @Override
    protected boolean isSendingNotificationAllowed(BareJID userJid, XMPPResourceConnection session, Element pushServiceSettings, Packet packet) {
        if (!super.isSendingNotificationAllowed(userJid, session, pushServiceSettings, packet)) {
            return false;
        }
        for (PushNotificationsFilter filter : this.filters) {
            if (filter.isSendingNotificationAllowed(userJid, session, pushServiceSettings, packet)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldSendNotification(Packet packet, BareJID userJid, XMPPResourceConnection session) {
        if (session == null && packet.getElemName() == "message" && packet.getElemChild("body") != null) {
            return true;
        }
        for (PushNotificationsExtension trigger : this.triggers) {
            try {
                if (!trigger.shouldSendNotification(packet, userJid, session)) continue;
                return true;
            }
            catch (XMPPException ex) {
                log.log(Level.FINER, "exception while checking if trigger " + trigger.getClass().getCanonicalName() + " should be fired", ex);
            }
        }
        return false;
    }
}

