/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

@Bean(name="message-all", parent=SessionManager.class, active=false)
public class MessageAll
extends XMPPProcessor
implements XMPPProcessorIfc {
    protected static final String ID = "message-all";
    private static final String[][] ELEMENTS = new String[][]{{"message"}};
    private static final Logger log = Logger.getLogger(MessageAll.class.getName());
    private static final String XMLNS = "jabber:client";
    private static final String[] XMLNSS = new String[]{"jabber:client"};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet);
        }
        if (session == null) {
            return;
        }
        try {
            BareJID id;
            BareJID bareJID = id = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
            if (session.isUserId(id)) {
                for (XMPPResourceConnection conn : session.getActiveSessions()) {
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(conn.getConnectionId());
                    result.setPacketFrom(packet.getTo());
                    results.offer(result);
                }
                return;
            }
            BareJID bareJID2 = id = packet.getStanzaFrom() != null ? packet.getStanzaFrom().getBareJID() : null;
            if (session.isUserId(id)) {
                for (XMPPResourceConnection conn : session.getActiveSessions()) {
                    if (conn == session) continue;
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(conn.getConnectionId());
                    results.offer(result);
                }
                results.offer(packet.copyElementOnly());
                return;
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

