/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import tigase.annotations.TigaseDeprecated;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Permissions;
import tigase.server.Presence;
import tigase.server.Priority;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

public class Packet {
    public static final String CLIENT_XMLNS = "jabber:client";
    public static final String FROM_ATT = "from";
    public static final String ID_ATT = "id";
    public static final String PERM_ATT = "perm";
    public static final String PRIORITY_ATT = "pr";
    public static final String TO_ATT = "to";
    public static final String TYPE_ATT = "type";
    public static final String XMLNS_ATT = "xmlns";
    public static final String ERROR_NS = "urn:ietf:params:xml:ns:xmpp-stanzas";
    public static boolean FULL_DEBUG = Boolean.getBoolean("packet.debug.full");
    protected Element elem;
    private JID packetFrom = null;
    private JID packetTo = null;
    private String packetToString = null;
    private String packetToStringSecure = null;
    private Permissions permissions = Permissions.NONE;
    private Priority priority = Priority.NORMAL;
    private Set<String> processorsIds = new LinkedHashSet<String>(4, 0.9f);
    private boolean routed;
    private LinkedHashSet<String> skippedProcessorsIds = new LinkedHashSet(4, 0.9f);
    private JID stanzaFrom = null;
    private String stanzaId = null;
    private JID stanzaTo = null;
    private StanzaType type;
    private String stableId = null;
    private Optional<JID> serverAuthorisedStanzaFrom = Optional.empty();

    public static String elemToString(Element el) {
        Object elemData = el.toString();
        int size = ((String)elemData).length();
        if (size > 1024) {
            elemData = ((String)elemData).substring(0, 1024) + " ... ";
        }
        return elemData;
    }

    public static String elemToStringSecure(Element el) {
        Object elemData = el.toStringSecure();
        int size = ((String)elemData).length();
        if (size > 1024) {
            elemData = ((String)elemData).substring(0, 1024) + " ... ";
        }
        return elemData;
    }

    public static Packet packetInstance(Element elem) throws TigaseStringprepException {
        Packet result = null;
        if (elem.getName() == "message") {
            result = new Message(elem);
        }
        if (elem.getName() == "presence") {
            result = new Presence(elem);
        }
        if (elem.getName() == "iq") {
            result = new Iq(elem);
        }
        if (result == null) {
            result = new Packet(elem);
        }
        return result;
    }

    public static Packet packetInstance(Element elem, JID stanzaFrom, JID stanzaTo) {
        Packet result = null;
        if (elem.getName() == "message") {
            result = new Message(elem, stanzaFrom, stanzaTo);
        }
        if (elem.getName() == "presence") {
            result = new Presence(elem, stanzaFrom, stanzaTo);
        }
        if (elem.getName() == "iq") {
            result = new Iq(elem, stanzaFrom, stanzaTo);
        }
        if (result == null) {
            result = new Packet(elem, stanzaFrom, stanzaTo);
        }
        return result;
    }

    public static Packet packetInstance(String el_name, String from, String to, StanzaType type) throws TigaseStringprepException {
        Element elem = new Element(el_name, new String[]{FROM_ATT, TO_ATT, TYPE_ATT}, new String[]{from, to, type.toString()});
        return Packet.packetInstance(elem);
    }

    protected Packet(Element elem) throws TigaseStringprepException {
        this.setElem(elem);
        this.initVars();
    }

    protected Packet(Element elem, JID stanzaFrom, JID stanzaTo) {
        this.setElem(elem);
        this.initVars(stanzaFrom, stanzaTo);
    }

    public Packet copyElementOnly() {
        Element res_elem = this.elem.clone();
        Packet result = Packet.packetInstance(res_elem, this.getStanzaFrom(), this.getStanzaTo());
        result.setPriority(this.priority);
        return result;
    }

    public String debug() {
        return this.toString() + ", stanzaFrom=" + this.stanzaFrom + ", stanzaTo=" + this.stanzaTo;
    }

    public Packet errorResult(String errorType, Integer errorCode, String errorCondition, String errorText, boolean includeOriginalXML) {
        Element reply = new Element(this.elem.getName());
        reply.setAttribute(TYPE_ATT, StanzaType.error.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute(ID_ATT, this.getStanzaId());
        }
        if (includeOriginalXML) {
            reply.addChildren(this.elem.getChildren());
        }
        if (this.getXMLNS() != null) {
            reply.setXMLNS(this.getXMLNS());
        }
        Element error = new Element("error");
        if (errorCode != null) {
            error.setAttribute("code", errorCode.toString());
        }
        error.setAttribute(TYPE_ATT, errorType);
        Element cond = new Element(errorCondition);
        cond.setXMLNS(ERROR_NS);
        error.addChild((XMLNodeIfc)cond);
        if (errorText != null) {
            Element t = new Element("text", errorText, new String[]{"xml:lang", XMLNS_ATT}, new String[]{"en", ERROR_NS});
            error.addChild((XMLNodeIfc)t);
        }
        reply.addChild((XMLNodeIfc)error);
        return this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
    }

    public Element getElemChild(String name) {
        return this.elem.getChild(name);
    }

    public Element getElemChild(String name, String xmlns) {
        return this.elem.getChild(name, xmlns);
    }

    public String getAttributeStaticStr(String key) {
        return this.elem.getAttributeStaticStr(key);
    }

    public String getAttributeStaticStr(String[] path, String key) {
        return this.elem.getAttributeStaticStr(path, key);
    }

    public Command getCommand() {
        return null;
    }

    public String getElemCDataStaticStr(String[] xmlPath) {
        return this.elem.getCDataStaticStr(xmlPath);
    }

    public String getElemCData() {
        return this.elem.getCData();
    }

    public List<Element> getElemChildrenStaticStr(String[] xmlPath) {
        return this.elem.getChildrenStaticStr(xmlPath);
    }

    public String getElemName() {
        return this.elem.getName();
    }

    public Element getElement() {
        return this.elem;
    }

    public String getErrorCondition() {
        List children = this.elem.getChildrenStaticStr(this.getElNameErrorPath());
        if (children != null) {
            for (Element cond : children) {
                if (cond.getName().equals("text")) continue;
                return cond.getName();
            }
        }
        return null;
    }

    public JID getFrom() {
        return this.packetFrom != null ? this.packetFrom : this.stanzaFrom;
    }

    public JID getPacketFrom() {
        return this.packetFrom;
    }

    public void setPacketFrom(JID from) {
        this.packetFrom = from;
    }

    public JID getPacketTo() {
        return this.packetTo;
    }

    public void setPacketTo(JID to) {
        this.packetTo = to;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions perm) {
        this.packetToString = null;
        this.packetToStringSecure = null;
        this.permissions = perm;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Set<String> getProcessorsIds() {
        return this.processorsIds;
    }

    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0")
    public Optional<JID> getServerAuthorisedStanzaFrom() {
        return this.serverAuthorisedStanzaFrom;
    }

    @Deprecated
    @TigaseDeprecated(since="8.2.0", removeIn="9.0.0")
    public void setServerAuthorisedStanzaFrom(JID serverAuthorisedStanzaFrom) {
        this.serverAuthorisedStanzaFrom = Optional.ofNullable(serverAuthorisedStanzaFrom);
        this.packetToString = null;
        this.packetToStringSecure = null;
    }

    public Set<String> getSkippedProcessorsIds() {
        return this.skippedProcessorsIds;
    }

    public JID getStanzaFrom() {
        return this.stanzaFrom;
    }

    public String getStableId() {
        return this.stableId;
    }

    public void setStableId(String stableId) {
        this.stableId = stableId;
        this.packetToString = null;
        this.packetToStringSecure = null;
    }

    public String getStanzaId() {
        return this.stanzaId;
    }

    public JID getStanzaTo() {
        return this.stanzaTo;
    }

    public JID getTo() {
        return this.packetTo != null ? this.packetTo : this.stanzaTo;
    }

    public StanzaType getType() {
        return this.type;
    }

    public String getXMLNS() {
        return this.elem.getXMLNS();
    }

    public void setXMLNS(String xmlns) {
        this.elem.setXMLNS(xmlns);
        this.packetToString = null;
        this.packetToStringSecure = null;
    }

    public void initVars(JID stanzaFrom, JID stanzaTo) {
        if (this.stanzaFrom != stanzaFrom) {
            this.stanzaFrom = stanzaFrom;
            if (stanzaFrom == null) {
                this.elem.removeAttribute(FROM_ATT);
            } else {
                this.elem.setAttribute(FROM_ATT, stanzaFrom.toString());
            }
        }
        if (this.stanzaTo != stanzaTo) {
            this.stanzaTo = stanzaTo;
            if (stanzaTo == null) {
                this.elem.removeAttribute(TO_ATT);
            } else {
                this.elem.setAttribute(TO_ATT, stanzaTo.toString());
            }
        }
        this.stanzaId = this.elem.getAttributeStaticStr(ID_ATT);
        this.packetToString = null;
        this.packetToStringSecure = null;
    }

    public void initVars() throws TigaseStringprepException {
        String tmp = this.elem.getAttributeStaticStr(TO_ATT);
        this.stanzaTo = tmp != null ? JID.jidInstance((String)tmp) : null;
        tmp = this.elem.getAttributeStaticStr(FROM_ATT);
        this.stanzaFrom = tmp != null ? JID.jidInstance((String)tmp) : null;
        this.stanzaId = this.elem.getAttributeStaticStr(ID_ATT);
        this.packetToString = null;
        this.packetToStringSecure = null;
        tmp = this.elem.getAttributeStaticStr(PRIORITY_ATT);
        if (tmp != null) {
            this.priority = Priority.valueOf(tmp);
        }
        if ((tmp = this.elem.getAttributeStaticStr(PERM_ATT)) != null) {
            this.permissions = Permissions.valueOf(tmp);
        }
    }

    public boolean isCommand() {
        return false;
    }

    public boolean isElement(String name, String xmlns) {
        return this.elem.getName() == name && xmlns == this.elem.getXMLNS();
    }

    public boolean isRouted() {
        return this.routed;
    }

    public boolean isServiceDisco() {
        return false;
    }

    public boolean isXMLNSStaticStr(String[] elementPath, String xmlns) {
        String this_xmlns = this.elem.getXMLNSStaticStr(elementPath);
        return this_xmlns == xmlns;
    }

    public void notProcessedBy(String id) {
        this.skippedProcessorsIds.add(id);
    }

    public Packet okResult(String includeXML, int originalXML) {
        List old_children;
        Element reply = new Element(this.elem.getName());
        if (this.getXMLNS() != null) {
            reply.setXMLNS(this.getXMLNS());
        }
        reply.setAttribute(TYPE_ATT, StanzaType.result.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute(ID_ATT, this.getStanzaId());
        }
        Element old_child = this.elem;
        Element new_child = reply;
        for (int i = 0; i < originalXML && (old_children = old_child.getChildren()) != null && old_children.size() > 0; ++i) {
            old_child = (Element)old_children.get(0);
            Element tmp = new Element(old_child.getName());
            tmp.setAttributes(old_child.getAttributes());
            new_child.addChild((XMLNodeIfc)tmp);
            new_child = tmp;
        }
        if (includeXML != null) {
            new_child.setCData(includeXML);
        }
        Packet result = this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet okResult(Element includeXML, int originalXML) {
        List old_children;
        Element reply = new Element(this.elem.getName());
        if (this.getXMLNS() != null) {
            reply.setXMLNS(this.getXMLNS());
        }
        reply.setAttribute(TYPE_ATT, StanzaType.result.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute(ID_ATT, this.getStanzaId());
        }
        Element old_child = this.elem;
        Element new_child = reply;
        for (int i = 0; i < originalXML && (old_children = old_child.getChildren()) != null && old_children.size() > 0; ++i) {
            old_child = (Element)old_children.get(0);
            Element tmp = new Element(old_child.getName());
            tmp.setAttributes(old_child.getAttributes());
            new_child.addChild((XMLNodeIfc)tmp);
            new_child = tmp;
        }
        if (includeXML != null) {
            new_child.addChild((XMLNodeIfc)includeXML);
        }
        Packet result = this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet packRouted() {
        Element routedp = new Element("route", new String[]{TO_ATT, FROM_ATT, PRIORITY_ATT, PERM_ATT}, new String[]{this.getTo().toString(), this.getFrom().toString(), this.priority.toString(), this.permissions.toString()});
        routedp.addChild((XMLNodeIfc)this.elem);
        return Packet.packetInstance(routedp, this.getFrom(), this.getTo());
    }

    public void processedBy(String id) {
        this.processorsIds.add(id);
    }

    public Packet swapFromTo(Element el, JID stanzaFrom, JID stanzaTo) {
        Packet packet = Packet.packetInstance(el, stanzaFrom, stanzaTo);
        packet.setPacketTo(this.getFrom());
        packet.setPacketFrom(this.getTo());
        packet.setPriority(this.priority);
        return packet;
    }

    public Packet swapFromTo() {
        Element el = this.elem.clone();
        Packet packet = Packet.packetInstance(el, this.getStanzaFrom(), this.getStanzaTo());
        packet.setPacketTo(this.getFrom());
        packet.setPacketFrom(this.getTo());
        packet.setPriority(this.priority);
        return packet;
    }

    public Packet swapStanzaFromTo() {
        Element copy = this.elem.clone();
        Packet result = Packet.packetInstance(copy, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet swapStanzaFromTo(StanzaType type) {
        Element copy = this.elem.clone();
        copy.setAttribute(TYPE_ATT, type.toString());
        Packet result = Packet.packetInstance(copy, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public String toStringFull() {
        if (this.packetToString == null) {
            String elemData = Packet.elemToString(this.elem);
            this.packetToString = this.calcToString(elemData);
        }
        return "from=" + this.packetFrom + ", to=" + this.packetTo + ", serverAuthorisedStanzaFrom=" + this.getServerAuthorisedStanzaFrom() + this.packetToString;
    }

    public String toString() {
        return this.toString(!FULL_DEBUG);
    }

    public String toString(boolean secure) {
        String result = secure ? this.toStringSecure() : this.toStringFull();
        return result;
    }

    public String toStringSecure() {
        if (FULL_DEBUG) {
            return this.toStringFull();
        }
        if (this.packetToStringSecure == null) {
            String elemData = Packet.elemToStringSecure(this.elem);
            this.packetToStringSecure = this.calcToString(elemData);
        }
        return "from=" + this.packetFrom + ", to=" + this.packetTo + ", serverAuthorisedStanzaFrom=" + this.getServerAuthorisedStanzaFrom() + this.packetToStringSecure;
    }

    public Packet unpackRouted() throws TigaseStringprepException {
        Packet result = Packet.packetInstance((Element)this.elem.getChildren().get(0));
        result.setPacketTo(this.getTo());
        result.setPacketFrom(this.getFrom());
        result.setPriority(this.priority);
        result.setPermissions(this.permissions);
        return result;
    }

    public boolean wasProcessed() {
        return this.processorsIds.size() > 0;
    }

    public boolean wasSkipped() {
        return this.skippedProcessorsIds.size() > 0;
    }

    public boolean wasProcessedBy(String id) {
        return this.processorsIds.contains(id);
    }

    protected String[] getElNameErrorPath() {
        return new String[]{this.elem.getName(), "error"};
    }

    private String calcToString(String elemData) {
        return ", DATA=" + elemData + ", SIZE=" + this.elem.toString().length() + ", XMLNS=" + this.elem.getXMLNS() + ", PRIORITY=" + this.priority + ", PERMISSION=" + this.permissions + ", TYPE=" + this.type + ", STABLE_ID=" + this.stableId;
    }

    private void setElem(Element elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        this.elem = elem;
        this.type = elem.getAttributeStaticStr(TYPE_ATT) != null ? StanzaType.valueof(elem.getAttributeStaticStr(TYPE_ATT)) : null;
        if (elem.getName() == "cluster") {
            this.setPriority(Priority.CLUSTER);
        } else if (elem.getName() == "presence" && (this.type == null || this.type == StanzaType.available || this.type == StanzaType.unavailable || this.type == StanzaType.probe)) {
            this.setPriority(Priority.PRESENCE);
        } else {
            this.routed = elem.getName() == "route";
        }
    }
}

