/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix;

import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.mix.IMixComponent;
import tigase.pubsub.IPubSubConfig;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="config", parent=IMixComponent.class, active=true)
public class MixConfig
implements IPubSubConfig {
    @ConfigField(desc="Max Cache size", alias="pubsub-repository-cache-size")
    private Integer maxCacheSize = 2000;
    private BareJID serviceBareJID;
    @Inject(bean="service")
    private IMixComponent component;

    public void setComponent(IMixComponent component) {
        this.component = component;
        this.serviceBareJID = BareJID.bareJIDInstanceNS((String)component.getName(), (String)"mix");
    }

    public String[] getAdmins() {
        return new String[0];
    }

    public String getComponentName() {
        return this.component.getName();
    }

    public JID getComponentJID() {
        return this.component.getComponentId();
    }

    public long getDelayOnLowMemory() {
        return 0L;
    }

    public Integer getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public BareJID getServiceBareJID() {
        return this.serviceBareJID;
    }

    public boolean isAutoSubscribeNodeCreator() {
        return false;
    }

    public boolean isAdmin(BareJID jid) {
        return false;
    }

    public boolean isAdmin(JID jid) {
        return false;
    }

    public boolean isMAMEnabled() {
        return false;
    }

    public boolean isMAMEnabledForGenericService() {
        return false;
    }

    public boolean isPepPeristent() {
        return false;
    }

    public boolean isPepRemoveEmptyGeoloc() {
        return false;
    }

    public boolean isSendLastPublishedItemOnPresence() {
        return false;
    }

    public boolean isSubscribeByPresenceFilteredNotifications() {
        return false;
    }

    public boolean isHighMemoryUsage() {
        return false;
    }
}

