/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.script;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.disco.ServiceEntity;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.script.AbstractScriptCommand;
import tigase.server.script.Script;

public class RemoveScriptCommand
extends AbstractScriptCommand {
    private static final Logger log = Logger.getLogger(RemoveScriptCommand.class.getName());

    @Override
    public void runCommand(Iq packet, Bindings binds, Queue<Packet> results) {
        String commandId = Command.getFieldValue(packet, "Command Id");
        if (this.isEmpty(commandId)) {
            results.offer(this.prepareScriptCommand(packet, binds));
        } else {
            boolean removeFromDisk = Command.getCheckBoxFieldValue(packet, "Remove from disk");
            Map adminCommands = (Map)binds.get("adminCommands");
            Script command2 = (Script)adminCommands.remove(commandId);
            ServiceEntity serviceEntity = (ServiceEntity)binds.get("adminDisco");
            ServiceEntity item = serviceEntity.findNode("http://jabber.org/protocol/admin#" + commandId);
            serviceEntity.removeItems(item);
            if (removeFromDisk) {
                this.deleteCommandFromDisk(command2.getCommandId(), command2.getFileExtension(), binds);
            }
            Packet result = packet.commandResult(Command.DataType.result);
            Command.addTextField(result, "Note", "Script removed correctly");
            results.offer(result);
        }
    }

    @Override
    public Bindings getBindings() {
        return null;
    }

    private Packet prepareScriptCommand(Iq packet, Bindings binds) {
        Packet result = null;
        Map adminCommands = (Map)binds.get("adminCommands");
        if (adminCommands.size() > 2) {
            result = packet.commandResult(Command.DataType.form);
            LinkedHashSet ids = new LinkedHashSet(adminCommands.keySet());
            ids.remove("add-script");
            ids.remove("del-script");
            String[] commandIds = ids.toArray(new String[ids.size()]);
            Command.addFieldValue(result, "Command Id", commandIds[0], "Command Id", commandIds, commandIds);
            Command.addCheckBoxField(result, "Remove from disk", true);
        } else {
            result = packet.commandResult(Command.DataType.result);
            Command.addTextField(result, "Note", "There is no command script to remove");
        }
        return result;
    }

    private void deleteCommandFromDisk(String commandId, String fileExtension, Bindings binds) {
        File fileName = new File((String)binds.get("scriptCompDir"), commandId + "." + fileExtension);
        if (fileName.exists()) {
            log.log(Level.CONFIG, "Deleting file: {0}", fileName);
            fileName.delete();
        }
    }
}

