/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.comp.UserRepoRepository;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.AbstractMessageReceiver;
import tigase.server.ext.CompRepoDefaults;
import tigase.server.ext.CompRepoItem;
import tigase.xmpp.jid.BareJID;

public class AbstractCompDBRepository
extends UserRepoRepository<CompRepoItem> {
    public static final String ITEMS_IMPORT_FILE = "etc/externalComponentItems";
    private static final Logger log = Logger.getLogger(AbstractCompDBRepository.class.getCanonicalName());
    @Inject(bean="service")
    private AbstractMessageReceiver component;
    @ConfigField(desc="ID of the external components group", alias="external-components-group")
    private String extenalComponentsGroup;

    protected AbstractCompDBRepository(String extenalComponentsGroup) {
        this.extenalComponentsGroup = extenalComponentsGroup;
        this.autoReloadInterval = 30L;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getConfigKey() {
        return CompRepoDefaults.getConfigKey();
    }

    @Override
    public String[] getDefaultPropetyItems() {
        return CompRepoDefaults.getDefaultPropetyItems();
    }

    @Override
    public CompRepoItem getItemInstance() {
        return CompRepoDefaults.getItemInstance();
    }

    @Override
    public String getItemsListPKey() {
        return this.extenalComponentsGroup;
    }

    @Override
    public String getPropertyKey() {
        return CompRepoDefaults.getPropertyKey();
    }

    @Override
    public BareJID getRepoUser() {
        return CompRepoDefaults.getRepoUser();
    }

    @Override
    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    @Override
    public String validateItem(CompRepoItem item) {
        String result = super.validateItem(item);
        if (result == null) {
            result = item.validate();
        }
        return result;
    }

    @Override
    public void initialize() {
        this.loadItemsFromFile();
        super.initialize();
    }

    public void loadItemsFromFile() {
        File f = new File(ITEMS_IMPORT_FILE);
        if (f.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(f));){
                reader.lines().flatMap(list -> Arrays.stream(list.split(","))).map(this::newItemFromPropertyString).forEach(this::addItemNoStore);
                f.delete();
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "could not load external component items from the import file", ex);
            }
        }
    }

    private CompRepoItem newItemFromPropertyString(String str) {
        CompRepoItem item = this.getItemInstance();
        item.initFromPropertyString(str);
        return item;
    }
}

