/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.ConfigurableTask;
import tigase.monitor.MonitorTask;

public abstract class AbstractConfigurableTask
implements MonitorTask,
ConfigurableTask,
UnregisterAware,
Initializable {
    private static final String ENABLED_VAR = "x-task#enabled";
    @ConfigField(desc="Enable task")
    private boolean enabled = false;
    private boolean initialized = false;

    @Override
    public void beforeUnregister() {
        this.setEnabled(false);
    }

    @Override
    public Form getCurrentConfiguration() {
        Form f = new Form("", "Task Configuration", "");
        f.addField(Field.fieldBoolean((String)ENABLED_VAR, (Boolean)this.enabled, (String)"Enabled"));
        return f;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        if (this.enabled && !value) {
            this.enabled = value;
            if (this.initialized) {
                this.disable();
            }
        } else if (!this.enabled && value) {
            this.enabled = value;
            if (this.initialized) {
                this.enable();
            }
        }
    }

    @Override
    public void initialize() {
        this.initialized = true;
        if (this.isEnabled()) {
            this.enable();
        }
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field f = form.get(ENABLED_VAR);
        if (f != null) {
            boolean value = Field.getAsBoolean((Field)f);
            this.setEnabled(value);
        }
    }

    protected void disable() {
    }

    protected void enable() {
    }
}

