/*
 * Decompiled with CFR 0.152.
 */
package tigase.map;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.impl.EventName;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.TypesConverter;
import tigase.map.DMap;
import tigase.map.MapCreatedEvent;
import tigase.map.MapDestroyedEvent;

public class ClusterMapFactory {
    private static final EventName NEWMAP_EVENT_NAME = new EventName(NewMapCreatedEvent.class);
    private static ClusterMapFactory instance;
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final ConcurrentHashMap<String, DMap> maps = new ConcurrentHashMap();
    private final TypesConverter typesConverter = new DefaultTypesConverter();
    private EventBus eventBus;
    private final DMap.DMapListener mapListener = new DMap.DMapListener(){

        @Override
        public void onClear(DMap map) {
            MapClearEvent event = new MapClearEvent();
            event.setUid(map.getUid());
            ClusterMapFactory.this.eventBus.fire(event);
        }

        @Override
        public void onPut(DMap map, Object key, Object value) {
            ElementAddEvent event = new ElementAddEvent();
            event.setUid(map.getUid());
            event.setKey(ClusterMapFactory.this.typesConverter.toString(key));
            event.setValue(ClusterMapFactory.this.typesConverter.toString(value));
            ClusterMapFactory.this.eventBus.fire(event);
        }

        @Override
        public void onPutAll(DMap map, Map<?, ?> m) {
            for (Map.Entry<?, ?> en : m.entrySet()) {
                ElementAddEvent event = new ElementAddEvent();
                event.setUid(map.getUid());
                event.setKey(ClusterMapFactory.this.typesConverter.toString(en.getKey()));
                event.setValue(ClusterMapFactory.this.typesConverter.toString(en.getValue()));
                ClusterMapFactory.this.eventBus.fire(event);
            }
        }

        @Override
        public void onRemove(DMap map, Object key) {
            ElementRemoveEvent event = new ElementRemoveEvent();
            event.setUid(map.getUid());
            event.setKey(ClusterMapFactory.this.typesConverter.toString(key));
            ClusterMapFactory.this.eventBus.fire(event);
        }
    };

    public static final ClusterMapFactory get() {
        if (instance == null) {
            instance = new ClusterMapFactory();
        }
        return instance;
    }

    ClusterMapFactory() {
        this.eventBus = EventBusFactory.getInstance();
        this.eventBus.registerAll(this);
    }

    public <K, V> Map<K, V> createMap(String uid, Class<K> keyClass, Class<V> valueClass, String ... params) {
        NewMapCreatedEvent event = new NewMapCreatedEvent();
        event.setUid(uid);
        event.setKeyClass(keyClass);
        event.setValueClass(valueClass);
        event.setParams(params);
        this.eventBus.fire(event);
        DMap map = this.maps.computeIfAbsent(uid, u -> new DMap(uid, this.mapListener, keyClass, valueClass));
        return map;
    }

    public void destroyMap(Map map) {
        if (map instanceof DMap) {
            MapDestroyEvent event = new MapDestroyEvent();
            event.setUid(((DMap)map).getUid());
            this.eventBus.fire(event);
            this.maps.remove(((DMap)map).getUid(), map);
        }
    }

    private void fireOnMapCreated(Map map, String uid, String ... parameters) {
        MapCreatedEvent event = new MapCreatedEvent(map, uid, parameters);
        this.eventBus.fire(event);
    }

    private void fireOnMapDestroyed(Map map, String uid) {
        MapDestroyedEvent event = new MapDestroyedEvent(map, uid);
        this.eventBus.fire(event);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public <K, V> Map<K, V> getMap(String uid) {
        return this.maps.get(uid);
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    void onMapClear(MapClearEvent event) {
        String uid = event.getUid();
        DMap map = this.maps.get(uid);
        if (map == null) {
            this.log.log(Level.FINE, "No map '" + uid + "' created on this node! Ignoring MapClear event.");
            return;
        }
        map.clearNoEvent();
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    void onMapDestroyed(MapDestroyEvent event) {
        String uid = event.getUid();
        DMap map = this.maps.remove(uid);
        if (map != null) {
            this.fireOnMapDestroyed(map, map.uid);
        }
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    void onMapElementAdd(ElementAddEvent event) {
        String uid = event.getUid();
        DMap map = this.maps.get(uid);
        if (map == null) {
            this.log.log(Level.FINE, "No map '" + uid + "' created on this node! Ignoring ElementAdd item event.");
            return;
        }
        String k = event.getKey();
        String v = event.getValue();
        Object key = this.typesConverter.convert(k, map.keyClass);
        Object value = this.typesConverter.convert(v, map.valueClass);
        map.putNoEvent(key, value);
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    void onMapElementRemove(ElementRemoveEvent event) {
        String uid = event.getUid();
        DMap map = this.maps.get(uid);
        if (map == null) {
            this.log.log(Level.FINE, "No map '" + uid + "' created on this node! Ignoring ElementRemove item event.");
            return;
        }
        String k = event.getKey();
        Object key = this.typesConverter.convert(k, map.keyClass);
        map.removeNoEvent(key);
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    void onNewMapCreated(NewMapCreatedEvent event) {
        String uid = event.getUid();
        if (!this.maps.containsKey(uid)) {
            Class keyClass = event.getKeyClass();
            Class valueClass = event.getValueClass();
            String[] parameters = event.getParams();
            DMap map = new DMap(uid, this.mapListener, keyClass, valueClass);
            this.maps.put(uid, map);
            this.fireOnMapCreated(map, uid, parameters);
        } else {
            DMap map = this.maps.get(uid);
            this.mapListener.onPutAll(map, map);
        }
    }

    public static class NewMapCreatedEvent
    implements Serializable,
    EventBusEvent {
        private Class keyClass;
        private String[] params;
        private String uid;
        private Class valueClass;

        public Class getKeyClass() {
            return this.keyClass;
        }

        public void setKeyClass(Class keyClass) {
            this.keyClass = keyClass;
        }

        public String[] getParams() {
            return this.params;
        }

        public void setParams(String[] params) {
            this.params = params;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public Class getValueClass() {
            return this.valueClass;
        }

        public void setValueClass(Class valueClass) {
            this.valueClass = valueClass;
        }
    }

    public static class MapDestroyEvent
    implements Serializable,
    EventBusEvent {
        private String uid;

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }
    }

    public static class MapClearEvent
    implements Serializable,
    EventBusEvent {
        private String uid;

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }
    }

    public static class ElementRemoveEvent
    implements Serializable,
    EventBusEvent {
        private String key;
        private String uid;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }
    }

    public static class ElementAddEvent
    implements Serializable,
    EventBusEvent {
        private String key;
        private String uid;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

