/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import javax.security.sasl.SaslException;
import tigase.db.AuthRepository;

public class XmppSaslException
extends SaslException {
    private static final long serialVersionUID = 1L;
    private SaslError saslError;

    public XmppSaslException(SaslError saslError) {
        this.saslError = saslError;
    }

    public XmppSaslException(SaslError saslError, String detail) {
        super(detail);
        this.saslError = saslError;
    }

    public SaslError getSaslError() {
        return this.saslError;
    }

    public String getSaslErrorElementName() {
        return this.saslError == null ? null : this.saslError.getElementName();
    }

    public static XmppSaslException getExceptionFor(AuthRepository.AccountStatus status) {
        switch (status) {
            case disabled: 
            case banned: 
            case spam: 
            case undefined_inactive: {
                return new XmppSaslException(SaslError.account_disabled, "Your account has been disabled, please contact the administration");
            }
            case system: {
                return new XmppSaslException(SaslError.invalid_authzid);
            }
            case pending: {
                return new XmppSaslException(SaslError.temporary_auth_failure, "Your account hasn't been activated yet. Please cheek your email for activation link");
            }
        }
        return new XmppSaslException(SaslError.not_authorized);
    }

    public static enum SaslError {
        aborted("aborted"),
        account_disabled("account-disabled"),
        credentials_expired("credentials-expired"),
        encryption_required("encryption-required"),
        incorrect_encoding("incorrect-encoding"),
        invalid_authzid("invalid-authzid"),
        invalid_mechanism("invalid-mechanism"),
        malformed_request("malformed-request"),
        mechanism_too_weak("mechanism-too-weak"),
        not_authorized("not-authorized"),
        temporary_auth_failure("temporary-auth-failure");

        private final String elementName;

        private SaslError(String elementName) {
            this.elementName = elementName;
        }

        public String getElementName() {
            return this.elementName;
        }
    }
}

