/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

public abstract class BcTlsDSSVerifier
implements TlsVerifier {
    protected final AsymmetricKeyParameter pubKey;
    protected final BcTlsCrypto crypto;

    protected BcTlsDSSVerifier(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'pubKey' cannot be null");
        }
        if (asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'pubKey' must be a public key");
        }
        this.crypto = bcTlsCrypto;
        this.pubKey = asymmetricKeyParameter;
    }

    protected abstract DSA createDSAImpl(short var1);

    protected abstract short getSignatureAlgorithm();

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) {
        return null;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short s = signatureAndHashAlgorithm == null ? (short)2 : (short)signatureAndHashAlgorithm.getHash();
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(s), (Digest)new NullDigest());
        dSADigestSigner.init(false, (CipherParameters)this.pubKey);
        if (signatureAndHashAlgorithm == null) {
            dSADigestSigner.update(byArray, 16, 20);
        } else {
            dSADigestSigner.update(byArray, 0, byArray.length);
        }
        return dSADigestSigner.verifySignature(digitallySigned.getSignature());
    }
}

