/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.archive.FasteningCollation;
import tigase.archive.db.AbstractMessageArchiveRepository;
import tigase.archive.db.JDBCMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.unified.QueryCriteria;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Algorithms;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="unified-archive", name="Tigase Unified Archive Component")
public class JDBCUnifiedArchiveRepository
extends JDBCMessageArchiveRepository<QueryCriteria>
implements UnifiedArchiveRepository<DataRepository>,
RepositoryVersionAware {
    private static final String a = "group-by-chat-type";
    protected static final String OFFLINE_STORE_KEY = "offline-store";
    private static final Logger b = Logger.getLogger(JDBCUnifiedArchiveRepository.class.getCanonicalName());
    private static final String c = "{ call Tig_UA_GetItems(?,?,?,?,?,?,?,?,?,?,?) }";
    private static final String d = "{ call Tig_UA_GetItemsCount(?,?,?,?,?,?,?,?,?) }";
    private static final String e = "{ call Tig_UA_GetItemPosition(?,?,?,?,?,?,?,?,?,?) }";
    private static final String f = "{ call Tig_UA_GetCollections(?,?,?,?,?,?,?,?,?,?,?) }";
    private static final String g = "{ call Tig_UA_GetCollectionsCount(?,?,?,?,?,?,?,?,?) }";
    private static final String h = "{ call Tig_UA_AddItem(?,?,?,?,?,?,?,?,?,?) }";
    private static final String i = "{ call Tig_UA_QueryRecent(?,?,?,?,?,?,?,?,?,?,?) }";
    private static final String j = "{ call Tig_UA_QueryRecentCount(?,?,?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to add additional details for offline messages", alias="add-item-offline-query")
    private String ADD_ITEM_OFFLINE = "{ call Tig_UA_FOR_AddItemOffline(?,?,?) }";
    @ConfigField(desc="Query to add additional details for jingle entries", alias="add-item-jingle-query")
    private String ADD_ITEM_JINGLE = "{ call Tig_UA_AddItemJingle(?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to add additional details for jingle entries", alias="add-item-jingle-query")
    private String ADD_ITEM_FILE_METADATA = "{ call Tig_UA_FileMetadata_AddItem(?,?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to retrieve metadata of transferred files", alias="get-files-metadata-query")
    private String QUERY_FILE_METADATA = "{ call Tig_UA_FileMetadata_QueryItems(?,?,?,?,?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to find offset of metadata of transferred files", alias="get-files-metadata-offset-query")
    private String QUERY_FILE_METADATA_OFFSET = "{ call Tig_UA_FileMetadata_QueryItemsCount(?,?,?,?,?,?,?,?,?,?) }";
    @ConfigField(desc="Group collections by stanza type", alias="group-by-chat-type")
    private boolean groupByType = false;

    public JDBCUnifiedArchiveRepository() {
        this.GET_MESSAGES_QUERY = c;
        this.GET_MESSAGES_COUNT_QUERY = d;
        this.GET_MESSAGE_POSITION_QUERY = e;
        this.GET_COLLECTIONS_QUERY = f;
        this.GET_COLLECTIONS_COUNT_QUERY = g;
        this.ADD_MESSAGE_QUERY = h;
    }

    public void archiveMessage(BareJID owner, JID buddy, Date timestamp, Element msg, String stableId, Set<String> tags) {
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        List list;
        Object object4;
        UnifiedArchiveRepository.ItemType itemType = Optional.ofNullable(msg.getAttributeStaticStr("item-type")).map(UnifiedArchiveRepository.ItemType::from).orElseGet(() -> {
            if (msg.getName() == "presence") {
                return UnifiedArchiveRepository.ItemType.presence;
            }
            if ("groupchat".equals(msg.getAttributeStaticStr("type"))) {
                return UnifiedArchiveRepository.ItemType.groupchat;
            }
            return UnifiedArchiveRepository.ItemType.chat;
        });
        msg.removeAttribute("item-type");
        if (itemType == UnifiedArchiveRepository.ItemType.call) {
            msg.setName("iq");
        }
        boolean bl = Optional.ofNullable(msg.getAttributeStaticStr("tigase-offline")).map(Boolean::parseBoolean).orElse(false);
        msg.removeAttribute("tigase-offline");
        boolean bl2 = Optional.ofNullable(msg.getAttributeStaticStr("tigase-offline-only")).map(Boolean::parseBoolean).orElse(false);
        msg.removeAttribute("tigase-offline-only");
        this.archiveMessage(owner, buddy.getBareJID(), timestamp, msg, stableId, tags, (AbstractMessageArchiveRepository.AddMessageAdditionalDataProvider)((JDBCMessageArchiveRepository.AddMessageAdditionalDataProvider)(preparedStatement, n) -> {
            int n2 = n;
            preparedStatement.setShort(n2++, itemType.getShortValue());
            if (bl) {
                preparedStatement.setShort(n2++, (short)(bl2 ? 2 : 1));
            } else {
                preparedStatement.setShort(n2++, (short)0);
            }
        }));
        if (bl && buddy.getResource() != null) {
            try {
                this.addItemOffline(owner, stableId, buddy.getResource());
            }
            catch (RepositoryException repositoryException) {
                b.log(Level.WARNING, "Problem adding new entry to DB: " + msg, repositoryException);
            }
        }
        if (msg.getName() == "iq" && (object4 = msg.getChild("jingle")) != null) {
            list = MessageArchiveRepository.Direction.getDirection((BareJID)owner, (BareJID)JID.jidInstanceNS((String)msg.getAttributeStaticStr("from")).getBareJID());
            object3 = object4.getAttributeStaticStr("sid");
            object2 = object4.getAttributeStaticStr("action");
            iterator = Optional.ofNullable(object4.getChild("reason")).map(element2 -> element2.findChild(element -> element.getName() != "text")).map(element -> element.getName()).orElse(null);
            try {
                this.addItemJingle(owner, stableId, (String)object3, (String)object2, (String)((Object)iterator), bl, (MessageArchiveRepository.Direction)list);
            }
            catch (RepositoryException repositoryException) {
                b.log(Level.WARNING, "Problem adding new entry to DB: " + msg, repositoryException);
            }
        }
        object4 = new ArrayList();
        list = msg.findChildren(element -> element.getName() == "reference" && "urn:xmpp:reference:0".equals(element.getXMLNS()));
        if (list != null) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                Element element3;
                object2 = (Element)object3.next();
                if (!"data".equals(object2.getAttributeStaticStr("type")) || (iterator = object2.getAttributeStaticStr("uri")) == null || !((String)((Object)iterator)).startsWith("https://") || (object = object2.getChild("media-sharing", "urn:xmpp:sims:1")) == null || (element3 = object.getChild("file", "urn:xmpp:jingle:apps:file-transfer:5")) == null) continue;
                String string = element3.getChildCData(element -> element.getName() == "media-type");
                String string2 = element3.getChildCData(element -> element.getName() == "name");
                String string3 = element3.getChildCData(element -> element.getName() == "desc");
                Long l = Optional.ofNullable(element3.getChildCData(element -> element.getName() == "size")).map(Long::parseLong).orElse(null);
                object4.add(new FileMetadata((String)((Object)iterator), string, string2, string3, l));
            }
        }
        if ((object3 = msg.mapChildren(element -> element.getName() == "oob" && "jabber:iq:oob".equals(element.getXMLNS()), element2 -> element2.getChildCData(element -> element.getName() == "url"))) != null) {
            object2 = object4.stream().map(FileMetadata::getURL).filter(arg_0 -> JDBCUnifiedArchiveRepository.a((List)object3, arg_0)).collect(Collectors.toList());
            object3.removeAll((java.util.Collection<?>)object2);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                object4.add(new FileMetadata((String)object));
            }
        }
        if (!object4.isEmpty()) {
            object2 = object4.iterator();
            while (object2.hasNext()) {
                iterator = (FileMetadata)object2.next();
                try {
                    this.addItemFile(owner, stableId, (FileMetadata)((Object)iterator));
                }
                catch (RepositoryException repositoryException) {
                    b.log(Level.WARNING, "Problem adding new entry to DB: " + msg, repositoryException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemFile(BareJID owner, String stableId, FileMetadata fileMetadata) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            String string = Algorithms.bytesToHex((byte[])messageDigest.digest(fileMetadata.getURL().getBytes(StandardCharsets.UTF_8)));
            PreparedStatement preparedStatement2 = preparedStatement = this.data_repo.getPreparedStatement(owner, this.ADD_ITEM_FILE_METADATA);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, owner.toString());
                preparedStatement.setString(2, stableId);
                preparedStatement.setString(3, string);
                preparedStatement.setString(4, fileMetadata.getURL());
                preparedStatement.setString(5, fileMetadata.getMediaType());
                preparedStatement.setString(6, fileMetadata.getName());
                preparedStatement.setString(7, fileMetadata.getDescription());
                if (fileMetadata.getSize() != null) {
                    preparedStatement.setLong(8, fileMetadata.getSize());
                } else {
                    preparedStatement.setNull(8, -5);
                }
                preparedStatement.executeUpdate();
            }
        }
        catch (NoSuchAlgorithmException | SQLException exception) {
            throw new RepositoryException("Could not add file metadata details to item", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemJingle(BareJID owner, String stableId, String sid, String action, String reason, boolean offline, MessageArchiveRepository.Direction direction) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = preparedStatement = this.data_repo.getPreparedStatement(owner, this.ADD_ITEM_JINGLE);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, owner.toString());
                preparedStatement.setString(2, stableId);
                preparedStatement.setString(3, sid);
                preparedStatement.setString(4, action);
                preparedStatement.setString(5, reason);
                preparedStatement.setShort(6, (short)(offline ? 1 : 0));
                preparedStatement.setShort(7, direction.getValue());
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Could not add jingle details to item", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemOffline(BareJID owner, String stableId, String buddyResource) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = preparedStatement = this.data_repo.getPreparedStatement(owner, this.ADD_ITEM_OFFLINE);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, owner.toString());
                preparedStatement.setString(2, stableId);
                preparedStatement.setString(3, buddyResource);
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Could not add offline details to item", (Throwable)sQLException);
        }
    }

    public QueryCriteria newQuery() {
        return new QueryCriteria();
    }

    public void queryCollections(QueryCriteria crit, MessageArchiveRepository.CollectionHandler<QueryCriteria, MessageArchiveRepository.Collection> collectionHandler) throws TigaseDBException {
        crit.setGroupByType(this.groupByType);
        super.queryCollections((tigase.archive.QueryCriteria)crit, collectionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<? extends UnifiedArchiveRepository.Item> queryRecents(BareJID ownerJid, Date start, Date end, Set<UnifiedArchiveRepository.Type> types, Set<UnifiedArchiveRepository.CallCondition> callConditions, RSM rsm) throws TigaseDBException {
        PreparedStatement preparedStatement;
        rsm.setCount(Integer.valueOf(this.queryRecentsCount(ownerJid, start, end, types, callConditions)));
        int n = 0;
        if (rsm.getIndex() != null) {
            n = rsm.getIndex();
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = preparedStatement = this.getDataRepository().getPreparedStatement(ownerJid, i);
        synchronized (preparedStatement2) {
            Object object;
            try {
                int n2 = 1;
                preparedStatement.setString(n2++, ownerJid.toString());
                if (start != null) {
                    this.data_repo.setTimestamp(preparedStatement, n2++, new Timestamp(start.getTime()));
                } else {
                    preparedStatement.setNull(n2++, 93);
                }
                if (end != null) {
                    this.data_repo.setTimestamp(preparedStatement, n2++, new Timestamp(end.getTime()));
                } else {
                    preparedStatement.setNull(n2++, 93);
                }
                preparedStatement.setShort(n2++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.chat) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.groupchat) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.call) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.success) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.missed) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.canceled) ? 1 : 0));
                preparedStatement.setInt(n2++, rsm.getMax());
                preparedStatement.setInt(n2++, n);
                resultSet = preparedStatement.executeQuery();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (resultSet.next()) {
                    object = new RecentItem(this.data_repo, ownerJid, resultSet);
                    arrayList.add(object);
                }
                if (!arrayList.isEmpty()) {
                    rsm.setResults(rsm.getCount(), ((UnifiedArchiveRepository.Item)arrayList.get(0)).getId(), ((UnifiedArchiveRepository.Item)arrayList.get(arrayList.size() - 1)).getId());
                    rsm.setIndex(Integer.valueOf(n));
                }
                object = arrayList.stream();
            }
            catch (Throwable throwable) {
                try {
                    this.getDataRepository().release(null, resultSet);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw new TigaseDBException("Failed to retrieve list of recent items", (Throwable)sQLException);
                }
            }
            this.getDataRepository().release(null, resultSet);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int queryRecentsCount(BareJID ownerJid, Date start, Date end, Set<UnifiedArchiveRepository.Type> types, Set<UnifiedArchiveRepository.CallCondition> callConditions) throws SQLException {
        PreparedStatement preparedStatement;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = preparedStatement = this.getDataRepository().getPreparedStatement(ownerJid, j);
        synchronized (preparedStatement2) {
            block9: {
                int n2;
                try {
                    int n = 1;
                    preparedStatement.setString(n++, ownerJid.toString());
                    if (start != null) {
                        this.data_repo.setTimestamp(preparedStatement, n++, new Timestamp(start.getTime()));
                    } else {
                        preparedStatement.setNull(n++, 93);
                    }
                    if (end != null) {
                        this.data_repo.setTimestamp(preparedStatement, n++, new Timestamp(end.getTime()));
                    } else {
                        preparedStatement.setNull(n++, 93);
                    }
                    preparedStatement.setShort(n++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.chat) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.groupchat) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.call) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.success) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.missed) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.canceled) ? 1 : 0));
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block9;
                    n2 = resultSet.getInt(1);
                }
                catch (Throwable throwable) {
                    this.getDataRepository().release(null, resultSet);
                    throw throwable;
                }
                this.getDataRepository().release(null, resultSet);
                return n2;
            }
            int n = 0;
            this.getDataRepository().release(null, resultSet);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<? extends UnifiedArchiveRepository.FileItem> queryFiles(UnifiedArchiveRepository.FileQuery query, RSM rsm) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            int n = this.queryFilesCount(query);
            Integer n2 = this.queryFilesPosition(query, rsm.getBefore());
            Integer n3 = this.queryFilesPosition(query, rsm.getAfter());
            this.calculateOffsetAndPosition(rsm, n, n2, n3);
            ArrayList<FileItem> arrayList = new ArrayList<FileItem>();
            PreparedStatement preparedStatement2 = preparedStatement = this.data_repo.getPreparedStatement(query.getDomain(), this.QUERY_FILE_METADATA);
            synchronized (preparedStatement2) {
                int n4 = this.setFileQueryParams(preparedStatement, query);
                preparedStatement.setInt(n4++, rsm.getMax());
                preparedStatement.setInt(n4++, rsm.getIndex());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        arrayList.add(new FileItem(resultSet));
                    }
                }
            }
            return arrayList.stream();
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Could not query transferred files", (Throwable)sQLException);
        }
    }

    protected int queryFilesCount(UnifiedArchiveRepository.FileQuery query) throws RepositoryException {
        return this.queryFilesOffset(query, null);
    }

    protected Integer queryFilesPosition(UnifiedArchiveRepository.FileQuery query, String id) throws RepositoryException {
        if (id == null) {
            return null;
        }
        return this.queryFilesOffset(query, id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer queryFilesOffset(UnifiedArchiveRepository.FileQuery query, String id) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = preparedStatement = this.data_repo.getPreparedStatement(query.getDomain(), this.QUERY_FILE_METADATA_OFFSET);
            synchronized (preparedStatement2) {
                int n = this.setFileQueryParams(preparedStatement, query);
                if (id == null) {
                    preparedStatement.setNull(n++, 12);
                } else {
                    preparedStatement.setString(n++, id);
                }
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        Integer n2 = resultSet.getInt(1);
                        return n2;
                    }
                    Integer n3 = null;
                    return n3;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Could not count transferred files", (Throwable)sQLException);
        }
    }

    protected int setFileQueryParams(PreparedStatement ps, UnifiedArchiveRepository.FileQuery query) throws SQLException {
        int n = 1;
        if (query.getOwner() == null) {
            ps.setString(n++, query.getDomain().toString());
        } else {
            ps.setString(n++, null);
        }
        ps.setString(n++, Optional.ofNullable(query.getOwner()).map(BareJID::toString).orElse(null));
        ps.setString(n++, Optional.ofNullable(query.getBuddy()).map(BareJID::toString).orElse(null));
        ps.setTimestamp(n++, Optional.ofNullable(query.getAfter()).map(Date::getTime).map(Timestamp::new).orElse(null));
        ps.setTimestamp(n++, Optional.ofNullable(query.getBefore()).map(Date::getTime).map(Timestamp::new).orElse(null));
        ps.setString(n++, query.getContains());
        ps.setString(n++, query.getMediaType());
        if (query.getSmallerThan() != null) {
            ps.setLong(n++, query.getSmallerThan());
        } else {
            ps.setNull(n++, -5);
        }
        if (query.getBiggerThan() != null) {
            ps.setLong(n++, query.getBiggerThan());
        } else {
            ps.setNull(n++, -5);
        }
        return n;
    }

    protected void initPreparedStatements(DataRepository data_repo) throws SQLException {
        super.initPreparedStatements(data_repo);
        data_repo.initPreparedStatement(i, i);
        data_repo.initPreparedStatement(j, j);
        data_repo.initPreparedStatement(this.ADD_ITEM_JINGLE, this.ADD_ITEM_JINGLE);
        data_repo.initPreparedStatement(this.ADD_ITEM_OFFLINE, this.ADD_ITEM_OFFLINE);
        data_repo.initPreparedStatement(this.ADD_ITEM_FILE_METADATA, this.ADD_ITEM_FILE_METADATA);
        data_repo.initPreparedStatement(this.QUERY_FILE_METADATA, this.QUERY_FILE_METADATA);
        data_repo.initPreparedStatement(this.QUERY_FILE_METADATA_OFFSET, this.QUERY_FILE_METADATA_OFFSET);
    }

    protected Collection newCollectionInstance() {
        return new Collection();
    }

    protected Item newItemInstance() {
        return new Item();
    }

    protected int setQueryParams(PreparedStatement stmt, QueryCriteria crit, FasteningCollation fasteningCollation) throws SQLException {
        int n = super.setQueryParams(stmt, (tigase.archive.QueryCriteria)crit, fasteningCollation);
        if (crit.getGroupByType() != null) {
            stmt.setShort(n++, (short)(crit.getGroupByType() != false ? 1 : 0));
        }
        if (crit.getItemType() != null) {
            stmt.setShort(n++, crit.getItemType().getShortValue());
        } else {
            stmt.setObject(n++, null);
        }
        if (crit.getOffline() != null) {
            stmt.setShort(n++, (short)(crit.getOffline() != false ? 1 : 0));
        } else {
            stmt.setObject(n++, null);
        }
        return n;
    }

    protected DataRepository getDataRepository() {
        return this.data_repo;
    }

    private static /* synthetic */ boolean a(List list, String string) {
        return list.contains(string);
    }

    public static class RecentItem
    implements UnifiedArchiveRepository.Item {
        private static final SimpleParser a = SingletonFactory.getParserInstance();
        private final String b;
        private final MessageArchiveRepository.Direction c;
        private final Long d;
        private final UnifiedArchiveRepository.ItemType e;
        private final Element f;
        private final String g;
        private final Timestamp h;
        private final String i;

        protected RecentItem(DataRepository repo, BareJID owner, ResultSet rs) throws SQLException {
            this.i = rs.getString(1);
            JID jID = JID.jidInstanceNS((String)this.i);
            this.c = jID == null || !owner.equals((Object)jID.getBareJID()) ? MessageArchiveRepository.Direction.outgoing : MessageArchiveRepository.Direction.incoming;
            this.h = repo.getTimestamp(rs, 2);
            String string = rs.getString(3);
            this.e = UnifiedArchiveRepository.ItemType.from(rs.getShort(4));
            this.b = rs.getString(5);
            DomBuilderHandler domBuilderHandler = new DomBuilderHandler();
            a.parse((SimpleHandler)domBuilderHandler, string.toCharArray(), 0, string.length());
            this.f = (Element)domBuilderHandler.getParsedElements().poll();
            this.g = rs.getString(6);
            this.d = rs.getLong(7);
        }

        public String getId() {
            return this.g;
        }

        public Element getMessage() {
            return this.f;
        }

        public Date getTimestamp() {
            return this.h;
        }

        public MessageArchiveRepository.Direction getDirection() {
            return this.c;
        }

        public String getWith() {
            return this.i;
        }

        @Override
        public UnifiedArchiveRepository.ItemType getItemType() {
            return this.e;
        }

        @Override
        public Long getDuration() {
            return this.d;
        }

        @Override
        public String getCondition() {
            return this.b;
        }
    }

    protected static class Item
    extends JDBCMessageArchiveRepository.Item<QueryCriteria>
    implements UnifiedArchiveRepository.Item {
        private UnifiedArchiveRepository.ItemType a = null;

        protected Item() {
        }

        @Override
        public UnifiedArchiveRepository.ItemType getItemType() {
            return this.a;
        }

        @Override
        public Long getDuration() {
            return null;
        }

        @Override
        public String getCondition() {
            return null;
        }

        protected int read(DataRepository repo, ResultSet rs, QueryCriteria crit) throws SQLException {
            int n = super.read(repo, rs, (tigase.archive.QueryCriteria)crit);
            if (!crit.hasItemType()) {
                this.a = UnifiedArchiveRepository.ItemType.from(rs.getShort(n++));
            }
            return n;
        }
    }

    protected static class Collection
    extends JDBCMessageArchiveRepository.Collection<QueryCriteria> {
        private String a;

        protected Collection() {
        }

        public String getType() {
            return this.a;
        }

        protected int read(DataRepository repo, ResultSet rs, QueryCriteria crit) throws SQLException {
            int n = super.read(repo, rs, (tigase.archive.QueryCriteria)crit);
            this.a = rs.getString(n++);
            return n;
        }

        public void addAdditionalData(Element collectionElem) {
            super.addAdditionalData(collectionElem);
            if (this.a != null && !this.a.isEmpty()) {
                collectionElem.addAttribute("type", this.a);
            }
        }
    }

    public static class FileMetadata
    implements UnifiedArchiveRepository.FileMetadata {
        public final String url;
        public Long size;
        public String description;
        public String name;
        public String mediaType;

        public FileMetadata(String url, String mediaType, String name, String description, Long size) {
            this(url);
            this.mediaType = mediaType;
            this.name = name;
            this.description = description;
            this.size = size;
        }

        public FileMetadata(String url) {
            this.url = url;
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public String getMediaType() {
            return this.mediaType;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileMetadata)) {
                return false;
            }
            FileMetadata fileMetadata = (FileMetadata)o;
            return this.url.equals(fileMetadata.url) && Objects.equals(this.size, fileMetadata.size) && Objects.equals(this.description, fileMetadata.description) && Objects.equals(this.name, fileMetadata.name) && Objects.equals(this.mediaType, fileMetadata.mediaType);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.size, this.description, this.name, this.mediaType);
        }

        public String toString() {
            return "FileMetadata{url='" + this.url + "', size=" + this.size + ", description='" + this.description + "', name='" + this.name + "', mediaType='" + this.mediaType + "'}";
        }
    }

    public static class FileItem
    extends FileMetadata
    implements UnifiedArchiveRepository.FileItem {
        private final String a;
        private final BareJID b;
        private final BareJID c;
        private final Date d;

        public FileItem(ResultSet rs) throws SQLException {
            super(rs.getString(5), rs.getString(6), rs.getString(7), rs.getString(8), (Long)rs.getObject(9));
            this.b = BareJID.bareJIDInstanceNS((String)rs.getString(1));
            this.c = BareJID.bareJIDInstanceNS((String)rs.getString(2));
            this.d = rs.getTimestamp(3);
            this.a = rs.getString(4).toLowerCase();
        }

        public FileItem(BareJID owner, BareJID buddy, Date timestamp, String stableId, String url, String mediaType, String name, String description, Long size) {
            super(url, mediaType, name, description, size);
            this.a = stableId;
            this.b = owner;
            this.c = buddy;
            this.d = timestamp;
        }

        @Override
        public String getId() {
            return this.a;
        }

        @Override
        public BareJID getOwner() {
            return this.b;
        }

        @Override
        public BareJID getBuddy() {
            return this.c;
        }

        @Override
        public Date getTimestamp() {
            return this.d;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileItem)) {
                return false;
            }
            FileItem fileItem = (FileItem)o;
            return Objects.equals(this.a, fileItem.a) && Objects.equals(this.b, fileItem.b) && Objects.equals(this.c, fileItem.c) && Objects.equals(this.d, fileItem.d) && super.equals(fileItem);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.a, this.b, this.c, this.d);
        }

        @Override
        public String toString() {
            return "FileItem{id='" + this.a + "', owner=" + this.b + ", buddy=" + this.c + ", timestamp=" + this.d.getTime() + ", super: " + super.toString() + "}";
        }
    }
}

