/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import java.util.logging.Level;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="invitations", active=true)
public class MediatedInvitationModule
extends AbstractMucModule {
    public static final String ID = "invitations";
    private static final Criteria CRIT = ElementCriteria.name((String)"message").add(ElementCriteria.name((String)"x", (String)"http://jabber.org/protocol/muc#user").add((Criteria)new Or(new Criteria[]{ElementCriteria.name((String)"invite"), ElementCriteria.name((String)"decline")})));
    @Inject
    private IMucRepository repository;

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet element) throws MUCException {
        try {
            JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
            if (MediatedInvitationModule.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to"))) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Room " + roomJID + " does not exists on this server.");
            }
            String nickName = room.getOccupantsNickname(senderJID);
            Role senderRole = room.getRole(nickName);
            Affiliation senderAffiliation = room.getAffiliation(senderJID.getBareJID()).getAffiliation();
            Element x = element.getElement().getChild("x", "http://jabber.org/protocol/muc#user");
            List ch = x.getChildren();
            for (Element child : ch) {
                if (element.getType() == StanzaType.error && "invite".equals(child.getName())) {
                    this.processInvitationErrorResponse(child, element.getErrorCondition(), roomJID, senderJID);
                    continue;
                }
                if ("invite".equals(child.getName()) && element.getType() != StanzaType.error) {
                    this.doInvite(element, child, room, roomJID, senderJID, senderRole, senderAffiliation);
                    continue;
                }
                if (!"decline".equals(child.getName()) || element.getType() == StanzaType.error) continue;
                this.doDecline(child, roomJID, senderJID);
            }
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Error during processing invitation", e);
            throw new RuntimeException(e);
        }
    }

    private void doDecline(Element decline, BareJID roomJID, JID senderJID) throws TigaseStringprepException {
        Element reason = decline.getChild("reason");
        JID recipient = JID.jidInstance((String)decline.getAttributeStaticStr("to"));
        Packet resultMessage = Packet.packetInstance((Element)new Element("message", new String[]{"from", "to"}, new String[]{roomJID.toString(), recipient.toString()}));
        resultMessage.setXMLNS("jabber:client");
        Element resultX = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        resultMessage.getElement().addChild((XMLNodeIfc)resultX);
        Element resultDecline = new Element("decline", new String[]{"from"}, new String[]{senderJID.toString()});
        resultX.addChild((XMLNodeIfc)resultDecline);
        if (reason != null) {
            resultDecline.addChild((XMLNodeIfc)reason.clone());
        }
        this.write(resultMessage);
    }

    private void doInvite(Packet message, Element invite, Room room, BareJID roomJID, JID senderJID, Role senderRole, Affiliation senderAffiliation) throws RepositoryException, TigaseStringprepException, MUCException {
        Element bdy;
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND);
        }
        if (!room.getConfig().isInvitingAllowed() && senderAffiliation.lowerThan(Affiliation.admin)) {
            throw new MUCException(Authorization.FORBIDDEN, "Occupants are not allowed to invite others");
        }
        if (!senderRole.isInviteOtherUsers()) {
            throw new MUCException(Authorization.FORBIDDEN, "Your role is '" + senderRole + "'. You cannot invite others.");
        }
        Element reason = invite.getChild("reason");
        Element cont = invite.getChild("continue");
        JID recipient = JID.jidInstance((String)invite.getAttributeStaticStr("to"));
        Packet resultMessage = Packet.packetInstance((Element)new Element("message", new String[]{"from", "to"}, new String[]{roomJID.toString(), recipient.toString()}));
        resultMessage.setXMLNS("jabber:client");
        String id = message.getAttributeStaticStr("id");
        if (id != null) {
            resultMessage.getElement().addAttribute("id", id);
        }
        Element resultX = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        resultMessage.getElement().addChild((XMLNodeIfc)resultX);
        if (room.getConfig().isRoomMembersOnly() && (senderAffiliation.isEditMemberList() || room.getConfig().isInvitingAllowed())) {
            room.addAffiliationByJid(recipient.getBareJID(), RoomAffiliation.member);
        }
        Element resultInvite = new Element("invite", new String[]{"from"}, new String[]{senderJID.toString()});
        resultX.addChild((XMLNodeIfc)resultInvite);
        if (room.getConfig().isPasswordProtectedRoom()) {
            resultX.addChild((XMLNodeIfc)new Element("password", room.getConfig().getPassword()));
        }
        if (reason != null) {
            resultInvite.addChild((XMLNodeIfc)reason.clone());
        }
        if (cont != null) {
            resultInvite.addChild((XMLNodeIfc)cont.clone());
        }
        if ((bdy = message.getElement().getChild("body")) != null) {
            resultMessage.getElement().addChild((XMLNodeIfc)bdy.clone());
        }
        this.write(resultMessage);
    }

    private void processInvitationErrorResponse(Element invite, String errorCondition, BareJID roomJID, JID senderJID) throws TigaseStringprepException {
        JID recipient = JID.jidInstance((String)invite.getAttributeStaticStr("from"));
        Packet resultMessage = Packet.packetInstance((Element)new Element("message", new String[]{"from", "to"}, new String[]{roomJID.toString(), recipient.toString()}));
        resultMessage.setXMLNS("jabber:client");
        Element resultX = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        resultMessage.getElement().addChild((XMLNodeIfc)resultX);
        Element resultDecline = new Element("decline", new String[]{"from"}, new String[]{senderJID.toString()});
        resultX.addChild((XMLNodeIfc)resultDecline);
        Element reason = new Element("reason", "Your invitation is returned with error" + (String)(errorCondition == null ? "." : ": " + errorCondition));
        resultDecline.addChild((XMLNodeIfc)reason);
        this.write(resultMessage);
    }
}

