/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.modules.agent;

import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.workgroupqueues.modules.AbstractModule;
import tigase.workgroupqueues.scheduler.Agent;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.workgroupqueues.scheduler.User;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="AgentPresenceModule", active=true)
public class PresenceModule
extends AbstractModule {
    public static final String ID = "AgentPresenceModule";
    private static final Criteria a = ElementCriteria.name((String)"presence").add((Criteria)ElementCriteria.name((String)"agent-status", (String)"http://jabber.org/protocol/workgroup"));
    private static final String[] b = new String[]{"presence", "agent-status", "max-chats"};
    private final TimestampHelper c = new TimestampHelper();
    @Inject
    private Controller controller;
    @Inject
    private Store store;

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/workgroup"};
    }

    public Criteria getModuleCriteria() {
        return a;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        JID jID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
        BareJID bareJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
        WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(bareJID);
        if (workgroupQueueEntity == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Workgroup not found");
        }
        Queue queue = this.controller.getQueue(bareJID);
        if (!this.a(jID, workgroupQueueEntity)) {
            throw new ComponentException(Authorization.NOT_AUTHORIZED, "Not authorized to send stanza as agent");
        }
        Agent agent = queue.getAgent(jID);
        if (agent == null) {
            agent = this.a(packet, jID, queue);
        } else if (packet.getType() == StanzaType.unavailable) {
            this.a(packet, agent, queue);
        } else {
            this.b(packet, agent, queue);
        }
        this.sendPresenceUpdateOf(agent);
    }

    public void sendAgentStatusUpdate(Agent agent) throws TigaseStringprepException {
        Queue queue = this.controller.getQueue(agent.getWorkgroupQueue());
        Element element = new Element("presence", new String[]{"from", "to"}, new String[]{agent.getWorkgroupQueue().toString(), agent.getJid().toString()});
        Element element2 = new Element("notify-agents", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/workgroup"});
        element.addChild((XMLNodeIfc)element2);
        element2.addChild((XMLNodeIfc)new Element("available", String.valueOf(queue.getAvailableAgents())));
        element2.addChild((XMLNodeIfc)new Element("current-chats", String.valueOf(queue.getCurrentChats())));
        element2.addChild((XMLNodeIfc)new Element("max-chats", String.valueOf(queue.getMaxChats())));
        this.write(Packet.packetInstance((Element)element));
    }

    public void sendPresenceUpdateOf(Agent agent) throws TigaseStringprepException {
        Queue queue = this.controller.getQueue(agent.getWorkgroupQueue());
        for (Agent agent2 : queue.getAgents()) {
            if (agent2.equals(agent) || !agent2.isAgentStatusUpdateRequested()) continue;
            Element element = new Element("presence", new String[]{"from", "to"}, new String[]{agent.getJid().toString(), agent2.getJid().toString()});
            Element element2 = new Element("agent-status", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/workgroup"});
            element.addChild((XMLNodeIfc)element2);
            element2.addChild((XMLNodeIfc)new Element("max-chats", String.valueOf(agent.getMaxChats())));
            this.write(Packet.packetInstance((Element)element));
        }
    }

    public void sendQueueStatusDetailsUpdate(Agent agent) throws TigaseStringprepException {
        Queue queue = this.controller.getQueue(agent.getWorkgroupQueue());
        Element element = new Element("presence", new String[]{"from", "to"}, new String[]{agent.getWorkgroupQueue().toString(), agent.getJid().toString()});
        Element element2 = new Element("notify-queue-details", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/workgroup"});
        element.addChild((XMLNodeIfc)element2);
        for (User user : queue.getUsers()) {
            Element element3 = new Element("user", new String[]{"jid"}, new String[]{user.getJid().toString()});
            element2.addChild((XMLNodeIfc)element3);
            element3.addChild((XMLNodeIfc)new Element("position", String.valueOf(-1)));
            element3.addChild((XMLNodeIfc)new Element("time", String.valueOf(-1)));
            element3.addChild((XMLNodeIfc)new Element("join-time", this.c.format(user.getJoinTime())));
        }
        this.write(Packet.packetInstance((Element)element));
    }

    public void sendQueueStatusUpdate(Agent agent) throws TigaseStringprepException {
        Queue queue = this.controller.getQueue(agent.getWorkgroupQueue());
        Element element = new Element("presence", new String[]{"from", "to"}, new String[]{agent.getWorkgroupQueue().toString(), agent.getJid().toString()});
        Element element2 = new Element("notify-queue", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/workgroup"});
        element.addChild((XMLNodeIfc)element2);
        int n = queue.getUsers().size();
        element2.addChild((XMLNodeIfc)new Element("count", String.valueOf(n)));
        if (n > 0) {
            element2.addChild((XMLNodeIfc)new Element("oldest", this.c.format(queue.getOldestTime())));
        }
        element2.addChild((XMLNodeIfc)new Element("time", String.valueOf(queue.getAverageWaitingTime())));
        element2.addChild((XMLNodeIfc)new Element("status", queue.getStatus().name()));
        this.write(Packet.packetInstance((Element)element));
    }

    private void a(Packet packet, Agent agent, Queue queue) {
        this.controller.removeAgent(agent);
    }

    private Agent a(Packet packet, JID jID, Queue queue) {
        Agent agent = new Agent(jID, queue.getJid());
        this.a(packet, agent);
        this.controller.addAgent(agent);
        return agent;
    }

    private void b(Packet packet, Agent agent, Queue queue) {
        this.a(packet, agent);
        this.controller.updateAgent(agent);
    }

    private boolean a(JID jID, WorkgroupQueueEntity workgroupQueueEntity) {
        if (jID == null || workgroupQueueEntity.getAgents() == null) {
            return false;
        }
        for (BareJID bareJID : workgroupQueueEntity.getAgents()) {
            if (!jID.getBareJID().equals((Object)bareJID)) continue;
            return true;
        }
        return false;
    }

    private void a(Packet packet, Agent agent) {
        String string = packet.getElemCDataStaticStr(Presence.PRESENCE_SHOW_PATH);
        agent.setState(string == null ? Agent.State.chat : Agent.State.valueOf(string));
        String string2 = packet.getElemCDataStaticStr(b);
        agent.setMaxChats(string2 == null ? null : Integer.valueOf(string2));
    }
}

