/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.cluster;

import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.cluster.MixComponentClustered;
import tigase.mix.cluster.StrategyIfc;
import tigase.mix.model.IParticipant;
import tigase.mix.model.MixRepository;
import tigase.pubsub.exceptions.PubSubException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

@Bean(name="mixRepository", parent=MixComponentClustered.class, active=true)
public class MixRepositoryClustered<T>
extends MixRepository<T> {
    @Inject
    private StrategyIfc strategy;

    public void itemWritten(BareJID serviceJID, String node, String id, String publisher, Element item, String uuid) {
        super.itemWritten(serviceJID, node, id, publisher, item, uuid);
        if ("urn:xmpp:mix:nodes:config".equals(node)) {
            this.strategy.channelConfigurationChanged(serviceJID, item);
        }
    }

    public void updateChannelConfiguration(BareJID serviceJID, Element item) {
        super.updateChannelConfiguration(serviceJID, item);
    }

    public IParticipant updateParticipant(BareJID channelJID, BareJID participantJID, String nick) throws RepositoryException, PubSubException {
        IParticipant iParticipant = super.updateParticipant(channelJID, participantJID, nick);
        this.strategy.invalidateChannelParticipant(channelJID, participantJID);
        return iParticipant;
    }

    public void removeParticiapnt(BareJID channelJID, BareJID participantJID) throws RepositoryException {
        super.removeParticiapnt(channelJID, participantJID);
        this.strategy.invalidateChannelParticipant(channelJID, participantJID);
    }

    public void invalidateChannelParticipant(BareJID channelJID, BareJID participantJID) throws RepositoryException {
        super.invalidateChannelParticipant(channelJID, participantJID);
    }
}

