/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.BareJID;

@Id(value="motd")
@Handles(value={@Handle(path={"presence"}, xmlns="jabber:client")})
@Bean(name="motd", parent=SessionManager.class, active=false)
public class MotdProcessor
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc,
Initializable,
UnregisterAware {
    protected static final String ID = "motd";
    private static final Logger log = Logger.getLogger(MotdProcessor.class.getCanonicalName());
    private static final long HOURS_24 = 86400000L;
    private static final String[] PRESENCE_PRIORITY_PATH = new String[]{"presence", "priority"};
    private static final BareJID smJid = BareJID.bareJIDInstanceNS((String)"sess-man");
    @Inject
    private EventBus eventBus;
    private String motd = null;
    private Long motdTimestamp = null;
    @Inject
    private UserRepository userRepository;

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    @Override
    public void initialize() {
        try {
            this.motd = this.userRepository.getData(smJid, ID, "message");
            String stamp = this.userRepository.getData(smJid, ID, "timestamp");
            this.motdTimestamp = stamp == null ? null : Long.valueOf(Long.parseLong(stamp));
        }
        catch (UserNotFoundException ex) {
            log.log(Level.FINEST, "MotD has never been set - nothing to load");
            try {
                this.userRepository.addUser(smJid);
            }
            catch (TigaseDBException ex1) {
                log.log(Level.WARNING, "failed to create user '" + smJid + "' for SessionManager", ex1);
            }
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "failed to read current MOTD from user repository", ex);
        }
        this.eventBus.registerAll(this);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (packet.getStanzaTo() != null) {
            return;
        }
        if (session.getSessionData(ID) != null) {
            return;
        }
        String priority = packet.getElemCDataStaticStr(PRESENCE_PRIORITY_PATH);
        if (priority != null && Integer.parseInt(priority) < 0) {
            return;
        }
        session.putSessionData(ID, ID);
        if (this.motd == null || this.motdTimestamp == null) {
            return;
        }
        long deliveryTimestamp = this.getLastDeliveryTime(session);
        if (deliveryTimestamp > this.motdTimestamp && deliveryTimestamp + 86400000L > System.currentTimeMillis()) {
            return;
        }
        this.setLastDeliveryTime(session);
        Element messageEl = new Element("message");
        messageEl.setXMLNS("jabber:client");
        messageEl.addChild((XMLNodeIfc)new Element("body", this.motd));
        Message message = new Message(messageEl, session.getDomainAsJID(), session.getJID());
        message.setPacketTo(session.getConnectionId());
        results.add(message);
    }

    @HandleEvent
    public void onMotdChanged(MotdUpdatedEvent event) {
        this.motd = event.getMessage();
        this.motdTimestamp = event.getTimestmap();
    }

    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String motd) throws TigaseDBException {
        Long timestamp;
        Long l = timestamp = motd == null ? null : Long.valueOf(System.currentTimeMillis());
        if (motd != null) {
            this.userRepository.setData(smJid, ID, "message", motd);
            this.userRepository.setData(smJid, ID, "timestamp", String.valueOf(timestamp));
        } else {
            this.userRepository.removeData(smJid, ID, "message");
            this.userRepository.removeData(smJid, ID, "timestamp");
        }
        this.eventBus.fire(new MotdUpdatedEvent(motd, timestamp));
    }

    private long getLastDeliveryTime(XMPPResourceConnection session) {
        try {
            String str = session.getData(ID, "last-delivery", null);
            if (str == null) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        catch (TigaseDBException | NotAuthorizedException ex) {
            log.log(Level.FINEST, session.toString() + ", could not retrieve last delivery timestamp", ex);
            return 0L;
        }
    }

    private void setLastDeliveryTime(XMPPResourceConnection session) {
        try {
            String stamp = String.valueOf(System.currentTimeMillis());
            session.setData(ID, "last-delivery", stamp);
        }
        catch (TigaseDBException | NotAuthorizedException ex) {
            log.log(Level.FINEST, session.toString() + ", could not update last delivery timestamp", ex);
        }
    }

    public static class MotdUpdatedEvent
    implements Serializable {
        private String message;
        private Long timestamp;

        public MotdUpdatedEvent() {
        }

        public MotdUpdatedEvent(String msg, Long timestamp) {
            this.message = msg;
            this.timestamp = timestamp;
        }

        public String getMessage() {
            return this.message;
        }

        public Long getTimestmap() {
            return this.timestamp;
        }
    }
}

