/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.workqueue;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.sys.TigaseRuntime;
import tigase.util.workqueue.NonpriorityQueue;
import tigase.util.workqueue.PriorityQueueRelaxed;

public abstract class PriorityQueueAbstract<E> {
    public static final String NONPRIORITY_QUEUE = "nonpriority-queue";
    public static final String QUEUE_IMPLEMENTATION = "queue-implementation";
    private static final Logger log = Logger.getLogger(PriorityQueueAbstract.class.getName());

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static <E> PriorityQueueAbstract<E> getPriorityQueue(int maxPriority, int maxSize) {
        Class result = null;
        String queue_class = System.getProperty(QUEUE_IMPLEMENTATION, null);
        if (queue_class == null || queue_class.isEmpty()) {
            result = Boolean.getBoolean(NONPRIORITY_QUEUE) ? NonpriorityQueue.class : PriorityQueueRelaxed.class;
        } else {
            try {
                result = Class.forName(queue_class);
            }
            catch (Exception e) {
                log.log(Level.CONFIG, "Error crating priority queue", e);
                TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"Error: Could not instantiate or initialize priority queue of class: " + queue_class, "Got exception: " + e.getMessage()});
            }
        }
        return PriorityQueueAbstract.getPriorityQueue(maxPriority, maxSize, result);
    }

    public static <E> PriorityQueueAbstract<E> getPriorityQueue(int maxPriority, int maxSize, Class<? extends PriorityQueueAbstract> queueClass) {
        try {
            PriorityQueueAbstract result = queueClass.newInstance();
            result.init(maxPriority, maxSize);
            log.log(Level.FINER, "Initialized queue implementation: " + result.getClass().getName());
            return result;
        }
        catch (Exception e) {
            log.log(Level.CONFIG, "Error crating priority queue", e);
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"Error: Could not instantiate or initialize priority queue of class: " + queueClass, "Got exception: " + e.getMessage()});
            return null;
        }
    }

    public abstract void init(int var1, int var2);

    public abstract boolean offer(E var1, int var2);

    public abstract void put(E var1, int var2) throws InterruptedException;

    public abstract void setMaxSize(int var1);

    public abstract int[] size();

    public abstract E take() throws InterruptedException;

    public abstract int totalSize();
}

