/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.annotations.TigaseDeprecated;
import tigase.conf.ConfigItem;
import tigase.conf.ConfigRepositoryIfc;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationCache;
import tigase.conf.ConfigurationException;
import tigase.conf.MonitoringSetupIfc;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryMDImpl;
import tigase.db.DBInitException;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.db.UserRepositoryMDImpl;
import tigase.db.comp.RepositoryChangeListenerIfc;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSUtil;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.ServerComponent;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.log.LogFormatter;
import tigase.util.repository.DataTypes;
import tigase.xmpp.jid.BareJID;

public abstract class ConfiguratorAbstract
extends AbstractComponentRegistrator<Configurable>
implements RepositoryChangeListenerIfc<ConfigItem>,
StatisticsContainer {
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String AUTH_DOMAIN_POOL_CLASS_PROP_KEY = "auth-domain-repo-pool";
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String AUTH_DOMAIN_POOL_CLASS_PROP_VAL = "tigase.db.AuthRepositoryMDImpl";
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String CONFIG_REPO_CLASS_INIT_KEY = "--tigase-config-repo-class";
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String CONFIG_REPO_CLASS_PROP_KEY = "tigase-config-repo-class";
    public static final String INIT_PROPERTIES_MAP_BIND = "initProperties";
    public static final String PROPERTY_FILENAME_PROP_KEY = "--property-file";
    public static final String PROPERTY_FILENAME_PROP_DEF = "etc/init.properties";
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String USER_DOMAIN_POOL_CLASS_PROP_KEY = "user-domain-repo-pool";
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public static final String USER_DOMAIN_POOL_CLASS_PROP_VAL = "tigase.db.UserRepositoryMDImpl";
    public static final String LOGGING_KEY = "logging/";
    private static final Logger log = Logger.getLogger(ConfiguratorAbstract.class.getName());
    public static String logManagerConfiguration = null;
    private static MonitoringSetupIfc monitoring = null;
    private AuthRepositoryMDImpl auth_repo_impl = null;
    private Map<String, String> auth_repo_params = null;
    private AuthRepository auth_repository = null;
    private ConfigRepositoryIfc configRepo = new ConfigurationCache();
    private Map<String, Object> initProperties = new LinkedHashMap<String, Object>(100);
    private List<String> initSettings = new LinkedList<String>();
    private Map<String, String> loggingSetup = new LinkedHashMap<String, String>(10);
    private boolean setup_in_progress = false;
    private UserRepositoryMDImpl user_repo_impl = null;
    private Map<String, String> user_repo_params = null;
    private UserRepository user_repository = null;

    public static Object getMXBean(String objName) {
        if (monitoring != null) {
            return monitoring.getMXBean(objName);
        }
        return null;
    }

    public static void loadFromPropertiesFiles(String property_filenames, Map<String, Object> initProperties, List<String> initSettings) {
        if (property_filenames != null) {
            Object f;
            String[] prop_files = property_filenames.split(",");
            if (prop_files.length == 1 && !((File)(f = new File(prop_files[0]))).exists()) {
                log.log(Level.WARNING, "Provided property file {0} does NOT EXISTS! Using default one {1}", new String[]{((File)f).getAbsolutePath(), PROPERTY_FILENAME_PROP_DEF});
                prop_files[0] = PROPERTY_FILENAME_PROP_DEF;
            }
            for (String property_filename : prop_files) {
                log.log(Level.CONFIG, "Loading initial properties from property file: {0}", property_filename);
                try (FileReader fileReader = new FileReader(property_filename);){
                    Properties defProps = new Properties();
                    defProps.load(fileReader);
                    Set<String> prop_keys = defProps.stringPropertyNames();
                    for (String key : prop_keys) {
                        String value = defProps.getProperty(key).trim();
                        if (key.startsWith("-") || key.equals("config-type")) {
                            if ("--test".equalsIgnoreCase(key)) {
                                initProperties.put(key.trim().substring(2), DataTypes.parseBool(value));
                                initProperties.put(key.trim(), DataTypes.parseBool(value));
                            } else {
                                initProperties.put(key.trim(), value);
                            }
                            log.log(Level.CONFIG, "Added default config parameter: ({0}={1})", new Object[]{key, value});
                            continue;
                        }
                        initSettings.add(key + "=" + value);
                    }
                }
                catch (FileNotFoundException e) {
                    log.log(Level.WARNING, "Given property file was not found: {0}", property_filename);
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Can not read property file: " + (String)property_filename, e);
                }
            }
        }
        for (Map.Entry<String, Object> entry : initProperties.entrySet()) {
            if (!entry.getKey().startsWith("--")) continue;
            System.setProperty(entry.getKey().substring(2), entry.getValue() == null ? null : entry.getValue().toString());
            if (!"--cluster-mode".equals(entry.getKey()) || !"true".equalsIgnoreCase(entry.getValue().toString())) continue;
            System.setProperty("tigase.cache", "false");
            log.log(Level.WARNING, "Tigase cache turned off");
        }
    }

    public static void loadFromPropertiesFiles(Map<String, Object> initProperties, List<String> initSettings) {
        String property_filenames = (String)initProperties.get(PROPERTY_FILENAME_PROP_KEY);
        if (property_filenames == null) {
            property_filenames = PROPERTY_FILENAME_PROP_DEF;
            log.log(Level.WARNING, "No property file not specified! Using default one {0}", property_filenames);
        }
        ConfiguratorAbstract.loadFromPropertiesFiles(property_filenames, initProperties, initSettings);
    }

    public static void loadLogManagerConfig(String config) {
        logManagerConfiguration = config;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(config.getBytes());
            LogManager.getLogManager().readConfiguration(bis);
            bis.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Can not configure logManager", e);
        }
    }

    public static void parseArgs(Map<String, Object> initProperties, List<String> initSettings, String[] args) {
        initProperties.put("--test", Boolean.FALSE);
        initProperties.put("config-type", "--gen-config-default");
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String key = null;
                Object val = null;
                if (args[i].startsWith("--gen-config")) {
                    key = "config-type";
                    val = args[i];
                }
                if (args[i].startsWith("--test")) {
                    key = args[i];
                    val = Boolean.TRUE;
                }
                if (key == null && args[i].startsWith("-") && !args[i].startsWith("--gen-config")) {
                    key = args[i];
                    val = args[++i];
                }
                if (key == null || val == null) continue;
                initProperties.put(key, val);
                log.log(Level.CONFIG, "Setting defaults: {0} = {1}", new Object[]{key, val.toString()});
            }
        }
    }

    public static void putMXBean(String objName, Object bean) {
        if (monitoring != null) {
            monitoring.putMXBean(objName, bean);
        }
    }

    @Override
    public void componentAdded(Configurable component) throws ConfigurationException {
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, " component: {0}", component.getName());
        }
        this.setup(component);
    }

    @Override
    public void componentRemoved(Configurable component) {
    }

    public void init(String[] args) throws ConfigurationException, TigaseDBException {
        String property_filenames;
        String cnf_class_name;
        ConfiguratorAbstract.parseArgs(this.initProperties, this.initSettings, args);
        String stringprep = (String)this.initProperties.get("--stringprep-processor");
        if (stringprep != null) {
            BareJID.useStringprepProcessor((String)stringprep);
        }
        if ((cnf_class_name = System.getProperty(CONFIG_REPO_CLASS_PROP_KEY)) != null) {
            this.initProperties.put(CONFIG_REPO_CLASS_INIT_KEY, cnf_class_name);
        }
        if ((cnf_class_name = (String)this.initProperties.get(CONFIG_REPO_CLASS_INIT_KEY)) != null) {
            try {
                this.configRepo = (ConfigRepositoryIfc)Class.forName(cnf_class_name).newInstance();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Problem initializing configuration system: ", e);
                log.log(Level.SEVERE, "Please check settings, and rerun the server.");
                log.log(Level.SEVERE, "Server is stopping now.");
                System.err.println("Problem initializing configuration system: " + e);
                System.err.println("Please check settings, and rerun the server.");
                System.err.println("Server is stopping now.");
                System.exit(1);
            }
        }
        this.configRepo.addRepoChangeListener(this);
        String host = this.getDefHostName() != null ? this.getDefHostName().getDomain() : DNSResolverFactory.getInstance().getDefaultHost();
        this.configRepo.setDefHostname(host);
        try {
            this.configRepo.initRepository(null, this.initProperties);
        }
        catch (DBInitException ex) {
            throw new ConfigurationException(ex.getMessage(), ex);
        }
        for (String prop : this.initSettings) {
            ConfigItem item = (ConfigItem)this.configRepo.getItemInstance();
            item.initFromPropertyString(prop);
            this.configRepo.addItem(item);
        }
        Map<String, Object> repoInitProps = this.configRepo.getInitProperties();
        if (repoInitProps != null) {
            this.initProperties.putAll(repoInitProps);
        }
        if ((property_filenames = (String)this.initProperties.get(PROPERTY_FILENAME_PROP_KEY)) != null) {
            String[] prop_files = property_filenames.split(",");
            this.initMonitoring((String)this.initProperties.get("--monitoring"), new File(prop_files[0]).getParent());
        }
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("comp_repo", (Object)this.configRepo);
        binds.put(INIT_PROPERTIES_MAP_BIND, (Object)this.initProperties);
    }

    @Override
    public void initializationCompleted() {
        if (this.isInitializationComplete()) {
            return;
        }
        super.initializationCompleted();
        if (monitoring != null) {
            monitoring.initializationCompleted();
        }
        try {
            this.configRepo.store();
        }
        catch (TigaseDBException ex) {
            log.log(Level.WARNING, "Cannot store configuration.", ex);
        }
        System.out.println("== " + new Date() + " Server finished starting up and (if there wasn't any error) is ready to use\n");
    }

    @Override
    public void itemAdded(ConfigItem item) {
    }

    @Override
    public void itemRemoved(ConfigItem item) {
        log.log(Level.INFO, "Removing configuration item not supported yet: {0}", item);
    }

    @Override
    public void itemUpdated(ConfigItem item) {
        log.log(Level.INFO, "Updating configuration item: {0}", item);
        Configurable component = (Configurable)this.getComponent(item.getCompName());
        if (component != null) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put(item.getConfigKey(), item.getConfigVal());
            try {
                component.setProperties(prop);
            }
            catch (ConfigurationException ex) {
                log.log(Level.SEVERE, "Component reconfiguration failed: " + ex.getMessage(), ex);
            }
        } else {
            log.log(Level.WARNING, "Cannot find component for configuration item: {0}", item);
        }
    }

    public void parseArgs(String[] args) {
        ConfiguratorAbstract.parseArgs(this.initProperties, this.initSettings, args);
    }

    public void putProperties(String compId, Map<String, Object> props) throws ConfigurationException {
        this.configRepo.putProperties(compId, props);
    }

    public void setup(Configurable component) throws ConfigurationException {
        if (component == this) {
            if (this.setup_in_progress) {
                return;
            }
            this.setup_in_progress = true;
        }
        String compId = component.getName();
        log.log(Level.CONFIG, "Setting up component: {0}", compId);
        Map<String, Object> prop = null;
        try {
            prop = this.configRepo.getProperties(compId);
        }
        catch (ConfigurationException ex) {
            log.log(Level.WARNING, "Propblem retrieving configuration properties for component: " + compId, ex);
            return;
        }
        Map<String, Object> defs = component.getDefaults(this.getDefConfigParams());
        log.log(Level.CONFIG, "Component {0} defaults: {1}", new Object[]{compId, defs});
        Set<Map.Entry<String, Object>> defs_entries = defs.entrySet();
        boolean modified = false;
        for (Map.Entry<String, Object> entry : defs_entries) {
            if (prop.containsKey(entry.getKey())) continue;
            prop.put(entry.getKey(), entry.getValue());
            modified = true;
        }
        if (modified) {
            try {
                log.log(Level.CONFIG, "Component {0} configuration: {1}", new Object[]{compId, prop});
                this.configRepo.putProperties(compId, prop);
            }
            catch (ConfigurationException ex) {
                log.log(Level.WARNING, "Propblem with saving configuration properties for component: " + compId, ex);
            }
        }
        prop.put("shared-user-repo", this.user_repo_impl);
        prop.put("shared-user-repo-params", this.user_repo_params);
        prop.put("shared-auth-repo", this.auth_repo_impl);
        prop.put("shared-auth-repo-params", this.auth_repo_params);
        component.setProperties(prop);
        if (component == this) {
            this.setup_in_progress = false;
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        String[] packs;
        Map<String, Object> defaults = super.getDefaults(params);
        String levelStr = ".level";
        if (((Boolean)params.get("--test")).booleanValue()) {
            defaults.put(LOGGING_KEY + levelStr, "WARNING");
        } else {
            defaults.put(LOGGING_KEY + levelStr, "CONFIG");
        }
        defaults.put("logging/handlers", "java.util.logging.ConsoleHandler java.util.logging.FileHandler");
        defaults.put("logging/java.util.logging.ConsoleHandler.formatter", LogFormatter.class.getName());
        defaults.put("logging/java.util.logging.ConsoleHandler.level", "WARNING");
        defaults.put("logging/java.util.logging.FileHandler.append", "true");
        defaults.put("logging/java.util.logging.FileHandler.count", "5");
        defaults.put("logging/java.util.logging.FileHandler.formatter", LogFormatter.class.getName());
        defaults.put("logging/java.util.logging.FileHandler.limit", "10000000");
        defaults.put("logging/java.util.logging.FileHandler.pattern", "logs/tigase.log");
        defaults.put("logging/tigase.useParentHandlers", "true");
        defaults.put("logging/java.util.logging.FileHandler.level", "ALL");
        if (params.get("--debug") != null) {
            for (String pack : packs = ((String)params.get("--debug")).split(",")) {
                defaults.put("logging/tigase." + pack + ".level", "ALL");
            }
        }
        if (params.get("--debug-packages") != null) {
            for (String pack : packs = ((String)params.get("--debug-packages")).split(",")) {
                defaults.put(LOGGING_KEY + pack + ".level", "ALL");
            }
        }
        String repo_pool = null;
        repo_pool = (String)params.get("--user-domain-repo-pool");
        if (repo_pool == null) {
            repo_pool = USER_DOMAIN_POOL_CLASS_PROP_VAL;
        }
        defaults.put(USER_DOMAIN_POOL_CLASS_PROP_KEY, repo_pool);
        repo_pool = (String)params.get("--auth-domain-repo-pool");
        if (repo_pool == null) {
            repo_pool = AUTH_DOMAIN_POOL_CLASS_PROP_VAL;
        }
        defaults.put(AUTH_DOMAIN_POOL_CLASS_PROP_KEY, repo_pool);
        String user_repo_class = null;
        String user_repo_url = "jdbc:derby:tigase-derbydb;create=true";
        String auth_repo_class = null;
        String auth_repo_url = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db") != null) {
            user_repo_class = (String)params.get("--user-db");
            auth_repo_class = "tigase.db.jdbc.TigaseCustomAuth";
        }
        if (params.get("--user-db-uri") != null) {
            auth_repo_url = user_repo_url = (String)params.get("--user-db-uri");
        }
        if (params.get("--auth-db") != null) {
            auth_repo_class = (String)params.get("--auth-db");
        }
        if (params.get("--auth-db-uri") != null) {
            auth_repo_url = (String)params.get("--auth-db-uri");
        }
        if (params.get("--user-repo-pool-size") != null) {
            defaults.put("user-repo-pool-size", params.get("--user-repo-pool-size"));
        } else {
            defaults.put("user-repo-pool-size", RepositoryFactory.USER_REPO_POOL_SIZE_PROP_VAL);
        }
        if (params.get("--data-repo-pool-size") != null) {
            defaults.put("data-repo-pool-size", params.get("--data-repo-pool-size"));
        } else if (params.get("--user-repo-pool-size") != null) {
            defaults.put("data-repo-pool-size", params.get("--user-repo-pool-size"));
        } else {
            defaults.put("data-repo-pool-size", RepositoryFactory.DATA_REPO_POOL_SIZE_PROP_VAL);
        }
        if (params.get("--auth-repo-pool-size") != null) {
            defaults.put("auth-repo-pool-size", params.get("--auth-repo-pool-size"));
        } else if (params.get("--data-repo-pool-size") != null) {
            defaults.put("auth-repo-pool-size", params.get("--data-repo-pool-size"));
        } else if (params.get("--user-repo-pool-size") != null) {
            defaults.put("auth-repo-pool-size", params.get("--user-repo-pool-size"));
        } else {
            defaults.put("data-repo-pool-size", RepositoryFactory.AUTH_REPO_POOL_SIZE_PROP_VAL);
        }
        if (user_repo_class != null) {
            defaults.put("user-repo-class", user_repo_class);
        }
        defaults.put("user-repo-url", user_repo_url);
        if (auth_repo_class != null) {
            defaults.put("auth-repo-class", auth_repo_class);
        }
        defaults.put("auth-repo-url", auth_repo_url);
        ArrayList<String> user_repo_domains = new ArrayList<String>(10);
        ArrayList<String> auth_repo_domains = new ArrayList<String>(10);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String[] domains;
            if (entry.getKey().startsWith("--user-db-uri") && (domains = this.parseUserRepoParams(entry, params, user_repo_class, defaults)) != null) {
                user_repo_domains.addAll(Arrays.asList(domains));
            }
            if (!entry.getKey().startsWith("--auth-db-uri") || (domains = this.parseAuthRepoParams(entry, params, auth_repo_class, defaults)) == null) continue;
            auth_repo_domains.addAll(Arrays.asList(domains));
        }
        if (user_repo_domains.size() > 0) {
            defaults.put("user-repo-domains", user_repo_domains.toArray(new String[user_repo_domains.size()]));
        }
        if (auth_repo_domains.size() > 0) {
            defaults.put("auth-repo-domains", auth_repo_domains.toArray(new String[auth_repo_domains.size()]));
        }
        if (params.get("--ssl-container-class") != null) {
            defaults.put("ssl-container-class", (String)params.get("--ssl-container-class"));
        } else {
            defaults.put("ssl-container-class", SSLContextContainerIfc.SSL_CONTAINER_CLASS_VAL);
        }
        if (params.get("--ssl-certs-location") != null) {
            defaults.put("ssl-certs-location", (String)params.get("--ssl-certs-location"));
        } else {
            defaults.put("ssl-certs-location", "certs/");
        }
        if (params.get("--ssl-def-cert-domain") != null) {
            defaults.put("ssl-def-cert-domain", (String)params.get("--ssl-def-cert-domain"));
        } else {
            defaults.put("ssl-def-cert-domain", "default");
        }
        this.configRepo.getDefaults(defaults, params);
        return defaults;
    }

    public Map<String, Object> getDefConfigParams() {
        return this.initProperties;
    }

    public String getMessageRouterClassName() {
        return "tigase.server.MessageRouter";
    }

    public Map<String, Object> getProperties(String nodeId) throws ConfigurationException {
        return this.configRepo.getProperties(nodeId);
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof Configurable;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        if (props.size() == 0) {
            log.log(Level.WARNING, "Properties size is 0, incorrect system state, probably OSGI mode and configuration is not yet loaded.");
            return;
        }
        log.log(Level.INFO, "Propeties size is {0}, and here are all propeties: {1}", new Object[]{props.size(), props});
        this.setupLogManager(props);
        super.setProperties(props);
        if (props.size() == 1) {
            log.log(Level.INFO, "Propeties size is {0}, and here are all propeties: {1}", new Object[]{props.size(), props});
            return;
        }
        this.configRepo.setProperties(props);
        TLSUtil.configureSSLContext(props);
        String[] user_repo_domains = (String[])props.get("user-repo-domains");
        String[] auth_repo_domains = (String[])props.get("auth-repo-domains");
        String authRepoMDImpl = (String)props.get(AUTH_DOMAIN_POOL_CLASS_PROP_KEY);
        String userRepoMDImpl = (String)props.get(USER_DOMAIN_POOL_CLASS_PROP_KEY);
        try {
            Map<String, String> params = this.getRepoParams(props, "auth-repo-params", null);
            String conn_url = (String)props.get("auth-repo-url");
            this.auth_repo_impl = (AuthRepositoryMDImpl)Class.forName(authRepoMDImpl).newInstance();
            this.auth_repo_impl.initRepository(conn_url, params);
            params = this.getRepoParams(props, "user-repo-params", null);
            conn_url = (String)props.get("user-repo-url");
            this.user_repo_impl = (UserRepositoryMDImpl)Class.forName(userRepoMDImpl).newInstance();
            this.user_repo_impl.initRepository(conn_url, params);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error initializing domain repository pool: ", ex);
        }
        this.user_repository = null;
        this.auth_repository = null;
        if (user_repo_domains != null) {
            String[] ex = user_repo_domains;
            int n = ex.length;
            for (int i = 0; i < n; ++i) {
                String domain = ex[i];
                try {
                    this.addUserRepo(props, domain);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Can''t initialize user repository for domain: " + domain, e);
                }
            }
        }
        if (this.user_repository == null) {
            try {
                this.addUserRepo(props, null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can''t initialize user default repository: ", e);
            }
        }
        if (auth_repo_domains != null) {
            for (String domain : auth_repo_domains) {
                try {
                    this.addAuthRepo(props, domain);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Can''t initialize user repository for domain: " + domain, e);
                }
            }
        }
        if (this.auth_repository == null) {
            try {
                this.addAuthRepo(props, null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can''t initialize auth default repository: ", e);
            }
        }
    }

    private void addAuthRepo(Map<String, Object> props, String domain) throws DBInitException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Map<String, String> params = this.getRepoParams(props, "auth-repo-params", domain);
        String cls_name = (String)props.get("auth-repo-class" + (domain == null ? "" : "/" + domain));
        String conn_url = (String)props.get("auth-repo-url" + (domain == null ? "" : "/" + domain));
        AuthRepository repo = RepositoryFactory.getAuthRepository(cls_name, conn_url, params);
        if (domain == null || domain.trim().isEmpty()) {
            this.auth_repo_impl.addRepo("", repo);
            this.auth_repo_impl.setDefault(repo);
            this.auth_repository = repo;
        } else {
            this.auth_repo_impl.addRepo(domain, repo);
        }
        log.log(Level.INFO, "[{0}] Initialized {1} as user auth repository pool, url: {3}", new Object[]{domain != null ? domain : "DEFAULT", cls_name, conn_url});
    }

    private void addUserRepo(Map<String, Object> props, String domain) throws DBInitException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Map<String, String> params = this.getRepoParams(props, "user-repo-params", domain);
        String cls_name = (String)props.get("user-repo-class" + (domain == null ? "" : "/" + domain));
        String conn_url = (String)props.get("user-repo-url" + (domain == null ? "" : "/" + domain));
        UserRepository repo = RepositoryFactory.getUserRepository(cls_name, conn_url, params);
        if (domain == null || domain.trim().isEmpty()) {
            this.user_repo_impl.addRepo("", repo);
            this.user_repo_impl.setDefault(repo);
            this.user_repository = repo;
        } else {
            this.user_repo_impl.addRepo(domain, repo);
        }
        log.log(Level.INFO, "[{0}] Initialized {1} as user repository pool, url: {2}", new Object[]{domain != null ? domain : "DEFAULT", cls_name, conn_url});
    }

    private void initMonitoring(String settings, String configDir) {
        if (monitoring == null && settings != null) {
            try {
                String mon_cls = "tigase.management.MonitoringSetup";
                monitoring = (MonitoringSetupIfc)Class.forName(mon_cls).newInstance();
                monitoring.initMonitoring(settings, configDir);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can not initialize monitoring: ", e);
            }
        }
    }

    private String[] parseAuthRepoParams(Map.Entry<String, Object> entry, Map<String, Object> params, String auth_repo_class, Map<String, Object> defaults) {
        String key = entry.getKey();
        int br_open = key.indexOf(91);
        int br_close = key.indexOf(93);
        if (br_open < 0 || br_close < 0) {
            return null;
        }
        String repo_class = auth_repo_class;
        String options = key.substring(br_open + 1, br_close);
        Object[] domains = options.split(",");
        log.log(Level.INFO, "Found DB domain: {0}", Arrays.toString(domains));
        String get_user_db = "--auth-db[" + options + "]";
        if (params.get(get_user_db) != null) {
            repo_class = (String)params.get(get_user_db);
        }
        for (Object domain : domains) {
            defaults.put("auth-repo-class/" + (String)domain, repo_class);
            log.log(Level.CONFIG, "Setting defaults: {0}/{1}={2}", new Object[]{"auth-repo-class", domain, repo_class});
            defaults.put("auth-repo-url/" + (String)domain, entry.getValue());
            log.log(Level.CONFIG, "Setting defaults: {0}{1}={2}", new Object[]{"auth-repo-url", domain, entry.getValue()});
        }
        return domains;
    }

    private String[] parseUserRepoParams(Map.Entry<String, Object> entry, Map<String, Object> params, String user_repo_class, Map<String, Object> defaults) {
        String key = entry.getKey();
        int br_open = key.indexOf(91);
        int br_close = key.indexOf(93);
        if (br_open < 0 || br_close < 0) {
            return null;
        }
        String repo_class = user_repo_class;
        String options = key.substring(br_open + 1, br_close);
        Object[] domains = options.split(",");
        log.log(Level.INFO, "Found DB domain: {0}", Arrays.toString(domains));
        String get_user_db = "--user-db[" + options + "]";
        if (params.get(get_user_db) != null) {
            repo_class = (String)params.get(get_user_db);
        }
        for (Object domain : domains) {
            defaults.put("user-repo-class/" + (String)domain, repo_class);
            log.log(Level.CONFIG, "Setting defaults: {0}{1}={2}", new Object[]{"user-repo-class", domain, repo_class});
            defaults.put("user-repo-url/" + (String)domain, entry.getValue());
            log.log(Level.CONFIG, "Setting defaults: {0}{1}={2}", new Object[]{"user-repo-url", domain, entry.getValue()});
        }
        return domains;
    }

    private void setupLogManager(Map<String, Object> properties) {
        Set<Map.Entry<String, Object>> entries = properties.entrySet();
        StringBuilder buff = new StringBuilder(200);
        for (Map.Entry<String, Object> entry : entries) {
            if (!entry.getKey().startsWith(LOGGING_KEY)) continue;
            String key = entry.getKey().substring(LOGGING_KEY.length());
            this.loggingSetup.put(key, entry.getValue().toString());
        }
        for (String key : this.loggingSetup.keySet()) {
            File log_path;
            String entry = this.loggingSetup.get(key);
            buff.append(key).append("=").append(entry).append("\n");
            if (!key.equals("java.util.logging.FileHandler.pattern") || (log_path = new File(entry).getParentFile()).exists()) continue;
            log_path.mkdirs();
        }
        ConfiguratorAbstract.loadLogManagerConfig(buff.toString());
        log.config("DONE");
    }

    private Map<String, String> getRepoParams(Map<String, Object> props, String repo_type, String domain) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(10);
        String prop_start = repo_type + (domain == null ? "" : "/" + domain);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith(prop_start)) continue;
            String[] nodes = entry.getKey().split("/");
            if ((domain != null || nodes.length != 2) && (domain == null || nodes.length != 3)) continue;
            result.put(nodes[nodes.length - 1], entry.getValue().toString());
        }
        return result;
    }
}

