/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy.cmd;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.DefaultClusteringStrategyAbstract;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.JID;

public class PacketForwardCmd
extends CommandListenerAbstract {
    public static final String PACKET_FROM_KEY = "packet-from";
    private static final Logger log = Logger.getLogger(PacketForwardCmd.class.getName());
    private DefaultClusteringStrategyAbstract strategy;

    public PacketForwardCmd(String name, DefaultClusteringStrategyAbstract strategy) {
        super(name, Priority.HIGH);
        this.strategy = strategy;
    }

    @Override
    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
        }
        if (packets != null && packets.size() > 0) {
            SessionManagerClusteredIfc sm = this.getSM();
            for (Element elem : packets) {
                try {
                    Packet el_packet = Packet.packetInstance(elem);
                    String packetFromStr = data.get(PACKET_FROM_KEY);
                    if (packetFromStr != null) {
                        el_packet.setPacketFrom(JID.jidInstanceNS((String)packetFromStr));
                    }
                    XMPPResourceConnection conn = sm.getXMPPResourceConnection(el_packet);
                    LinkedHashMap<String, String> locdata = null;
                    if (conn != null) {
                        locdata = new LinkedHashMap<String, String>();
                        if (data != null) {
                            locdata.putAll(data);
                        }
                        data.put("user-session-found-key", sm.getComponentId().toString());
                    }
                    boolean isSent = this.strategy.sendToNextNode(fromNode, visitedNodes, data, Packet.packetInstance(elem));
                    if (conn != null) {
                        if (sm.getComponentId().equals((Object)fromNode)) continue;
                        sm.processPacket(el_packet, conn);
                        continue;
                    }
                    if (!sm.getComponentId().equals((Object)fromNode) || data != null && data.get("user-session-found-key") != null) continue;
                    sm.processPacket(el_packet, conn);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Addressing problem, stringprep failed for packet: " + elem);
                }
            }
        } else {
            log.finest("Empty packets list in the forward command");
        }
    }

    private SessionManagerClusteredIfc getSM() {
        return this.strategy.getSM();
    }
}

