/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.jid;

import tigase.util.stringprep.TigaseStringprepException;
import tigase.util.stringprep.XMPPStringPrepFactory;
import tigase.util.stringprep.XMPPStringPrepIfc;

public final class BareJID
implements Comparable<BareJID> {
    static XMPPStringPrepIfc stringPrep = XMPPStringPrepFactory.getDefaultXMPPStringPrep();
    private final String domain;
    private final int hashcode;
    private final String localpart;
    private final String to_string;

    public static BareJID bareJIDInstance(String jid) throws TigaseStringprepException {
        String[] parsedJid = BareJID.parseJID(jid);
        return BareJID.bareJIDInstance(parsedJid[0], parsedJid[1]);
    }

    public static BareJID bareJIDInstance(String p_localpart, String p_domain) throws TigaseStringprepException {
        String f_localpart;
        String string = f_localpart = p_localpart == null ? null : stringPrep.nodeprep(p_localpart);
        if (p_domain == null || p_domain.trim().isEmpty()) {
            throw new TigaseStringprepException("Domain part is required");
        }
        String f_domain = stringPrep.nameprep(p_domain);
        return new BareJID(f_localpart, f_domain);
    }

    public static BareJID bareJIDInstanceNS(String jid) {
        String[] parsedJid = BareJID.parseJID(jid);
        return BareJID.bareJIDInstanceNS(parsedJid[0], parsedJid[1]);
    }

    public static BareJID bareJIDInstanceNS(String p_localpart, String p_domain) {
        return p_domain == null || p_domain.trim().isEmpty() ? null : new BareJID(p_localpart, p_domain);
    }

    public static String jidToBareJID(String jid) {
        String[] parsed = BareJID.parseJID(jid);
        return BareJID.toString(parsed[0], parsed[1]);
    }

    public static String[] parseJID(String jid) {
        String[] result = new String[3];
        int idx = jid.indexOf(47);
        result[2] = idx == -1 ? null : jid.substring(idx + 1);
        String id = idx == -1 ? jid : jid.substring(0, idx);
        idx = id.indexOf(64);
        result[0] = idx == -1 ? null : id.substring(0, idx);
        result[1] = idx == -1 ? id : id.substring(idx + 1);
        return result;
    }

    public static String toString(String p_localpart, String p_domain) {
        return p_localpart != null && p_localpart.length() > 0 ? p_localpart + "@" + p_domain : p_domain;
    }

    public static String toString(String p_localpart, String p_domain, String p_resource) {
        return BareJID.toString(p_localpart, p_domain) + (p_resource != null && p_resource.length() > 0 ? "/" + p_resource : "");
    }

    public static String toString(BareJID bareJid, String p_resource) {
        return bareJid.toString() + (p_resource != null && p_resource.length() > 0 ? "/" + p_resource : "");
    }

    public static void useStringprepProcessor(String stringprepProcessor) {
        stringPrep = XMPPStringPrepFactory.getXMPPStringPrep(stringprepProcessor);
    }

    private BareJID(String localpart, String domain) {
        this.localpart = localpart;
        this.domain = domain.toLowerCase().intern();
        this.to_string = BareJID.toString(this.localpart, this.domain);
        this.hashcode = this.to_string.toLowerCase().hashCode();
    }

    @Override
    public int compareTo(BareJID o) {
        return this.to_string.compareToIgnoreCase(o.to_string);
    }

    public boolean equals(Object b) {
        boolean result = false;
        if (b instanceof BareJID) {
            result = (this.domain == ((BareJID)b).domain || this.domain.equalsIgnoreCase(((BareJID)b).domain)) && (this.localpart == null ? this.localpart == ((BareJID)b).localpart : this.localpart.equalsIgnoreCase(((BareJID)b).localpart));
        }
        return result;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getLocalpart() {
        return this.localpart;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.to_string;
    }
}

