/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

class StatisticsAnalyser {
    private static final Logger log = Logger.getLogger(StatisticsAnalyser.class.getName());

    StatisticsAnalyser() {
    }

    public static void main(String[] args) {
        File[] files;
        if (args.length < 1 || args.length > 2) {
            System.out.println("Wrong parameter list (either 1 or 2 supported (path + filter)");
        }
        System.out.println("Using path: " + args[0]);
        Path directoryPath = Paths.get(args[0], new String[0]);
        File directory = directoryPath.toFile();
        if (args.length == 2) {
            System.out.println("Filtering files with prefix: " + args[1]);
            files = directory.listFiles((dir, name) -> name.startsWith(args[1]));
        } else {
            files = directory.listFiles();
        }
        TreeMap<String, Map> stats = new TreeMap<String, Map>();
        System.out.println("Files: " + files.length);
        for (File file : files) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(file.toPath(), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                System.out.println("File: " + file.toPath());
                e.printStackTrace();
            }
            for (String line : lines) {
                if (line.contains("Statistics time")) continue;
                Object[] keyval = line.split("(\\t+|\\s{2,})");
                if (keyval.length != 2) {
                    System.out.println(line + " : " + Arrays.toString(keyval));
                }
                Map vals = stats.computeIfAbsent(keyval[0], k -> new TreeMap());
                try {
                    vals.put(file.getName(), keyval[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(line);
                    System.out.println(Arrays.toString(keyval));
                }
            }
        }
        System.out.println("Statistics count: " + stats.size());
        File outputFile = new File(directoryPath + "/statisticsSeries.txt");
        System.out.println("Writing to: " + outputFile.getAbsolutePath());
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(outputFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (Map.Entry stringMapEntry : stats.entrySet()) {
            Long count = ((Map)stringMapEntry.getValue()).values().stream().distinct().count();
            if (count <= 1L) continue;
            if (pw != null) {
                pw.println();
            } else {
                System.out.println();
            }
            Long previousValue = null;
            for (Map.Entry stringStringEntry : ((Map)stringMapEntry.getValue()).entrySet()) {
                Long diff = null;
                try {
                    Long aLong = Long.valueOf((String)stringStringEntry.getValue());
                    if (previousValue != null) {
                        diff = aLong - previousValue;
                    }
                    previousValue = aLong;
                }
                catch (Exception aLong) {
                    // empty catch block
                }
                String x = (String)stringMapEntry.getKey() + " | " + (String)stringStringEntry.getKey() + " ~ " + (String)stringStringEntry.getValue() + (diff != null ? " / " + diff : "");
                if (pw != null) {
                    pw.println(x);
                    continue;
                }
                System.out.println(x);
            }
        }
    }
}

