/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup;

import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.ServiceImpl;
import tigase.http.ServletInfo;
import tigase.http.modules.AbstractBareModule;
import tigase.http.modules.setup.SetupModeRedirectServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Bean(name="setupRedirect", parent=HttpMessageReceiver.class, active=true)
@ConfigType(value={ConfigTypeEnum.SetupMode})
public class SetupModeRedirectModule
extends AbstractBareModule {
    private DeploymentInfo httpDeployment;
    private ServiceImpl service;

    public SetupModeRedirectModule() {
        this.contextPath = "/";
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.contextPath = "/";
    }

    @Override
    public String getDescription() {
        return "Setup mode redirection module";
    }

    @Override
    public boolean isRequestAllowed(String key, String domain, String path) {
        return true;
    }

    @Override
    public UserRepository getUserRepository() {
        return null;
    }

    @Override
    public AuthRepository getAuthRepository() {
        return null;
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        this.service = new ServiceImpl(this){

            @Override
            public boolean isAdmin(BareJID user) {
                return true;
            }

            @Override
            public boolean checkCredentials(String user, String password) throws TigaseStringprepException, TigaseDBException, AuthorizationException {
                return true;
            }
        };
        super.start();
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setService(this.service).setDeploymentName("Setup").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = this.httpServer.servlet("SetupModeRedirectServlet", SetupModeRedirectServlet.class).addInitParam("module", this.uuid);
        servletInfo.addMapping("/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        super.stop();
    }
}

