/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.modules.NodeConfigModule;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="default-config-adhoc", parent=PubSubComponent.class, active=true)
public class DefaultConfigCommand
implements AdHocCommand {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private PubSubConfig config;
    @Inject
    private EventBus eventbus;
    @Inject
    private UserRepository userRepository;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                LeafNodeConfig defaultNodeConfig = new LeafNodeConfig("default");
                defaultNodeConfig.read(this.userRepository, this.config, "default-node-config");
                response.getElements().add(defaultNodeConfig.getFormElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    LeafNodeConfig nodeConfig = new LeafNodeConfig("default");
                    nodeConfig.read(this.userRepository, this.config, "default-node-config");
                    NodeConfigModule.parseConf(nodeConfig, request.getCommand(), this.config);
                    nodeConfig.write(this.userRepository, this.config, "default-node-config");
                    this.eventbus.fire((Object)new DefaultNodeConfigurationChangedEvent());
                    Form f = new Form("result", "Info", "Default config saved.");
                    response.getElements().add(f.getElement());
                    response.completeSession();
                }
                response.completeSession();
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINE, "Error executing command", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getName() {
        return "Default config";
    }

    public String getNode() {
        return "default-config";
    }

    public boolean isAllowedFor(JID jid) {
        return Arrays.asList(this.config.getAdmins()).contains(jid.toString());
    }

    public static class DefaultNodeConfigurationChangedEvent {
    }
}

