/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.mam.Query;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="retrieveItemsModule", parent=PubSubComponent.class, active=true)
public class RetrieveItemsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"items"));
    private final TimestampHelper timestampHelper = new TimestampHelper();

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-items"};
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws PubSubException {
        try {
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element pubsub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element items = pubsub.getChild("items");
            String nodeName = items.getAttributeStaticStr("node");
            JID senderJid = packet.getStanzaFrom();
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
            }
            this.logic.checkAccessPermission(toJid, nodeName, senderJid);
            Element rpubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            List<String> requestedId = this.extractItemsIds(items);
            if (requestedId != null) {
                Element ritems = new Element("items", new String[]{"node"}, new String[]{nodeName});
                IItems nodeItems = this.getRepository().getNodeItems(toJid, nodeName);
                for (String id : requestedId) {
                    Element payload = nodeItems.getItem(id);
                    if (payload == null) continue;
                    ritems.addChild((XMLNodeIfc)payload);
                }
                rpubsub.addChild((XMLNodeIfc)ritems);
            } else {
                Query query = (Query)this.getRepository().newQuery();
                query.setComponentJID(packet.getStanzaTo());
                query.setQuestionerJID(senderJid);
                query.setPubsubNode(nodeName);
                Integer maxItems = this.asInteger(items.getAttributeStaticStr("max_items"));
                Element rsmGet = pubsub.getChild("set", "http://jabber.org/protocol/rsm");
                if (rsmGet != null) {
                    query.getRsm().fromElement(rsmGet);
                    Element m = rsmGet.getChild("dt_after", "http://tigase.org/pubsub");
                    if (m != null) {
                        query.setStart(this.timestampHelper.parseTimestamp(m.getCData()));
                    }
                    if ((m = rsmGet.getChild("dt_before", "http://tigase.org/pubsub")) != null) {
                        query.setEnd(this.timestampHelper.parseTimestamp(m.getCData()));
                    }
                } else if (maxItems != null) {
                    query.getRsm().setHasBefore(true);
                    query.getRsm().setMax(maxItems.intValue());
                }
                ArrayList queryResults = new ArrayList();
                this.getRepository().queryItems((tigase.xmpp.mam.Query)query, (query1, item) -> {
                    queryResults.add(item);
                    if (query.getRsm().getFirst() == null) {
                        query.getRsm().setFirst(item.getId());
                    }
                    query.getRsm().setLast(item.getId());
                });
                queryResults.stream().collect(Collectors.groupingBy(item -> item.getNode())).forEach((rnodeName, rnodeItems) -> {
                    Element ritems = new Element("items", new String[]{"node"}, new String[]{rnodeName});
                    for (IPubSubRepository.Item ritem : rnodeItems) {
                        ritems.addChild((XMLNodeIfc)ritem.getMessage());
                    }
                    rpubsub.addChild((XMLNodeIfc)ritems);
                });
                if (query.getRsm().getCount() > 0) {
                    if (maxItems == null) {
                        rpubsub.addChild((XMLNodeIfc)query.getRsm().toElement());
                    }
                } else {
                    rpubsub.addChild((XMLNodeIfc)new Element("items", new String[]{"node"}, new String[]{nodeName}));
                }
            }
            Packet iq = packet.okResult(rpubsub, 0);
            iq.setXMLNS("jabber:client");
            this.packetWriter.write(iq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing retrieve items packet", e);
            throw new RuntimeException(e);
        }
    }

    private Integer asInteger(String attribute) {
        if (attribute == null) {
            return null;
        }
        return Integer.parseInt(attribute);
    }

    private List<String> extractItemsIds(Element items) throws PubSubException {
        List il = items.getChildren();
        if (il == null || il.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Element i : il) {
            String id = i.getAttributeStaticStr("id");
            if (!"item".equals(i.getName()) || id == null) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            result.add(id);
        }
        return result;
    }
}

