/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.logging.Logger;
import tigase.xmpp.jid.BareJID;

public class Utils {
    protected static Logger log = Logger.getLogger(Utils.class.getName());
    private static Utils instance;
    private final Spi spi;

    public static String asString(String ... array) {
        StringBuilder sb = new StringBuilder();
        if (array != null) {
            sb.append("[");
            for (String string : array) {
                sb.append("'");
                sb.append(string);
                sb.append("', ");
            }
            sb.append("]");
        } else {
            sb.append("[null]");
        }
        return sb.toString();
    }

    public static boolean contain(String string, String ... array) {
        for (String s : array) {
            if ((s != null || string != null) && (s == null || string == null || !string.equals(s))) continue;
            return true;
        }
        return false;
    }

    public static String createUID() {
        return Utils.createUID(null);
    }

    public static String createUID(Object jid) {
        byte[] x = new byte[13];
        Utils utils = Utils.instance();
        utils.spi.engineNextBytes(x, 1);
        if (jid != null) {
            utils.spi.updateSeed(jid.hashCode());
        }
        return new BigInteger(x).toString(36);
    }

    private static Utils instance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public static boolean isAllowedDomain(BareJID bareJID, String ... domains) {
        log.finer("Checking is " + bareJID + " allowed to see domains: " + Utils.asString(domains));
        if (bareJID == null || domains == null || domains.length == 0) {
            return true;
        }
        String jidHost = bareJID.getDomain();
        for (String d : domains) {
            if (!jidHost.equals(d)) continue;
            return true;
        }
        return false;
    }

    public static String longToTime(long time) {
        long hours = time / 3600000L;
        long mins = (time - hours * 3600000L) / 60000L;
        long secs = (time - (hours * 3600000L + mins * 60000L)) / 1000L;
        long millis = time - (hours * 3600000L + mins * 60000L + secs * 1000L);
        return "" + (hours > 0L ? hours + "h, " : "") + (mins > 0L ? mins + "m, " : "") + (secs > 0L ? secs + "sec, " : "") + (millis > 0L ? millis + "ms" : "");
    }

    public static String removeMySQLNonUtf8mb3Codepoints(String resource) {
        StringBuilder sb = new StringBuilder();
        resource.codePoints().forEach(codepoint -> {
            if (Character.isBmpCodePoint(codepoint)) {
                char[] chars;
                for (char c : chars = Character.toChars(codepoint)) {
                    sb.append(c);
                }
            } else {
                sb.append("_");
            }
        });
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(Utils.createUID("null"));
    }

    public Utils() {
        Random random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            random = new Random();
        }
        this.spi = new Spi(random);
    }

    public static class Spi {
        private static final long serialVersionUID = 6772408791281461866L;
        private final Random random;
        private byte[] P = new byte[]{118, -82, 96, -6, -105, 7, 18, 45, 114, -26, -62, -79, 15, -32, -61, 62, -60, 48, -65, -56, 102, -23, 121, -29, -52, 53, -75, 84, 104, -48, 76, -101, -1, 20, 33, 50, 120, 8, -67, 99, 19, 71, -43, 42, -45, -54, -36, 109, 56, -39, -7, 52, 14, 115, -126, 70, 4, 98, -94, -24, -55, 79, -78, -77, -74, -103, 43, 124, 55, -106, 127, -116, 34, 95, 119, -9, -27, 23, -19, -31, 107, -118, -10, -128, -47, 125, -71, 54, 5, -33, 108, 58, 81, -22, 87, -108, -120, 6, -84, -59, 44, 17, -70, -51, -102, 47, 32, -69, -97, -17, -114, 113, 110, 27, -124, -80, -49, 40, -14, -85, -42, 22, 69, -89, -125, 1, 2, 46, 59, 117, -98, -96, -87, -95, 126, -53, 116, -127, -111, 11, -122, 68, 66, 63, 21, 36, 49, 105, -3, -50, 122, -30, 28, -76, -117, 31, 106, 101, 123, -28, -12, -11, -34, 24, -5, -35, -16, 67, 9, 83, -44, -110, -113, -99, -100, 89, 0, 61, -93, 65, -37, 85, -107, 64, -57, 73, -4, 10, -92, 16, 100, 111, 75, -38, -21, -18, -72, -88, -20, -66, 94, -64, -63, 78, 51, 82, 88, 13, -104, -112, -68, 37, -2, 72, 93, -40, 35, 3, 60, 57, -121, -8, -109, -25, -46, 91, -13, 41, 97, -41, 30, 39, -123, -119, 80, 103, -73, 86, -81, 77, 12, -90, 29, 74, 112, -83, -91, -115, -15, 25, 26, -86, -58, 92, 38, 90};
        private int counter;
        private byte n = 0;
        private byte s = (byte)-34;

        public Spi(Random random) {
            this.random = random;
            byte[] seed = new byte[1536];
            random.nextBytes(seed);
            this.engineSetSeed(seed);
        }

        public void engineNextBytes(byte[] bytes) {
            this.engineNextBytes(bytes, 0);
        }

        public void engineNextBytes(byte[] bytes, int offset) {
            for (int i = offset; i != bytes.length; ++i) {
                this.s = this.P[this.s + this.P[this.n & 0xFF] & 0xFF];
                bytes[i] = this.P[this.P[this.P[this.s & 0xFF] & 0xFF] + 1 & 0xFF];
                byte temp = this.P[this.n & 0xFF];
                this.P[this.n & 0xFF] = this.P[this.s & 0xFF];
                this.P[this.s & 0xFF] = temp;
                this.n = (byte)(this.n + 1 & 0xFF);
                ++this.counter;
            }
            if (this.counter > 16401001) {
                this.counter = 0;
                byte[] s1 = new byte[768];
                this.random.nextBytes(s1);
                this.engineSetSeed(s1);
            }
        }

        public void engineSetSeed(byte[] seed) {
            if (seed != null && this.P != null) {
                for (int m = 0; m < seed.length; ++m) {
                    this.s = this.P[this.s + this.P[this.n & 0xFF] + seed[m] & 0xFF];
                    byte temp = this.P[this.n & 0xFF];
                    this.P[this.n & 0xFF] = this.P[this.s & 0xFF];
                    this.P[this.s & 0xFF] = temp;
                    this.n = (byte)(this.n + 1 & 0xFF);
                }
            }
        }

        public void updateSeed(int hashCode) {
            this.s = this.P[this.s + this.P[this.n & 0xFF] + hashCode & 0xFF];
            byte temp = this.P[this.n & 0xFF];
            this.P[this.n & 0xFF] = this.P[this.s & 0xFF];
            this.P[this.s & 0xFF] = temp;
            this.n = (byte)(this.n + 1 & 0xFF);
        }

        protected byte[] engineGenerateSeed(int numBytes) {
            byte[] result = new byte[numBytes];
            this.engineNextBytes(result);
            return result;
        }
    }
}

