/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.AbstractHistoryProvider;
import tigase.muc.history.HistoryProvider;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.QueryImpl;

@Repository.Meta(supportedUris={"jdbc:.*"})
@Repository.SchemaId(id="muc", name="Tigase MUC Component")
public class JDBCHistoryProvider
extends AbstractHistoryProvider<DataRepository>
implements HistoryProvider<DataRepository>,
MAMRepository,
RepositoryVersionAware {
    private static final Logger log = Logger.getLogger(JDBCHistoryProvider.class.getCanonicalName());
    protected DataRepository data_repo;
    @ConfigField(desc="Query to append message to history", alias="add-message-query")
    private String addMessageQuery = "{ call Tig_MUC_AddMessage(?,?,?,?,?,?,?) }";
    @ConfigField(desc="Delete messages from history", alias="delete-messages-query")
    private String deleteMessagesQuery = "{ call Tig_MUC_DeleteMessages(?) }";
    @ConfigField(desc="Retrieve messages from history", alias="get-messages-query")
    private String getMessagesQuery = "{ call Tig_MUC_GetMessages(?,?,?) }";
    @ConfigField(desc="Retrieve position of message in archive", alias="mam-get-message-position-query")
    private String mamGetMessagePositionQuery = "{ call Tig_MUC_MAM_GetMessagePosition(?,?,?,?,?) }";
    @ConfigField(desc="Retrieve messages from archive", alias="mam-get-messages-count-query")
    private String mamGetMessagesCountQuery = "{ call Tig_MUC_MAM_GetMessagesCount(?,?,?,?) }";
    @ConfigField(desc="Retrieve messages from archive", alias="mam-get-messages-query")
    private String mamGetMessagesQuery = "{ call Tig_MUC_MAM_GetMessages(?,?,?,?,?,?) }";

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        PreparedStatement st = null;
        try {
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(senderJid.getBareJID(), this.addMessageQuery);
            synchronized (preparedStatement) {
                st.setString(1, room.getRoomJID().toString());
                this.data_repo.setTimestamp(st, 2, new Timestamp(time.getTime()));
                st.setString(3, senderJid.toString());
                st.setString(4, senderNickname);
                st.setString(5, body);
                st.setBoolean(6, room.getConfig().isLoggingEnabled());
                st.setString(7, message == null ? null : message.toString());
                st.executeUpdate();
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1366 || e.getMessage() != null && e.getMessage().startsWith("Incorrect string value")) {
                log.log(Level.WARNING, "Your MySQL configuration can't handle extended Unicode (for example emoji) correctly. Please refer to <Support for emoji and other icons> section of the server documentation");
            } else {
                log.log(Level.WARNING, "Can't add MUC message to database", e);
            }
            throw new RuntimeException(e);
        }
        finally {
            this.data_repo.release(null, null);
        }
    }

    @Override
    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, PacketWriter writer) {
        String roomJID = room.getRoomJID().toString();
        int maxMessages = room.getConfig().getMaxHistory();
        try {
            if (maxchars != null && maxchars == 0) {
                return;
            }
            if (since != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Using SINCE selector: roomJID=" + roomJID + ", since=" + since.getTime() + " (" + since + ")");
                }
                this.getMessagesSince(room, senderJID, maxMessages, since.getTime() == 0L ? null : new Timestamp(since.getTime()), writer);
            } else if (maxstanzas != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Using MAXSTANZAS selector: roomJID=" + roomJID + ", maxstanzas=" + maxstanzas);
                }
                this.getMessagesSince(room, senderJID, Math.min(maxstanzas, maxMessages), null, writer);
            } else if (seconds != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Using SECONDS selector: roomJID=" + roomJID + ", seconds=" + seconds);
                }
                this.getMessagesSince(room, senderJID, maxMessages, new Timestamp(System.currentTimeMillis() - (long)(seconds * 1000)), writer);
            } else {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Using DEFAULT selector: roomJID=" + roomJID);
                }
                this.getMessagesSince(room, senderJID, maxMessages, null, writer);
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Can't get history", e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isPersistent(Room room) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHistory(Room room) {
        PreparedStatement st = null;
        try {
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(null, this.deleteMessagesQuery);
            synchronized (preparedStatement) {
                st.setString(1, room.getRoomJID().toString());
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Removing history of room " + room.getRoomJID() + " from database.");
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Executing " + st.toString());
                }
                st.executeUpdate();
            }
        }
        catch (SQLException e) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Can't delete MUC messages from database", e);
            }
            throw new RuntimeException(e);
        }
        finally {
            this.data_repo.release(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryItems(Query query, MAMRepository.ItemHandler itemHandler) throws TigaseDBException, ComponentException {
        try {
            PreparedStatement st;
            Integer count = this.countItems(query);
            if (count == null) {
                count = 0;
            }
            Integer after = this.getItemPosition(query.getRsm().getAfter(), query);
            Integer before = this.getItemPosition(query.getRsm().getBefore(), query);
            AbstractHistoryProvider.calculateOffsetAndPosition(query, count, before, after);
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(query.getQuestionerJID().getBareJID(), this.mamGetMessagesQuery);
            synchronized (preparedStatement) {
                ResultSet rs = null;
                try {
                    int i = this.setStatementParamsForMAM(st, query);
                    st.setInt(i++, query.getRsm().getMax());
                    st.setInt(i++, query.getRsm().getIndex());
                    rs = st.executeQuery();
                    while (rs.next()) {
                        String msgSenderNickname = rs.getString("sender_nickname");
                        final Timestamp msgTimestamp = this.data_repo.getTimestamp(rs, "ts");
                        String msgSenderJid = rs.getString("sender_jid");
                        String body = rs.getString("body");
                        String msg = rs.getString("msg");
                        final Element msgEl = this.createMessageElement(query.getComponentJID().getBareJID(), query.getQuestionerJID(), msgSenderNickname, msg, body);
                        MAMRepository.Item item = new MAMRepository.Item(){

                            public String getId() {
                                return String.valueOf(msgTimestamp.getTime());
                            }

                            public Element getMessage() {
                                return msgEl;
                            }

                            public Date getTimestamp() {
                                return msgTimestamp;
                            }
                        };
                        itemHandler.itemFound(query, item);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
        }
        catch (SQLException | TigaseStringprepException ex) {
            throw new TigaseDBException("Cound not retrieve items", ex);
        }
    }

    public Query newQuery() {
        return new QueryImpl();
    }

    public void setDataSource(DataRepository dataSource) {
        try {
            this.initPreparedStatements(dataSource);
        }
        catch (SQLException ex) {
            new RuntimeException("Failed to initialize access to SQL database for PubSubDAOJDBC", ex);
        }
        this.data_repo = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMessagesSince(Room room, JID senderJID, int maxMessages, Timestamp since, PacketWriter writer) throws SQLException, TigaseStringprepException {
        PreparedStatement st;
        PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(senderJID.getBareJID(), this.getMessagesQuery);
        synchronized (preparedStatement) {
            ResultSet rs = null;
            try {
                st.setString(1, room.getRoomJID().toString());
                st.setInt(2, maxMessages);
                this.data_repo.setTimestamp(st, 3, since);
                rs = st.executeQuery();
                this.processResultSet(room, senderJID, writer, rs);
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
            this.data_repo.release(null, rs);
        }
    }

    protected void processResultSet(Room room, JID senderJID, PacketWriter writer, ResultSet rs) throws SQLException, TigaseStringprepException {
        boolean addRealJids;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Select messages for " + senderJID + " from room " + room.getRoomJID());
        }
        Affiliation recipientAffiliation = room.getAffiliation(senderJID.getBareJID()).getAffiliation();
        boolean bl = addRealJids = room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous || room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.semianonymous && (recipientAffiliation == Affiliation.owner || recipientAffiliation == Affiliation.admin);
        while (rs.next()) {
            String msgSenderNickname = rs.getString("sender_nickname");
            Timestamp msgTimestamp = this.data_repo.getTimestamp(rs, "ts");
            String msgSenderJid = rs.getString("sender_jid");
            String body = rs.getString("body");
            String msg = rs.getString("msg");
            Packet m = this.createMessage(room.getRoomJID(), senderJID, msgSenderNickname, msg, body, msgSenderJid, addRealJids, msgTimestamp);
            writer.write(m);
        }
    }

    protected void initPreparedStatements(DataRepository repo) throws SQLException {
        repo.initPreparedStatement(this.addMessageQuery, this.addMessageQuery);
        repo.initPreparedStatement(this.deleteMessagesQuery, this.deleteMessagesQuery);
        repo.initPreparedStatement(this.getMessagesQuery, this.getMessagesQuery);
        repo.initPreparedStatement(this.mamGetMessagesQuery, this.mamGetMessagesQuery);
        repo.initPreparedStatement(this.mamGetMessagesCountQuery, this.mamGetMessagesCountQuery);
        repo.initPreparedStatement(this.mamGetMessagePositionQuery, this.mamGetMessagePositionQuery);
    }

    private int setStatementParamsForMAM(PreparedStatement st, Query query) throws SQLException {
        int i = 1;
        st.setString(i++, query.getComponentJID().getBareJID().toString());
        if (query.getStart() != null) {
            this.data_repo.setTimestamp(st, i++, new Timestamp(query.getStart().getTime()));
        } else {
            st.setObject(i++, null);
        }
        if (query.getEnd() != null) {
            this.data_repo.setTimestamp(st, i++, new Timestamp(query.getEnd().getTime()));
        } else {
            st.setObject(i++, null);
        }
        if (query.getWith() != null) {
            st.setString(i++, query.getWith().toString());
        } else {
            st.setObject(i++, null);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer countItems(Query query) throws TigaseDBException {
        try {
            PreparedStatement st;
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(query.getQuestionerJID().getBareJID(), this.mamGetMessagesCountQuery);
            synchronized (preparedStatement) {
                ResultSet rs;
                block7: {
                    Integer n;
                    rs = null;
                    try {
                        this.setStatementParamsForMAM(st, query);
                        rs = st.executeQuery();
                        if (!rs.next()) break block7;
                        n = rs.getInt(1);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                    return n;
                }
                Integer n = null;
                this.data_repo.release(null, rs);
                return n;
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Failed to retrieve number of messages for room " + query.getComponentJID(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer getItemPosition(String msgId, Query query) throws TigaseDBException, ComponentException {
        if (msgId == null) {
            return null;
        }
        try {
            PreparedStatement st;
            Timestamp ts = new Timestamp(Long.parseLong(msgId));
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(query.getQuestionerJID().getBareJID(), this.mamGetMessagePositionQuery);
            synchronized (preparedStatement) {
                ResultSet rs;
                block9: {
                    Integer n;
                    rs = null;
                    try {
                        int i = this.setStatementParamsForMAM(st, query);
                        this.data_repo.setTimestamp(st, i++, ts);
                        rs = st.executeQuery();
                        if (!rs.next()) break block9;
                        n = rs.getInt(1);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                    return n;
                }
                Integer n = null;
                this.data_repo.release(null, rs);
                return n;
            }
        }
        catch (NumberFormatException ex) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Not found message with id = " + msgId);
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Can't find position for message with id " + msgId + " in archive for room " + query.getComponentJID(), (Throwable)ex);
        }
    }
}

