/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.modules.user;

import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.workgroupqueues.modules.AbstractModule;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.workgroupqueues.scheduler.User;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="DepartQueueModule", active=true)
public class DepartQueueModule
extends AbstractModule {
    public static final String ID = "DepartQueueModule";
    private static final Criteria a = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"depart-queue", (String)"http://jabber.org/protocol/workgroup"));
    @Inject
    private Controller controller;
    @Inject
    private Store store;

    public void depart(User user) throws TigaseStringprepException {
        this.controller.removeUser(user);
        Element element = new Element("message", new String[]{"from", "to"}, new String[]{user.getWorkgroupQueue().toString(), user.getJid().toString()});
        element.addChild((XMLNodeIfc)new Element("depart-queue", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/workgroup"}));
        this.write(Packet.packetInstance((Element)element));
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/workgroup"};
    }

    public Criteria getModuleCriteria() {
        return a;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Queue queue;
        User user;
        JID jID;
        JID jID2 = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
        BareJID bareJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
        WorkgroupQueueEntity workgroupQueueEntity = this.store.getWorkgroupQueue(bareJID);
        if (workgroupQueueEntity == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Workgroup not found");
        }
        boolean bl = this.isAdmin(workgroupQueueEntity, jID2);
        String string = packet.getElemCDataStaticStr(new String[]{"iq", "depart-queue", "jid"});
        if (string != null) {
            jID = JID.jidInstance((String)string);
            if (!bl && !jID.equals((Object)jID2)) {
                throw new ComponentException(Authorization.NOT_AUTHORIZED, "Workgroup not found");
            }
        } else {
            jID = jID2;
        }
        if ((user = (queue = this.controller.getQueue(workgroupQueueEntity.getJid())).getUser(jID)) == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "The user was not in the queue");
        }
        this.depart(user);
        this.write(packet.okResult((Element)null, 0));
    }

    protected boolean isAdmin(WorkgroupQueueEntity workgroupQueueEntity, JID jid) {
        return false;
    }
}

