/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.xep0136.modules;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.TagsHelper;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.modules.AbstractModule;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="saveItems", parent=MessageArchiveComponent.class, active=true)
public class SaveItemsModule
extends AbstractModule {
    private static final String SAVE_ELEM = "save";
    private final TimestampHelper timestampHelper = new TimestampHelper();

    public String[] getFeatures() {
        return new String[0];
    }

    public Criteria getModuleCriteria() {
        return null;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Element save = packet.getElement().getChild(SAVE_ELEM, "urn:xmpp:archive");
        try {
            List chats = save.getChildren();
            Element saveResult = new Element(SAVE_ELEM);
            saveResult.setAttributes(save.getAttributes());
            if (chats != null) {
                for (Element chat : chats) {
                    if ("chat" != chat.getName()) continue;
                    Date start = this.timestampHelper.parseTimestamp(chat.getAttributeStaticStr("start"));
                    BareJID owner = packet.getStanzaFrom().getBareJID();
                    String with = chat.getAttributeStaticStr("with");
                    if (with == null) {
                        throw new ComponentException(Authorization.BAD_REQUEST, "Missing 'with' attribute");
                    }
                    JID buddy = JID.jidInstance((String)with);
                    List children = chat.getChildren();
                    if (children != null) {
                        for (Element child : children) {
                            MessageArchiveRepository.Direction direction = MessageArchiveRepository.Direction.getDirection(child.getName());
                            if (direction == null) continue;
                            Date timestamp = null;
                            String secsAttr = child.getAttributeStaticStr("secs");
                            String utcAttr = child.getAttributeStaticStr("utc");
                            if (secsAttr != null) {
                                long secs = Long.parseLong(secsAttr);
                                timestamp = new Date(start.getTime() + secs * 1000L);
                            } else if (utcAttr != null) {
                                timestamp = this.timestampHelper.parseTimestamp(utcAttr);
                            }
                            if (timestamp == null) {
                                timestamp = start;
                            }
                            Element msg = child.clone();
                            msg.setName("message");
                            msg.removeAttribute("secs");
                            msg.removeAttribute("utc");
                            switch (direction) {
                                case incoming: {
                                    msg.setAttribute("from", buddy.toString());
                                    msg.setAttribute("to", owner.toString());
                                    break;
                                }
                                case outgoing: {
                                    msg.setAttribute("from", owner.toString());
                                    msg.setAttribute("to", buddy.toString());
                                }
                            }
                            Set<String> tags = null;
                            if (this.config.isTagSupportEnabled()) {
                                tags = TagsHelper.extractTags(msg);
                            }
                            this.msg_repo.archiveMessage(owner, buddy, direction, timestamp, msg, tags);
                        }
                    }
                    Element chatResult = new Element("chat");
                    chatResult.setAttributes(chat.getAttributes());
                    saveResult.addChild((XMLNodeIfc)chatResult);
                }
            }
            if (!"true".equals(save.getAttributeStaticStr("auto"))) {
                Packet result = packet.okResult(saveResult, 0);
                this.packetWriter.write(result);
            }
        }
        catch (ParseException e) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid format of timestamp");
        }
    }

    public boolean canHandle(Packet packet) {
        return packet.getElement().getChild(SAVE_ELEM, "urn:xmpp:archive") != null;
    }
}

