/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.processors;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.Settings;
import tigase.archive.StoreMethod;
import tigase.archive.StoreMuc;
import tigase.archive.processors.MessageArchivePlugin;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.JID;

@Id(value="urn:xmpp:mam:1")
@Handles(value={@Handle(path={"iq", "query"}, xmlns="urn:xmpp:mam:1"), @Handle(path={"iq", "prefs"}, xmlns="urn:xmpp:mam:1")})
@DiscoFeatures(value={"urn:xmpp:mam:1"})
@Bean(name="urn:xmpp:mam:1", parent=SessionManager.class, active=true)
public class Xep0313MessageArchiveManagementProcessor
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc {
    public static final String ID = "urn:xmpp:mam:1";
    private static final Logger log = Logger.getLogger(Xep0313MessageArchiveManagementProcessor.class.getCanonicalName());
    @Inject
    private MessageArchivePlugin messageArchivePlugin;

    public Authorization canHandle(Packet packet, XMPPResourceConnection conn) {
        if (packet.getStanzaTo() == null) {
            return super.canHandle(packet, conn);
        }
        return null;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        Element prefs = packet.getElement().getChild("prefs", ID);
        if (prefs == null) {
            if (!session.getConnectionId().equals((Object)packet.getPacketFrom())) {
                JID connId = session.getConnectionId(packet.getStanzaTo());
                Packet result = packet.copyElementOnly();
                result.setPacketTo(connId);
                results.offer(result);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "forwarding packet to client connection {0]", packet);
                }
                return;
            }
            Packet result = packet.copyElementOnly();
            if (result.getStanzaFrom() == null) {
                result.initVars(session.getJID(), this.messageArchivePlugin.getComponentJid());
            }
            result.setPacketTo(this.messageArchivePlugin.getComponentJid());
            results.offer(result);
        } else {
            switch (packet.getType()) {
                case get: {
                    this.retrievePreferences(session, packet, results);
                    break;
                }
                case set: {
                    this.updatePrefrerences(session, packet, prefs, results);
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Invalid request for XEP-0313", true));
                }
            }
        }
    }

    private void retrievePreferences(XMPPResourceConnection session, Packet packet, Queue<Packet> results) throws NotAuthorizedException {
        Settings settings = this.messageArchivePlugin.getSettings(session);
        Element prefs = this.preferencesAsElement(settings);
        results.offer(packet.okResult(prefs, 0));
    }

    private void updatePrefrerences(XMPPResourceConnection session, Packet packet, Element prefs, Queue<Packet> results) throws PacketErrorTypeException, NotAuthorizedException {
        Element always = prefs.getChild("always");
        Element never = prefs.getChild("never");
        if (never != null && !never.getChildren().isEmpty() || always != null && !always.getChildren().isEmpty()) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Could not set list of always or never - feature not implemented!", true));
            return;
        }
        String def = prefs.getAttributeStaticStr("default");
        if (def == null) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Missing 'default' attribute", true));
            return;
        }
        Settings settings = this.messageArchivePlugin.getSettings(session);
        StoreMethod requiredStoreMethod = this.messageArchivePlugin.getRequiredStoreMethod(session);
        StoreMuc storeMuc = this.messageArchivePlugin.getRequiredStoreMucMessages(session);
        if (storeMuc == StoreMuc.True) {
            results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Due to system configuration it is not allowed to disable automatic archivization of MUC messages which should be done for MAM", true));
            return;
        }
        switch (def) {
            case "always": {
                settings.setAuto(true);
                break;
            }
            case "never": {
                if (requiredStoreMethod != StoreMethod.False) {
                    results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Due to system configuration it is not possible to disable message archivization", true));
                    return;
                }
                settings.setAuto(false);
                break;
            }
            case "roster": {
                if (requiredStoreMethod != StoreMethod.False) {
                    results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Due to system configuration it is not possible to disable message archivization", true));
                    return;
                }
                settings.setAuto(true);
                settings.setArchiveOnlyForContactsInRoster(true);
                break;
            }
            default: {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Invalid value for 'default' attribute", true));
                return;
            }
        }
        settings.setStoreMethod(StoreMethod.Message);
        settings.setArchiveMucMessages(false);
        try {
            session.setData("message-archive", "settings", settings.serialize());
        }
        catch (TigaseDBException ex) {
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, false));
        }
        results.offer(packet.okResult(this.preferencesAsElement(settings), 0));
    }

    private Element preferencesAsElement(Settings settings) {
        Element prefs = new Element("prefs");
        prefs.setXMLNS(ID);
        prefs.addChild((XMLNodeIfc)new Element("always"));
        prefs.addChild((XMLNodeIfc)new Element("never"));
        if (settings.isAutoArchivingEnabled()) {
            prefs.setAttribute("default", settings.archiveOnlyForContactsInRoster() ? "roster" : "always");
        } else {
            prefs.setAttribute("default", "never");
        }
        return prefs;
    }
}

