/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.processors;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.MessageArchiveVHostItemExtension;
import tigase.archive.Settings;
import tigase.archive.StoreMethod;
import tigase.archive.StoreMuc;
import tigase.archive.processors.Xep0136MessageArchivingProcessor;
import tigase.archive.processors.Xep0313MessageArchiveManagementProcessor;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.util.dns.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.ElementMatcher;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.Message;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.JID;

@Id(value="message-archive")
@Handles(value={@Handle(path={"message"}, xmlns="jabber:client")})
@Bean(name="message-archive", parents={Xep0136MessageArchivingProcessor.class, Xep0313MessageArchiveManagementProcessor.class}, active=true)
public class MessageArchivePlugin
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc,
RegistrarBean {
    public static final String DEFAULT_SAVE = "default-save";
    public static final String MUC_SAVE = "muc-save";
    public static final String OWNER_JID = "owner";
    public static final String ARCHIVE = "message-archive";
    public static final String MSG_ARCHIVE_PATHS = "msg-archive-paths";
    protected static final String ID = "message-archive";
    protected static final String SETTINGS = "message-archive/settings";
    private static final Logger log = Logger.getLogger(MessageArchivePlugin.class.getCanonicalName());
    private static final String AUTO = "auto";
    private static final String DEFAULT_STORE_METHOD_KEY = "default-store-method";
    private static final String REQUIRED_STORE_METHOD_KEY = "required-store-method";
    private static final String STORE_MUC_MESSAGES_KEY = "store-muc-messages";
    private static final String[] MESSAGE_HINTS_NO_STORE = new String[]{"message", "no-store"};
    private static final String[] MESSAGE_HINTS_NO_PERMANENT_STORE = new String[]{"message", "no-permanent-store"};
    private static final String MESSAGE_HINTS_XMLNS = "urn:xmpp:hints";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    @ConfigField(desc="Message archiving component JID", alias="component-jid")
    protected JID componentJid = null;
    @ConfigField(desc="Matchers selecting messages that will be archived", alias="msg-archive-paths")
    private ElementMatcher[] archivingMatchers = new ElementMatcher[]{new ElementMatcher(new String[]{"message", "result"}, "urn:xmpp:mam:1", false), new ElementMatcher(new String[]{"message", "body"}, null, true), new ElementMatcher(new String[]{"message", "store"}, "urn:xmpp:hints", true)};
    @ConfigField(desc="Global default store method", alias="default-store-method")
    private StoreMethod globalDefaultStoreMethod = StoreMethod.Body;
    @ConfigField(desc="Global required store method", alias="required-store-method")
    private StoreMethod globalRequiredStoreMethod = StoreMethod.False;
    @ConfigField(desc="Store MUC messages in archive using automatic archiving", alias="store-muc-messages")
    private StoreMuc globalStoreMucMessages = StoreMuc.User;
    @Inject
    private Message message;
    private RosterAbstract rosterUtil = RosterFactory.getRosterImplementation((boolean)true);

    public MessageArchivePlugin() {
        this.componentJid = JID.jidInstanceNS((String)"message-archive", (String)DNSResolverFactory.getInstance().getDefaultHost(), null);
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            if (!(this.message.hasConnectionForMessageDelivery(session) || packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null)) {
                return;
            }
            this.processMessage(packet, session, results);
        }
        catch (NotAuthorizedException ex) {
            log.log(Level.FINE, "NotAuthorizedException for packet: {0}", packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    public void register(Kernel kernel) {
        kernel.registerBean(Message.class).setActive(true).exec();
    }

    public void unregister(Kernel kernel) {
    }

    public String[] getArchivingMatchers() {
        String[] result = new String[this.archivingMatchers.length];
        for (int i = 0; i < this.archivingMatchers.length; ++i) {
            result[i] = this.archivingMatchers[i].toString();
        }
        return result;
    }

    public void setArchivingMatchers(String[] matcherStrs) {
        ArrayList<ElementMatcher> matchers = new ArrayList<ElementMatcher>();
        for (String matcherStr : matcherStrs) {
            ElementMatcher matcher = ElementMatcher.create((String)matcherStr);
            if (matcher == null) continue;
            matchers.add(matcher);
        }
        this.archivingMatchers = matchers.toArray(new ElementMatcher[0]);
    }

    public JID getComponentJid() {
        return this.componentJid;
    }

    public void setComponentJid(JID componentJid) {
        this.componentJid = componentJid;
    }

    public StoreMethod getDefaultStoreMethod(XMPPResourceConnection session) {
        return Optional.ofNullable(session.getDomain().getExtension(MessageArchiveVHostItemExtension.class)).flatMap(MessageArchiveVHostItemExtension::getDefaultStoreMethod).orElse(this.globalDefaultStoreMethod);
    }

    public StoreMethod getRequiredStoreMethod(XMPPResourceConnection session) {
        return Optional.ofNullable(session.getDomain().getExtension(MessageArchiveVHostItemExtension.class)).flatMap(MessageArchiveVHostItemExtension::getRequiredStoreMethod).orElse(this.globalRequiredStoreMethod);
    }

    public Settings getSettings(XMPPResourceConnection session) throws NotAuthorizedException {
        Settings storeMethod = (Settings)session.getCommonSessionData(SETTINGS);
        if (storeMethod == null) {
            storeMethod = this.loadSettings(session);
        }
        return storeMethod;
    }

    public StoreMuc getRequiredStoreMucMessages(XMPPResourceConnection session) {
        return Optional.ofNullable(session.getDomain().getExtension(MessageArchiveVHostItemExtension.class)).flatMap(MessageArchiveVHostItemExtension::getSaveMuc).orElse(this.globalStoreMucMessages);
    }

    public Settings loadSettings(XMPPResourceConnection session) throws NotAuthorizedException {
        Settings settings = new Settings();
        StoreMuc save = this.globalStoreMucMessages;
        boolean dbException = false;
        boolean conversion = false;
        try {
            String prefs = session.getData("message-archive", "settings", null);
            if (prefs != null) {
                settings.parse(prefs);
            } else {
                conversion = true;
                boolean auto = Boolean.parseBoolean(session.getData(SETTINGS, AUTO, "false"));
                settings.setAuto(auto);
                StoreMuc storeMuc = this.globalStoreMucMessages;
                if (this.globalStoreMucMessages == StoreMuc.User) {
                    String val = session.getData(SETTINGS, MUC_SAVE, null);
                    storeMuc = val == null ? Optional.ofNullable(session.getDomain().getExtension(MessageArchiveVHostItemExtension.class)).flatMap(MessageArchiveVHostItemExtension::getSaveMuc).orElse(StoreMuc.False) : StoreMuc.valueof(val);
                }
                switch (storeMuc) {
                    case True: {
                        settings.setArchiveMucMessages(true);
                        break;
                    }
                    case False: {
                        settings.setArchiveMucMessages(true);
                        break;
                    }
                }
                String storeMethodStr = session.getData(SETTINGS, DEFAULT_SAVE, null);
                StoreMethod storeMethod = StoreMethod.valueof(storeMethodStr);
                if (storeMethodStr == null) {
                    storeMethod = this.getDefaultStoreMethod(session);
                }
                settings.setStoreMethod(storeMethod);
            }
        }
        catch (TigaseDBException ex) {
            dbException = true;
            log.log(Level.WARNING, "Exception reading settings from database", ex);
        }
        StoreMethod requiredStoreMethod = this.getRequiredStoreMethod(session);
        boolean changed = settings.updateRequirements(requiredStoreMethod, this.globalStoreMucMessages);
        session.putCommonSessionData(SETTINGS, (Object)settings);
        if (!dbException) {
            try {
                if (changed || conversion) {
                    session.setData("message-archive", "settings", settings.serialize());
                }
                if (conversion) {
                    session.removeData(SETTINGS, AUTO);
                    session.removeData(SETTINGS, DEFAULT_STORE_METHOD_KEY);
                    session.removeData(SETTINGS, MUC_SAVE);
                }
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Exception updating settings in database", ex);
            }
        }
        return settings;
    }

    private void processMessage(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        StoreMethod requiredStoreMethod;
        if (C2SDeliveryErrorProcessor.isDeliveryError((Packet)packet)) {
            log.log(Level.FINEST, "not processong packet as it is delivery error = {0}", packet);
            return;
        }
        StanzaType type = packet.getType();
        if (type == null) {
            type = StanzaType.normal;
        }
        Element body = packet.getElement().findChildStaticStr(tigase.server.Message.MESSAGE_BODY_PATH);
        Settings settings = this.getSettings(session);
        if (!settings.isAutoArchivingEnabled()) {
            return;
        }
        if ((packet.getAttributeStaticStr(MESSAGE_HINTS_NO_STORE, "xmlns") == MESSAGE_HINTS_XMLNS || packet.getAttributeStaticStr(MESSAGE_HINTS_NO_PERMANENT_STORE, "xmlns") == MESSAGE_HINTS_XMLNS) && (requiredStoreMethod = this.getRequiredStoreMethod(session)) == StoreMethod.False) {
            return;
        }
        switch (type) {
            case groupchat: {
                if (!settings.archiveMucMessages()) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "not storing message as archiving of MUC messages is disabled: {0}", packet);
                    }
                    return;
                }
                if (!session.isUserId(packet.getStanzaFrom().getBareJID())) break;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "not storing message sent to MUC room from user = {0}", packet.toString());
                }
                return;
            }
        }
        switch (settings.getStoreMethod()) {
            case False: {
                if (!log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "not logging packet due to storage method: {0}, {1}", new Object[]{settings.getStoreMethod(), packet});
                return;
            }
            case Body: {
                if (body != null || !log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "not logging packet as there is not body element: ", new Object[]{settings.getStoreMethod(), packet});
                return;
            }
        }
        boolean archive = false;
        for (ElementMatcher matcher : this.archivingMatchers) {
            if (!matcher.matches(packet)) continue;
            archive = matcher.getValue();
            break;
        }
        if (!archive) {
            return;
        }
        if (settings.archiveOnlyForContactsInRoster()) {
            if (packet.getStanzaTo() == null || packet.getStanzaFrom() == null) {
                return;
            }
            try {
                if (!this.rosterUtil.containsBuddy(session, session.isUserId(packet.getStanzaFrom().getBareJID()) ? packet.getStanzaTo() : packet.getStanzaFrom())) {
                    return;
                }
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, session.toString() + ", could not load roster to verify if sender/recipient is in roster, skipping archiving of packet: " + packet, ex);
                return;
            }
        }
        this.storeMessage(packet, session, settings, results);
    }

    private void storeMessage(Packet packet, XMPPResourceConnection session, Settings settings, Queue<Packet> results) throws NotAuthorizedException {
        Packet result = packet.copyElementOnly();
        result.setPacketFrom(session.getJID().copyWithoutResource());
        result.setPacketTo(this.componentJid);
        result.getElement().addAttribute(OWNER_JID, session.getBareJID().toString());
        switch (settings.getStoreMethod()) {
            case Body: {
                Element message = result.getElement();
                block11: for (Element elem : message.getChildren()) {
                    switch (elem.getName()) {
                        case "body": {
                            continue block11;
                        }
                        case "delay": {
                            continue block11;
                        }
                    }
                    message.removeChild(elem);
                }
                break;
            }
        }
        results.offer(result);
    }
}

