/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.xmppsession.PacketDefaultHandler;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.MessageDeliveryProviderIfc;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Id(value="message")
@Handles(value={@Handle(path={"message"}, xmlns="jabber:client"), @Handle(path={"iq", "fin"}, xmlns="urn:xmpp:mam:2"), @Handle(path={"iq", "fin"}, xmlns="urn:xmpp:mam:1")})
@Bean(name="message", parent=SessionManager.class, active=false, exportable=true)
public class Message
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc,
XMPPPreprocessorIfc,
XMPPPacketFilterIfc,
MessageDeliveryProviderIfc {
    protected static final String ELEM_NAME = "message";
    protected static final String XMLNS = "jabber:client";
    private static final Logger log = Logger.getLogger(Message.class.getName());
    private static final String DELIVERY_RULES_KEY = "delivery-rules";
    private static final String SILENTLY_IGNORE_ERROR_KEY = "silently-ignore-message";
    public static Predicate<XMPPResourceConnection> VIABLE_FOR_MESSAGE_DELIVERY = conn -> conn.getPriority() >= 0;
    @ConfigField(desc="Message delivery rules", alias="delivery-rules")
    private MessageDeliveryRules deliveryRules = MessageDeliveryRules.inteligent;
    @ConfigField(desc="Silently ignore errors", alias="silently-ignore-message")
    private boolean silentlyIgnoreError = false;
    private PacketDefaultHandler packetDefaultHandler = new PacketDefaultHandler();

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        C2SDeliveryErrorProcessor.filter(packet, session, repo, results, null);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}, for session: {1}", new Object[]{packet, session});
        }
        if (packet.getElemName() == "iq") {
            this.packetDefaultHandler.process(packet, session, repo, results);
            return;
        }
        if (session == null) {
            this.processOfflineUser(packet, results);
            return;
        }
        try {
            BareJID id;
            BareJID bareJID = id = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
            if (session.isUserId(id)) {
                JID connectionId;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Message ''to'' this user, packet: {0}, for session: {1}", new Object[]{packet, session});
                }
                if (packet.getStanzaFrom() != null && session.isUserId(packet.getStanzaFrom().getBareJID()) && (connectionId = session.getConnectionId()).equals((Object)packet.getPacketFrom())) {
                    results.offer(packet.copyElementOnly());
                    return;
                }
                ArrayList<XMPPResourceConnection> conns = new ArrayList<XMPPResourceConnection>(5);
                String resource = packet.getStanzaTo().getResource();
                if (resource == null) {
                    conns.addAll(this.getConnectionsForMessageDelivery(session));
                } else {
                    XMPPResourceConnection con = session.getParentSession().getResourceForResource(resource);
                    if (con != null) {
                        conns.add(con);
                    }
                }
                if (conns.size() > 0) {
                    for (XMPPResourceConnection con : conns) {
                        Packet result = packet.copyElementOnly();
                        result.setPacketTo(con.getConnectionId());
                        result.setPacketFrom(packet.getTo());
                        results.offer(result);
                        if (!log.isLoggable(Level.FINEST)) continue;
                        log.log(Level.FINEST, "Delivering message, packet: {0}, to session: {1}", new Object[]{packet, con});
                    }
                } else {
                    this.processOfflineUser(packet, results);
                }
                return;
            }
            BareJID bareJID2 = id = packet.getStanzaFrom() != null ? packet.getStanzaFrom().getBareJID() : null;
            if (session.isUserId(id)) {
                results.offer(packet.copyElementOnly());
                return;
            }
            JID jid = packet.getFrom();
            if (session.getConnectionId().equals((Object)jid)) {
                Element el_result = packet.getElement().clone();
                el_result.setAttribute("from", session.getJID().toString());
                Packet result = Packet.packetInstance(el_result, session.getJID(), packet.getStanzaTo());
                results.offer(result);
            }
        }
        catch (NotAuthorizedException e) {
            log.log(Level.FINE, "NotAuthorizedException for packet: " + packet + " for session: " + session, e);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        boolean result = C2SDeliveryErrorProcessor.preProcess(packet, session, repo, results, settings, this);
        if (result) {
            packet.processedBy(this.id());
        }
        return result;
    }

    public List<XMPPResourceConnection> getConnectionsForMessageDelivery(XMPPResourceConnection session) throws NotAuthorizedException {
        ArrayList<XMPPResourceConnection> conns = new ArrayList<XMPPResourceConnection>();
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            if (!VIABLE_FOR_MESSAGE_DELIVERY.test(conn)) continue;
            conns.add(conn);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Out of: {0} total connections, only: {1} have non-negative priority", new Object[]{session.getActiveSessions().size(), conns.size()});
        }
        return conns;
    }

    @Override
    public Set<JID> getJIDsForMessageDelivery(XMPPResourceConnection session) throws NotAuthorizedException {
        HashSet<JID> jids = new HashSet<JID>();
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            if (!VIABLE_FOR_MESSAGE_DELIVERY.test(conn)) continue;
            jids.add(conn.getJID());
        }
        return jids;
    }

    @Override
    public boolean hasConnectionForMessageDelivery(XMPPResourceConnection session) {
        try {
            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                if (!VIABLE_FOR_MESSAGE_DELIVERY.test(conn)) continue;
                return true;
            }
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
        return false;
    }

    private void processOfflineUser(Packet packet, Queue<Packet> results) throws PacketErrorTypeException {
        if (packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Processing message to offline user, packet: {0}, deliveryRules: {1}", new Object[]{packet, this.deliveryRules});
            }
            if (this.deliveryRules != MessageDeliveryRules.strict) {
                StanzaType type = packet.getType();
                if (type == null) {
                    type = StanzaType.normal;
                }
                switch (type) {
                    case chat: {
                        Packet result = packet.copyElementOnly();
                        result.initVars(packet.getStanzaFrom(), packet.getStanzaTo().copyWithoutResource());
                        results.offer(result);
                        break;
                    }
                    case error: {
                        break;
                    }
                    default: {
                        if (!this.silentlyIgnoreError) {
                            results.offer(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The recipient is no longer available.", true));
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (!this.silentlyIgnoreError) {
                results.offer(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The recipient is no longer available.", true));
            }
        }
    }

    private static enum MessageDeliveryRules {
        strict,
        inteligent;

    }
}

