/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;

public class XMPPProcessorException
extends XMPPException {
    private static final long serialVersionUID = 1L;
    private Authorization errorCondition;
    private String text;

    public XMPPProcessorException(Authorization errorCondition) {
        this(errorCondition, (String)null, (String)null);
    }

    public XMPPProcessorException(Authorization errorCondition, String text) {
        this(errorCondition, text, (String)null);
    }

    public XMPPProcessorException(Authorization errorCondition, String text, Throwable cause) {
        this(errorCondition, text, null, cause);
    }

    public XMPPProcessorException(Authorization errorCondition, String text, String message) {
        this(errorCondition, text, message, null);
    }

    public XMPPProcessorException(Authorization errorCondition, String text, String message, Throwable cause) {
        super(message, cause);
        this.errorCondition = errorCondition;
        this.text = text;
    }

    public String getCode() {
        return String.valueOf(this.errorCondition.getErrorCode());
    }

    public Authorization getErrorCondition() {
        return this.errorCondition;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getErrorMessagePrefix());
        sb.append(this.errorCondition.getCondition()).append(" ");
        if (this.text != null) {
            sb.append("with message: \"").append(this.text).append("\" ");
        }
        if (super.getMessage() != null) {
            sb.append("(").append(super.getMessage()).append(") ");
        }
        return sb.toString();
    }

    public String getMessageWithPosition() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage());
        StackTraceElement[] stack = this.getStackTrace();
        if (stack.length > 0) {
            sb.append("generated by ");
            sb.append(this.getStackTrace()[0].toString());
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getName() {
        return this.errorCondition.getCondition();
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.errorCondition.getErrorType();
    }

    public Packet makeElement(Packet packet, boolean insertOriginal) throws PacketErrorTypeException {
        Packet result = this.errorCondition.getResponseMessage(packet, this.text, insertOriginal);
        return result;
    }

    protected String getErrorMessagePrefix() {
        return "XMPP error condition: ";
    }
}

