/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Bean(name="cpu-temp-task", parent=MonitorComponent.class, active=true)
public class CpuTempTask
extends AbstractConfigurableTimerTask
implements Initializable {
    public static final String CPU_TEMP_MONITOR_EVENT_NAME = "tigase.monitor.tasks.CPUTempMonitorEvent";
    private static final TimestampHelper dtf = new TimestampHelper();
    private static final File FREQ_FILE = new File("/proc/cpuinfo");
    private static final Logger log = Logger.getLogger(CpuTempTask.class.getName());
    private static final File TEMP_FILE = new File("/proc/acpi/thermal_zone/TZ01/temperature");
    private static final String THROTT_DIR = "/proc/acpi/processor/CPU";
    private static final String THROTT_FILE = "/throttling";
    private final HashSet<String> triggeredEvents = new HashSet();
    @Inject
    private MonitorComponent component;
    @ConfigField(desc="CPU Temperature threshold")
    private int cpuTempThreshold = 90;
    private float[] cpu_freq = new float[Runtime.getRuntime().availableProcessors()];
    private int cpu_temp;
    private int[] cpu_thrott_pr = new int[Runtime.getRuntime().availableProcessors()];
    private int[] cpu_thrott_st = new int[Runtime.getRuntime().availableProcessors()];
    @Inject
    private EventBus eventBus;

    public CpuTempTask() {
        this.setPeriod(10000L);
    }

    public int getCpuTempThreshold() {
        return this.cpuTempThreshold;
    }

    public void setCpuTempThreshold(Integer cpuTempThreshold) {
        this.cpuTempThreshold = cpuTempThreshold;
    }

    @Override
    public Form getCurrentConfiguration() {
        Form x = super.getCurrentConfiguration();
        x.addField(Field.fieldTextSingle((String)"cpuTempThreshold", (String)("" + this.cpuTempThreshold), (String)"CPU Temp threshold"));
        return x;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerEvent(CPU_TEMP_MONITOR_EVENT_NAME, "Fired when CPU temperature is too high", false);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field cpuTempField = form.get("cpuTempThreshold");
        if (cpuTempField != null) {
            this.cpuTempThreshold = Integer.parseInt(cpuTempField.getValue());
        }
        super.setNewConfiguration(form);
    }

    @Override
    protected void run() {
        this.checkCPUTemperature();
        if (this.cpu_temp >= this.cpuTempThreshold) {
            Element event = new Element(CPU_TEMP_MONITOR_EVENT_NAME);
            event.addChild((XMLNodeIfc)new Element("hostname", this.component.getDefHostName().toString()));
            event.addChild((XMLNodeIfc)new Element("timestamp", "" + dtf.format(new Date())));
            event.addChild((XMLNodeIfc)new Element("cpuTemp", "" + this.cpu_temp));
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(CPU_TEMP_MONITOR_EVENT_NAME);
        }
    }

    private void checkCPUFrequency() {
        try {
            int cpu = 0;
            BufferedReader buffr = new BufferedReader(new FileReader(FREQ_FILE));
            String line = null;
            while ((line = buffr.readLine()) != null) {
                if (!line.startsWith("cpu MHz")) continue;
                int idx = line.indexOf(58);
                this.cpu_freq[cpu++] = Float.parseFloat(line.substring(idx + 1).trim());
            }
            buffr.close();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Can''t read file: " + FREQ_FILE, ex);
        }
    }

    private void checkCPUTemperature() {
        try {
            BufferedReader buffr = new BufferedReader(new FileReader(TEMP_FILE));
            String line = buffr.readLine();
            if (line != null) {
                this.cpu_temp = Integer.parseInt(line.substring("temperature:".length(), line.length() - 1).trim());
            } else {
                log.warning("Empty file: " + TEMP_FILE);
            }
            buffr.close();
        }
        catch (FileNotFoundException ex) {
            log.log(Level.WARNING, "File contains temperature doesn't exists. Disabling task cpu-temp-task");
            this.setEnabled(false);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Can''t read file: " + TEMP_FILE, ex);
        }
    }

    private void checkCPUThrottling() {
        for (int i = 0; i < this.cpu_thrott_st.length; ++i) {
            try {
                File file = new File(THROTT_DIR + i + THROTT_FILE);
                BufferedReader buffr = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = buffr.readLine()) != null) {
                    String line_trimmed = line.trim();
                    if (!line_trimmed.startsWith("*")) continue;
                    int idx = line_trimmed.indexOf(58);
                    this.cpu_thrott_st[i] = Integer.parseInt(line_trimmed.substring(2, idx));
                    String line_pr = line_trimmed.substring(idx + 1, line_trimmed.length() - 1).trim();
                    this.cpu_thrott_pr[i] = Integer.parseInt(line_pr);
                }
                buffr.close();
                continue;
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Can''t read file: /proc/acpi/processor/CPU" + i + THROTT_FILE, ex);
            }
        }
    }
}

