/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.derby;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Logger;
import tigase.db.derby.StoredProcedures;
import tigase.util.Algorithms;

public class MsgRepositoryStoredProcedures {
    private static final Logger log = Logger.getLogger(StoredProcedures.class.getName());
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static void addMessage(String receiver, String sender, Integer type, Timestamp ts, String message, Timestamp expired, Long limit, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt;
            String receiverSha1 = Algorithms.hexDigest((String)receiver.toString(), (String)"", (String)"SHA");
            String senderSha1 = Algorithms.hexDigest((String)sender.toString(), (String)"", (String)"SHA");
            if (limit != 0L) {
                long count;
                stmt = conn.prepareStatement("select count(1) from tig_offline_messages where receiver_sha1 = ? and sender_sha1 = ?");
                stmt.setString(1, receiverSha1);
                stmt.setString(2, senderSha1);
                ResultSet rs = stmt.executeQuery();
                if (rs.next() && (count = rs.getLong(1)) >= limit) {
                    rs.close();
                    data[0] = conn.createStatement().executeQuery("select 1 from sysibm.sysdummy1 where 1=0");
                    return;
                }
                rs.close();
            }
            stmt = conn.prepareStatement("insert into tig_offline_messages (receiver, receiver_sha1, sender, sender_sha1, msg_type, ts, message, expired ) values (?, ?, ?, ?, ?, ?, ?, ?)", 1);
            stmt.setString(1, receiver.toString());
            stmt.setString(2, receiverSha1);
            stmt.setString(3, sender.toString());
            stmt.setString(4, senderSha1);
            stmt.setInt(5, type);
            stmt.setTimestamp(6, ts);
            stmt.setString(7, message);
            if (expired == null) {
                stmt.setNull(8, 93);
            } else {
                stmt.setTimestamp(8, expired);
            }
            stmt.execute();
            data[0] = stmt.getGeneratedKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMessage(Long msgId) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("delete from tig_offline_messages where msg_id = ?");
            stmt.setLong(1, msgId);
            int n = stmt.executeUpdate();
        }
    }

    public static void deleteMessages(String receiver, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String receiverSha1 = Algorithms.hexDigest((String)receiver.toString(), (String)"", (String)"SHA");
            PreparedStatement stmt = conn.prepareStatement("delete from tig_offline_messages where receiver_sha1 = ?");
            stmt.setString(1, receiverSha1);
            int affectedRows = stmt.executeUpdate();
            Statement stmt1 = conn.createStatement();
            data[0] = stmt1.executeQuery("select " + affectedRows + " from sysibm.sysdummy1");
        }
    }

    public static void deleteMessagesByIds(String receiver, String msgId1, String msgId2, String msgId3, String msgId4, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String receiverSha1 = Algorithms.hexDigest((String)receiver.toString(), (String)"", (String)"SHA");
            PreparedStatement stmt = conn.prepareStatement("delete from tig_offline_messages where receiver_sha1 = ? and ( (? is not null and msg_id = ?)\n or (? is not null and msg_id = ?) or (? is not null and msg_id = ?) or (? is not null and msg_id = ?) )");
            stmt.setString(1, receiverSha1);
            stmt.setString(2, msgId1);
            stmt.setString(3, msgId1);
            stmt.setString(4, msgId2);
            stmt.setString(5, msgId2);
            stmt.setString(6, msgId3);
            stmt.setString(7, msgId3);
            stmt.setString(8, msgId4);
            stmt.setString(9, msgId4);
            int affectedRows = stmt.executeUpdate();
            Statement stmt1 = conn.createStatement();
            data[0] = stmt1.executeQuery("select " + affectedRows + " from sysibm.sysdummy1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getExpiredMessages(int limit, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("select om.msg_id, om.expired, om.message from tig_offline_messages om where om.expired is not null order by om.expired asc");
            stmt.setMaxRows(limit);
            data[0] = stmt.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getExpiredMessagesBefore(Timestamp before, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("select om.msg_id, om.expired, om.message from tig_offline_messages om where om.expired is not null and (? is null or om.expired <= ?) order by om.expired asc");
            if (before == null) {
                stmt.setNull(1, 93);
                stmt.setNull(2, 93);
            } else {
                stmt.setTimestamp(1, before);
                stmt.setTimestamp(2, before);
            }
            data[0] = stmt.executeQuery();
        }
    }

    public static void getMessages(String receiver, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String receiverSha1 = Algorithms.hexDigest((String)receiver.toString(), (String)"", (String)"SHA");
            PreparedStatement stmt = conn.prepareStatement("select om.message, om.msg_id from tig_offline_messages om where om.receiver_sha1 = ?");
            stmt.setString(1, receiverSha1);
            data[0] = stmt.executeQuery();
        }
    }

    public static void getMessagesByIds(String receiver, String msgId1, String msgId2, String msgId3, String msgId4, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String receiverSha1 = Algorithms.hexDigest((String)receiver.toString(), (String)"", (String)"SHA");
            PreparedStatement stmt = conn.prepareStatement("select om.message, om.msg_id from tig_offline_messages om where om.receiver_sha1 = ? and ( (? is not null and om.msg_id = ?)\n or (? is not null and om.msg_id = ?) or (? is not null and om.msg_id = ?) or (? is not null and om.msg_id = ?) )");
            stmt.setString(1, receiverSha1);
            stmt.setString(2, msgId1);
            stmt.setString(3, msgId1);
            stmt.setString(4, msgId2);
            stmt.setString(5, msgId2);
            stmt.setString(6, msgId3);
            stmt.setString(7, msgId3);
            stmt.setString(8, msgId4);
            stmt.setString(9, msgId4);
            data[0] = stmt.executeQuery();
        }
    }

    public static void getMessagesCount(String receiver, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String receiverSha1 = Algorithms.hexDigest((String)receiver.toString(), (String)"", (String)"SHA");
            PreparedStatement stmt = conn.prepareStatement("select om.msg_type, count(om.msg_type) from tig_offline_messages om where om.receiver_sha1 = ? group by om.msg_type");
            stmt.setString(1, receiverSha1);
            data[0] = stmt.executeQuery();
        }
    }

    public static void listMessages(String receiver, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            String receiverSha1 = Algorithms.hexDigest((String)receiver.toString(), (String)"", (String)"SHA");
            PreparedStatement stmt = conn.prepareStatement("select om.msg_id, om.msg_type, om.sender from tig_offline_messages om where om.receiver_sha1 = ?");
            stmt.setString(1, receiverSha1);
            data[0] = stmt.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateFromOldSchema() throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select 1 from SYS.SYSTABLES where tablename = UPPER('msg_history')");
            boolean hasTable = rs.next();
            rs.close();
            if (!hasTable) {
                return;
            }
            stmt.execute("insert into tig_offline_messages (receiver, receiver_sha1, sender, sender_sha1, msg_type, ts, message, expired ) select r.jid, r.jid_sha, s.jid, s.jid_sha, m.msg_type, m.ts, m.message, m.expired from msg_history m inner join user_jid r on r.jid_id = m.receiver_uid left join user_jid s on s.jid_id = m.sender_uio");
            stmt.execute("drop table user_jid");
            stmt.execute("drop table msg_history");
        }
    }
}

