/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.conf.ConfigReader;
import tigase.conf.ConfigWriter;
import tigase.conf.OldConfigHolder;
import tigase.io.SSLContextContainer;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.server.ext.ComponentProtocol;
import tigase.server.monitor.MonitorRuntime;
import tigase.sys.TigaseRuntime;
import tigase.util.ui.console.CommandlineParameter;
import tigase.util.ui.console.ParameterParser;
import tigase.util.ui.console.Task;
import tigase.util.workqueue.NonpriorityQueue;
import tigase.vhosts.VHostItemImpl;

public class ConfigHolder {
    public static final String PROPERTIES_CONFIG_FILE_DEF = "etc/init.properties";
    public static final String PROPERTIES_CONFIG_FILE_KEY = "--property-file";
    public static final String TDSL_CONFIG_FILE_DEF = "etc/init.properties".replace("/init.properties", "/config.tdsl");
    public static final String TDSL_CONFIG_FILE_KEY = "--config-file";
    private static final Logger log = Logger.getLogger(ConfigHolder.class.getCanonicalName());
    private Path configFile = Paths.get(TDSL_CONFIG_FILE_DEF, new String[0]);
    private Map<String, Object> props = new LinkedHashMap<String, Object>();

    public static Path backupOldConfigFile(Path initPropsFile) throws IOException {
        Path initPropsFileOld = initPropsFile.resolveSibling(initPropsFile.getFileName() + ".old");
        int i = 0;
        while (Files.exists(initPropsFileOld, new LinkOption[0])) {
            initPropsFileOld = initPropsFile.resolveSibling(initPropsFile.getFileName() + ".old." + ++i);
        }
        Files.deleteIfExists(initPropsFileOld);
        Files.move(initPropsFile, initPropsFileOld, new CopyOption[0]);
        return initPropsFileOld;
    }

    public static void main(String[] args) throws Exception {
        String scriptName = System.getProperty("scriptName");
        ParameterParser parser = new ParameterParser(true);
        parser.setTasks(new Task[]{new Task.Builder().name("upgrade-config").description("Checks configuration file and upgrades it if needed").function(ConfigHolder::upgradeConfig).build()});
        parser.addOption(new CommandlineParameter.Builder(null, PROPERTIES_CONFIG_FILE_KEY.replace("--", "")).defaultValue(PROPERTIES_CONFIG_FILE_DEF).description("Path to properties configuration file").requireArguments(true).build());
        parser.addOption(new CommandlineParameter.Builder(null, TDSL_CONFIG_FILE_KEY.replace("--", "")).defaultValue(TDSL_CONFIG_FILE_DEF).description("Path to DSL configuration file").requireArguments(true).build());
        Properties props = parser.parseArgs(args);
        Optional task = parser.getTask();
        if (props != null && task.isPresent()) {
            ((Task)task.get()).execute(props);
        } else {
            String executionCommand = null;
            if (scriptName != null) {
                executionCommand = "$ " + scriptName + " [task] [params-file.conf] [options]\n\t\tif the option defines default then <value> is optional";
            }
            System.out.println(parser.getHelp(executionCommand));
        }
    }

    private static void putIfAbsent(Map<String, Object> props, String newKey, Object value) {
        Map parentProps = null;
        String[] parts = newKey.split("/");
        for (int i = 0; i < parts.length - 1; ++i) {
            parentProps = props;
            props = (Map)props.computeIfAbsent((String)parts[i], k -> new HashMap());
        }
        String key = parts[parts.length - 1];
        if (key.equals("class")) {
            if (!(props instanceof AbstractBeanConfigurator.BeanDefinition)) {
                AbstractBeanConfigurator.BeanDefinition tmp = new AbstractBeanConfigurator.BeanDefinition();
                tmp.setBeanName(parts[parts.length - 2]);
                tmp.putAll(props);
                props = tmp;
                parentProps.put(tmp.getBeanName(), tmp);
            }
            ((AbstractBeanConfigurator.BeanDefinition)props).setClazzName(value.toString());
        } else {
            props.put(key, value);
        }
    }

    public static void removeIfExistsAnd(Map<String, Object> props, String oldKey, BiConsumer<BiConsumer<String, Object>, Object> consumer) {
        Object value = props.remove(oldKey);
        if (value != null) {
            consumer.accept((k, v) -> ConfigHolder.putIfAbsent(props, k, v), value);
        }
    }

    public static Optional renameIfExists(Map<String, Object> props, String oldKey, String newKey, Function<Object, Object> converter) {
        Optional<Object> value = Optional.ofNullable(props.remove(oldKey));
        if ((value = value.map(converter)).isPresent()) {
            ConfigHolder.putIfAbsent(props, newKey, value.get());
        }
        return value;
    }

    private static void upgradeConfig(Properties props) throws Exception {
        String[] args = (String[])props.entrySet().stream().flatMap(e -> Stream.of("--" + e.getKey(), e.getValue())).toArray(String[]::new);
        ConfigHolder holder = new ConfigHolder();
        try {
            holder.fixShutdownThreadIssue();
            Optional<String[]> output = holder.loadConfiguration(args);
            TigaseRuntime.getTigaseRuntime().shutdownTigase(output.orElse(new String[]{"Configuration file " + holder.configFile + " is in DSL format and is valid."}));
        }
        catch (ConfigReader.UnsupportedOperationException e2) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"ERROR! Error in configuration file: " + holder.configFile, e2.getMessage() + " at line " + e2.getLine() + " position " + e2.getPosition(), "Line: " + e2.getLineContent()});
        }
        catch (ConfigReader.ConfigException e3) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"ERROR! Error in configuration file: " + holder.configFile, "Issue with configuration file: " + e3});
        }
        catch (RuntimeException e4) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"Error! Failed to save upgraded configuration file", e4.getMessage()});
        }
    }

    protected static boolean upgradeDSL(Map<String, Object> props) {
        String before = props.toString();
        props.remove(TDSL_CONFIG_FILE_KEY);
        ConfigHolder.renameIfExists(props, "--cluster-mode", "cluster-mode", Function.identity());
        ConfigHolder.renameIfExists(props, "--virt-hosts", "virtual-hosts", ConfigHolder::convertToListOfStringsIfString);
        if (!(props.get("virtual-hosts") instanceof Map)) {
            ConfigHolder.renameIfExists(props, "virtual-hosts", "default-virtual-host", val -> {
                List list = (List)val;
                if (list == null || list.isEmpty()) {
                    return null;
                }
                VHostItemImpl item = new VHostItemImpl();
                item.initFromPropertyString((String)list.get(0));
                return item.getKey();
            });
        } else {
            ConfigHolder.renameIfExists(props, "virtual-hosts", "default-virtual-host", val -> {
                Map map = (Map)val;
                if (map == null || map.isEmpty()) {
                    return null;
                }
                return map.keySet().stream().sorted().findFirst().orElse(null);
            });
        }
        ConfigHolder.renameIfExists(props, "--debug", "debug", ConfigHolder::convertToListOfStringsIfString);
        ConfigHolder.renameIfExists(props, "--debug-packages", "debug-packages", ConfigHolder::convertToListOfStringsIfString);
        ConfigHolder.renameIfExists(props, "--packet.debug.full", "logging/packet-debug-full", Function.identity());
        ConfigHolder.renameIfExists(props, "--queue-implementation", "priority-queue-implementation", value -> {
            if (value instanceof String) {
                String str = (String)value;
                Pattern compile = Pattern.compile("tigase\\.util\\.(.*Queue.*)");
                Matcher matcher = compile.matcher(str);
                if (matcher.matches()) {
                    return "tigase.util.workqueue." + matcher.group(1);
                }
                return value;
            }
            return value;
        });
        if (Boolean.parseBoolean("" + props.remove("--nonpriority-queue"))) {
            props.putIfAbsent("priority-queue-implementation", NonpriorityQueue.class.getCanonicalName());
        }
        ConfigHolder.renameIfExists(props, "--cluster-nodes", "cluster-nodes", ConfigHolder::convertToListOfStringsIfString);
        ConfigHolder.renameIfExists(props, "--client-port-delay-listening", "client-port-delay-listening", Function.identity());
        ConfigHolder.renameIfExists(props, "--shutdown-thread-dump", "shutdown-thread-dump", Function.identity());
        ConfigHolder.renameIfExists(props, "--amp-security-level", "amp-security-level", Function.identity());
        ConfigHolder.removeIfExistsAnd(props, "--cm-see-other-host", (setter, value) -> {
            setter.accept("c2s/seeOtherHost/class", value);
            setter.accept("bosh/seeOtherHost/class", value);
            setter.accept("ws2s/seeOtherHost/class", value);
        });
        ConfigHolder.renameIfExists(props, "--watchdog_timeout", "watchdog-timeout", Function.identity());
        ConfigHolder.renameIfExists(props, "--watchdog_delay", "watchdog-timeout", Function.identity());
        ConfigHolder.renameIfExists(props, "--watchdog_ping_type", "watchdog-ping-type", Function.identity());
        ConfigHolder.renameIfExists(props, "--installation-id", "installation-id", Function.identity());
        ConfigHolder.renameIfExists(props, "--net-buff-high-throughput", "--net-buff-high-throughput".substring(2), Function.identity());
        ConfigHolder.renameIfExists(props, "--net-buff-standard", "--net-buff-standard".substring(2), Function.identity());
        ConfigHolder.renameIfExists(props, "--cm-ht-traffic-throttling", "--cm-ht-traffic-throttling".substring(2), Function.identity());
        ConfigHolder.renameIfExists(props, "--cm-traffic-throttling", "--cm-traffic-throttling".substring(2), Function.identity());
        ConfigHolder.renameIfExists(props, "--ws-allow-unmasked-frames", "ws-allow-unmasked-frames", Function.identity());
        ConfigHolder.renameIfExists(props, "--vhost-tls-required", "vhost-tls-required", Function.identity());
        ConfigHolder.renameIfExists(props, "--vhost-register-enabled", "vhost-register-enabled", Function.identity());
        ConfigHolder.renameIfExists(props, "--vhost-message-forward-jid", "vhost-message-forward-jid", Function.identity());
        ConfigHolder.renameIfExists(props, "--vhost-presence-forward-jid", "vhost-presence-forward-jid", Function.identity());
        ConfigHolder.renameIfExists(props, "--vhost-max-users", "vhost-max-users", Function.identity());
        ConfigHolder.renameIfExists(props, "--vhost-anonymous-enabled", "vhost-anonymous-enabled", Function.identity());
        ConfigHolder.renameIfExists(props, "--vhost-disable-dns-check", "vhost-disable-dns-check", Function.identity());
        ConfigHolder.renameIfExists(props, "--s2s-secret", "vhost-man/defaults/s2s-secret", Function.identity());
        ConfigHolder.renameIfExists(props, "--test", "logging/rootLevel", value -> Boolean.TRUE.equals(value) ? Level.WARNING : Level.CONFIG);
        ConfigHolder.renameIfExists(props, "--ssl-def-cert-domain", "certificate-container/ssl-def-cert-domain", Function.identity());
        ConfigHolder.renameIfExists(props, "--sni-disable", "certificate-container/sni-disable", Function.identity());
        ConfigHolder.renameIfExists(props, "--ssl-certs-location", "certificate-container/ssl-certs-location", Function.identity());
        ConfigHolder.renameIfExists(props, "--trusted-certs-dir", "certificate-container/trusted-certs-dir", Function.identity());
        ConfigHolder.renameIfExists(props, "--pem-privatekey-password", "certificate-container/pem-privatekey-password", Function.identity());
        ConfigHolder.renameIfExists(props, "--tls-jdk-nss-bug-workaround-active", "tls-jdk-nss-bug-workaround-active", Function.identity());
        ConfigHolder.renameIfExists(props, "--tls-enabled-protocols", "tls-enabled-protocols", ConfigHolder::convertToListOfStringsIfString);
        ConfigHolder.renameIfExists(props, "--tls-enabled-ciphers", "tls-enabled-ciphers", ConfigHolder::convertToListOfStringsIfString);
        ConfigHolder.renameIfExists(props, "--hardened-mode", "hardened-mode", Function.identity());
        ConfigHolder.renameIfExists(props, "hardened-mode", "hardened-mode", val -> SSLContextContainer.HardenedModeVHostItemExtension.parseHardenedModeFromString(String.valueOf(val)));
        props.entrySet().stream().filter(Map.class::isInstance).map(Map.class::cast).filter(component -> component.containsKey("sslContextContainer")).map(component -> component.get("sslContextContainer")).filter(Map.class::isInstance).map(Map.class::cast).forEach(container -> ConfigHolder.renameIfExists(props, "hardened-mode", "hardened-mode", val -> SSLContextContainer.HardenedModeVHostItemExtension.parseHardenedModeFromString(String.valueOf(val))));
        boolean allowInvalidCerts = Boolean.parseBoolean((String)props.remove("allow-invalid-certs"));
        boolean allowSelfSignedCerts = Boolean.parseBoolean((String)props.remove("allow-self-signed-certs"));
        if (allowInvalidCerts || allowSelfSignedCerts) {
            props.put("certificate-container/ssl-trust-model", allowInvalidCerts ? "all" : (allowSelfSignedCerts ? "selfsigned" : "trusted"));
        }
        ConfigHolder.renameIfExists(props, "--bosh-extra-headers-file", "bosh-extra-headers-file", Function.identity());
        ConfigHolder.renameIfExists(props, "--bosh-close-connection", "bosh-close-connection", Function.identity());
        ConfigHolder.renameIfExists(props, "--client-access-policy-file", "client-access-policy-file", Function.identity());
        ConfigHolder.renameIfExists(props, "--stringprep-processor", "stringprep-processor", Function.identity());
        ConfigHolder.renameIfExists(props, "--cluster-connect-all", "cl-comp/connect-all", Function.identity());
        ConfigHolder.renameIfExists(props, "--cluster-connections-per-node", "cl-comp/connections-per-node", Function.identity());
        ConfigHolder.renameIfExists(props, "--tigase-resolver-class", "dns-resolver/tigase-resolver-class", Function.identity());
        ConfigHolder.renameIfExists(props, "--tigase-primary-address", "dns-resolver/tigase-primary-address", Function.identity());
        ConfigHolder.renameIfExists(props, "--tigase-secondary-address", "dns-resolver/tigase-secondary-address", Function.identity());
        ConfigHolder.renameIfExists(props, "--s2s-skip-tls-hostnames", "s2s/skip-tls-hostnames", ConfigHolder::convertToListOfStringsIfString);
        ConfigHolder.renameIfExists(props, "--scripts-dir", "scripts-dir", Function.identity());
        ConfigHolder.renameIfExists(props, "--cross-domain-policy-file", "cross-domain-policy-file", Function.identity());
        ConfigHolder.renameIfExists(props, "--domain-filter-policy", "domain-filter-policy", Function.identity());
        props.remove("--script-dir");
        ConfigHolder.removeIfExistsAnd(props, "--new-connections-throttling", (setter, value) -> {
            String[] all_ports_thr;
            for (String port_thr : all_ports_thr = ((String)value).split(",")) {
                String[] port_thr_ar = port_thr.trim().split(":");
                if (port_thr_ar.length == 2) {
                    try {
                        int port_no = Integer.parseInt(port_thr_ar[0]);
                        long throttling = Long.parseLong(port_thr_ar[1]);
                        switch (port_no) {
                            case 5222: 
                            case 5223: {
                                setter.accept("c2s/connections/" + port_no + "/new-connections-throttling", throttling);
                                break;
                            }
                            case 5280: {
                                setter.accept("bosh/connections/" + port_no + "/new-connections-throttling", throttling);
                                break;
                            }
                            case 5277: {
                                setter.accept("cl-comp/connections/" + port_no + "/new-connections-throttling", throttling);
                                break;
                            }
                            case 5290: {
                                setter.accept("ws2s/connections/" + port_no + "/new-connections-throttling", throttling);
                                break;
                            }
                            case 5269: {
                                setter.accept("s2s/connections/" + port_no + "/new-connections-throttling", throttling);
                                break;
                            }
                            default: {
                                Stream.of("c2s", "bosh", "ws2s", "s2s", "ext").forEach(cmp -> {
                                    Map cmpCfg = (Map)props.get(cmp);
                                    if (cmpCfg == null) {
                                        return;
                                    }
                                    Map cmpConns = (Map)cmpCfg.get("connections");
                                    if (cmpConns == null) {
                                        return;
                                    }
                                    Map portSettings = (Map)cmpConns.get("" + port_no);
                                    if (portSettings == null) {
                                        return;
                                    }
                                    portSettings.putIfAbsent("new-connections-throttling", throttling);
                                });
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Connections throttling configuration error, bad format, check the documentation for a correct syntax, port throttling config: {0}", port_thr);
                    }
                    continue;
                }
                log.log(Level.WARNING, "Connections throttling configuration error, bad format, check the documentation for a correct syntax, port throttling config: {0}", port_thr);
            }
        });
        ConfigHolder.renameIfExists(props, "--roster-implementation", "roster-implementation", Function.identity());
        ConfigHolder.renameIfExists(props, "--s2s-ejabberd-bug-workaround-active", "s2s/dialback/ejabberd-bug-workaround", v -> Boolean.parseBoolean("" + v));
        ConfigHolder.renameIfExists(props, "--sm-threads-pool", "sess-man/sm-threads-pool", Function.identity());
        ConfigHolder.removeIfExistsAnd(props, "--ssl-container-class", (setter, value) -> {
            Map cfg = props.getOrDefault("rootSslContextContainer", new HashMap());
            if (cfg instanceof AbstractBeanConfigurator.BeanDefinition) {
                ((AbstractBeanConfigurator.BeanDefinition)cfg).setClazzName(value.toString());
            } else {
                AbstractBeanConfigurator.BeanDefinition.Builder builder = new AbstractBeanConfigurator.BeanDefinition.Builder().name("rootSslContextContainer").active(true).clazz(value.toString());
                cfg.forEach(builder::property);
                props.put("rootSslContextContainer", builder.build());
            }
        });
        Stream.of("c2s", "bosh", "ws2s").forEach(cmp -> {
            Map cmpCfg = (Map)props.get(cmp);
            if (cmpCfg != null) {
                Map oldCfg = (Map)cmpCfg.remove("cm-see-other-host");
                Map newCfg = (Map)cmpCfg.computeIfAbsent("seeOtherHost", x -> new HashMap());
                if (oldCfg != null) {
                    newCfg.putAll(oldCfg);
                }
            }
        });
        ConfigHolder.removeIfExistsAnd(props, "--user-repo-pool", (setter, value) -> {
            Map repos = (Map)props.get("userRepository");
            (repos != null ? repos.keySet() : Collections.singleton("default")).forEach(name -> setter.accept("userRepository/" + name + "/pool-class", value));
        });
        ConfigHolder.removeIfExistsAnd(props, "--user-repo-pool-size", (setter, value) -> {
            Map repos = (Map)props.get("userRepository");
            (repos != null ? repos.keySet() : Collections.singleton("default")).forEach(name -> setter.accept("userRepository/" + name + "/pool-size", value));
        });
        Optional.ofNullable(props.get("sess-man")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(sessManCfg -> {
            Object jabberIqLast;
            String saslMechanisms = (String)sessManCfg.remove("enabled-mechanisms");
            if (saslMechanisms != null) {
                if (saslMechanisms instanceof String) {
                    ConfigHolder.putIfAbsent(props, "sess-man/sasl-provider/allowed-mechanisms", Arrays.asList(saslMechanisms.split(",")));
                } else {
                    ConfigHolder.putIfAbsent(props, "sess-man/sasl-provider/allowed-mechanisms", saslMechanisms);
                }
            }
            if ((jabberIqLast = sessManCfg.remove("jabber:iq:last")) != null) {
                AbstractBeanConfigurator.BeanDefinition.Builder builder = new AbstractBeanConfigurator.BeanDefinition.Builder().name("jabber:iq:last-marker").active(true);
                AbstractBeanConfigurator.BeanDefinition build = builder.build();
                sessManCfg.put("jabber:iq:last-marker", build);
                ConfigHolder.putIfAbsent(props, "sess-man/jabber:iq:last-marker/jabber:iq:last", jabberIqLast);
            }
        });
        props.remove("--api-keys");
        props.computeIfPresent("http", (k, v) -> {
            if (v instanceof Map) {
                ((Map)v).remove("api-keys");
                ((Map)v).computeIfPresent("rest", (k1, v1) -> {
                    if (v1 instanceof Map) {
                        ((Map)v1).remove("api-keys");
                    }
                    return v1;
                });
            }
            return v;
        });
        props.values().stream().filter(it -> it instanceof AbstractBeanConfigurator.BeanDefinition).map(it -> (AbstractBeanConfigurator.BeanDefinition)it).filter(it -> ComponentProtocol.class.getName().equals(it.getClazzName())).forEach(it -> it.computeIfPresent("repository", (k, v) -> {
            if (v instanceof Map) {
                Map v2;
                Object v1 = ((Map)v).remove("items");
                if (v1 != null && v1 instanceof List) {
                    List v22 = (List)v1;
                    if (!v22.isEmpty()) {
                        OldConfigHolder.saveOldExternalComponentConfigItems(v22.toArray(new String[v22.size()]));
                    }
                } else if (v1 instanceof Map && !(v2 = (Map)v1).isEmpty()) {
                    String[] components = (String[])v2.entrySet().stream().map(e -> {
                        String[] parts;
                        Map p = (Map)e.getValue();
                        StringBuilder sb = new StringBuilder();
                        for (String part : parts = (String[])Stream.of(e.getKey(), p.get("password"), p.get("type"), p.get("port"), p.get("remote"), p.get("proto-xmlns"), p.get("lb-class"), p.get("socket")).map(String::valueOf).toArray(String[]::new)) {
                            if ("null".equals(part)) break;
                            if (sb.length() > 0) {
                                sb.append(":");
                            }
                            sb.append(part);
                        }
                        return sb.toString();
                    }).toArray(String[]::new);
                    OldConfigHolder.saveOldExternalComponentConfigItems(components);
                }
            }
            return v;
        }));
        Optional.ofNullable(props.get("basic-conf")).filter(Map.class::isInstance).map(Map.class::cast).map(v -> v.remove("logging")).filter(Map.class::isInstance).map(Map.class::cast).map(v -> v.get("handlers")).filter(String.class::isInstance).map(String.class::cast).map(v -> v.split(" ")).map(Arrays::asList).ifPresent(handlers -> ((Map)props.computeIfAbsent("logging", k -> new HashMap())).putIfAbsent("rootHandlers", handlers));
        Optional.ofNullable(props.get("logging")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(logging -> {
            Collection handlers = Optional.ofNullable(logging.get("rootHandlers")).filter(Map.class::isInstance).map(Map.class::cast).map(map -> map.keySet()).orElseGet(() -> Arrays.asList("java.util.logging.ConsoleHandler", "java.util.logging.FileHandler"));
            for (String handler : handlers) {
                Optional.ofNullable(logging.remove(handler)).ifPresent(cfg -> ((Map)logging.computeIfAbsent("handlers", k -> new HashMap())).put(handler, cfg));
            }
            for (String key : new ArrayList(logging.keySet())) {
                Map map2;
                Object value = logging.get(key);
                if (!(value instanceof Map) || !(map2 = (Map)value).containsKey("level") && !map2.containsKey("useParentHandlers")) continue;
                logging.remove(key);
                ((Map)logging.computeIfAbsent("loggers", k -> new HashMap())).putIfAbsent(key, value);
            }
        });
        Optional.ofNullable(props.get("basic-conf")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(basicConf -> {
            new ArrayList(basicConf.keySet()).stream().filter(key -> key.startsWith("virt-hosts-cert-")).forEach(key -> {
                Object value = basicConf.remove(key);
                Map customCerts = (Map)((Map)props.computeIfAbsent("certificate-container", k -> new HashMap())).computeIfAbsent("custom-certificates", k -> new HashMap());
                customCerts.putIfAbsent(key.replace("virt-hosts-cert-", ""), value);
            });
            new ArrayList(basicConf.keySet()).stream().filter(key -> key.startsWith("virtual-hosts-cert-")).forEach(key -> {
                Object value = basicConf.remove(key);
                Map customCerts = (Map)((Map)props.computeIfAbsent("certificate-container", k -> new HashMap())).computeIfAbsent("custom-certificates", k -> new HashMap());
                customCerts.putIfAbsent(key.replace("virtual-hosts-cert-", ""), value);
            });
        });
        Optional.ofNullable(props.get("basic-conf")).filter(Map.class::isInstance).map(Map.class::cast).filter(Map::isEmpty).ifPresent(v -> props.remove("basic-conf"));
        Optional.ofNullable(props.get("message-router")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(messageRouterCfg -> {
            Optional.ofNullable(messageRouterCfg.get("components")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(componentsCfg -> {
                Optional.ofNullable(componentsCfg.get("msg-receivers")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(msgReceiversCfg -> {
                    msgReceiversCfg.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith(".active")).forEach(e -> {
                        String compName = ((String)e.getKey()).replace(".active", "");
                        AbstractBeanConfigurator.BeanDefinition bean = (AbstractBeanConfigurator.BeanDefinition)props.compute(compName, (k, v) -> {
                            if (AbstractBeanConfigurator.BeanDefinition.class.isInstance(v)) {
                                return v;
                            }
                            if (Map.class.isInstance(v)) {
                                AbstractBeanConfigurator.BeanDefinition def = new AbstractBeanConfigurator.BeanDefinition();
                                def.setBeanName((String)k);
                                def.putAll((Map)v);
                                return def;
                            }
                            AbstractBeanConfigurator.BeanDefinition def = new AbstractBeanConfigurator.BeanDefinition();
                            def.setBeanName((String)k);
                            return def;
                        });
                        bean.setActive(Boolean.parseBoolean(String.valueOf(e.getValue())));
                    });
                    Set<String> toRemove = messageRouterCfg.keySet().stream().filter(e -> e.endsWith(".active")).collect(Collectors.toSet());
                    toRemove.forEach(messageRouterCfg::remove);
                    if (messageRouterCfg.isEmpty()) {
                        componentsCfg.remove("msg-receivers");
                    }
                });
                if (componentsCfg.isEmpty()) {
                    messageRouterCfg.remove("components");
                }
            });
            if (messageRouterCfg.isEmpty()) {
                props.remove("message-router");
            }
        });
        Optional.ofNullable(props.get("sess-man")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(sessManCfg -> Optional.ofNullable(sessManCfg.remove("urn:xmpp:push:0:ext")).ifPresent(extCfg -> {
            AbstractBeanConfigurator.BeanDefinition cfg = new AbstractBeanConfigurator.BeanDefinition();
            cfg.setBeanName("urn:xmpp:push:0");
            cfg.setActive(true);
            cfg.compute("away", (k, v) -> {
                AbstractBeanConfigurator.BeanDefinition c = new AbstractBeanConfigurator.BeanDefinition();
                c.setBeanName("away");
                c.setActive(true);
                return c;
            });
            sessManCfg.put(cfg.getBeanName(), cfg);
        }));
        String after = props.toString();
        return !before.equals(after);
    }

    public Optional<String[]> loadConfiguration(String[] args) throws IOException, ConfigReader.ConfigException {
        boolean hasCustomConfigFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (TDSL_CONFIG_FILE_KEY.equals(args[i]) && i + 1 < args.length) {
                this.configFile = Paths.get(args[++i], new String[0]);
                hasCustomConfigFile = true;
            }
            if (!PROPERTIES_CONFIG_FILE_KEY.equals(args[i]) || i + 1 >= args.length || hasCustomConfigFile) continue;
            Path propsFilePath = Paths.get(args[++i], new String[0]);
            this.configFile = propsFilePath.resolveSibling(this.configFile.getFileName());
        }
        OldConfigHolder oldConfigHolder = new OldConfigHolder();
        oldConfigHolder.convert(args, this.configFile);
        Optional<String[]> output = oldConfigHolder.getOutput();
        this.loadFromDSLFiles();
        if (ConfigHolder.upgradeDSL(this.props)) {
            try {
                Optional<Path> configFileOld = Optional.ofNullable(ConfigHolder.backupOldConfigFile(this.configFile));
                this.saveToDSLFile(this.configFile.toFile());
                log.log(Level.CONFIG, "Configuration file {0} was updated to match current format." + configFileOld.map(path -> " Previous version of configuration file was saved as " + path).orElse(""), new Object[]{this.configFile});
                if (!oldConfigHolder.getOutput().isPresent()) {
                    output = Optional.of(Stream.of(MessageFormat.format("Configuration file {0} was updated to match current format.", this.configFile), configFileOld.map(path -> "Previous version of configuration file was saved as " + path).orElse("")).filter(line -> !line.isEmpty()).toArray(String[]::new));
                }
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, "could not replace configuration file with file in DSL format", ex);
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        try (StringWriter w = new StringWriter();){
            new ConfigWriter().resolveVariables().write(w, this.props);
            log.log(Level.CONFIG, "Loaded configuration:\n" + ((Object)w).toString());
        }
        return output;
    }

    public Map<String, Object> getProperties() {
        return this.props;
    }

    public void setProperties(Map<String, Object> props) {
        this.props = props;
    }

    public void saveToDSLFile(File f) throws IOException {
        new ConfigWriter().write(f, this.props);
    }

    public Path getConfigFilePath() {
        return this.configFile;
    }

    private void loadFromDSLFiles() throws IOException, ConfigReader.ConfigException {
        log.log(Level.CONFIG, "Loading configuration from file: {0}", this.configFile);
        Map<String, Object> loaded = new ConfigReader().read(this.configFile.toFile());
        this.props.putAll(loaded);
    }

    private void fixShutdownThreadIssue() {
        MonitorRuntime.getMonitorRuntime();
        try {
            Field f = MonitorRuntime.class.getDeclaredField("mainShutdownThread");
            f.setAccessible(true);
            MonitorRuntime monitorRuntime = MonitorRuntime.getMonitorRuntime();
            Runtime.getRuntime().removeShutdownHook((Thread)f.get(monitorRuntime));
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            log.log(Level.FINEST, "There was an error with unregistration of shutdown hook", ex);
        }
    }

    private static Stream<String> stringToStreamOfStrings(String val) {
        return Arrays.stream(val.split(",")).map(String::trim);
    }

    private static List<String> stringToListOfStrings(String val) {
        return ConfigHolder.stringToStreamOfStrings(val).collect(Collectors.toList());
    }

    private static Object convertToListOfStringsIfString(Object val) {
        if (val instanceof String) {
            return ConfigHolder.stringToListOfStrings((String)val);
        }
        return val;
    }
}

