/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoException;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.db.AbstractAuthRepositoryWithCredentials;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryImpl;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.kernel.beans.config.ConfigField;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.MongoRepositoryVersionAware;
import tigase.util.StringUtilities;
import tigase.util.Version;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"mongodb:.*"}, isDefault=true)
@Repository.SchemaId(id="server-user", name="Tigase XMPP Server (User)", external=false)
@RepositoryVersionAware.SchemaVersion
public class MongoRepository
extends AbstractAuthRepositoryWithCredentials
implements UserRepository,
DataSourceAware<MongoDataSource>,
MongoRepositoryVersionAware {
    protected static final String USERS_COLLECTION = "tig_users";
    protected static final String USER_CREDENTIALS_COLLECTION = "tig_user_credentials";
    protected static final String NODES_COLLECTION = "tig_nodes";
    protected static final String ID_KEY = "user_id";
    protected static final String DOMAIN_KEY = "domain";
    private static final Logger log = Logger.getLogger(MongoRepository.class.getCanonicalName());
    private static final String JID_HASH_ALG = "SHA-256";
    private static final int DEF_BATCH_SIZE = 100;
    private static final String AUTO_CREATE_USER_KEY = "autoCreateUser=";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @ConfigField(desc="Auto create user", alias="autoCreateUser=")
    protected boolean autoCreateUser = false;
    private AuthRepositoryImpl auth;
    @ConfigField(desc="Batch size", alias="batch-size")
    private int batchSize = 100;
    private MongoDataSource dataSource;
    private MongoDatabase db;
    private MongoCollection<Document> nodesCollection;
    private boolean passwordInUsersCollection = false;
    private MongoCollection<Document> userCredentialsCollection;
    private MongoCollection<Document> usersCollection;

    public void addDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        subnode = this.normalizeSubnode(subnode);
        try {
            byte[] uid = this.generateId(user);
            Document dto = new Document("uid", (Object)uid).append("node", (Object)subnode).append("key", (Object)key).append("values", Arrays.asList(list));
            this.nodesCollection.insertOne((Object)dto);
            if (this.autoCreateUser) {
                this.ensureUserExists(user, uid);
            }
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem adding data list to repository", (Throwable)ex);
        }
    }

    public void addUser(BareJID user) throws UserExistsException, TigaseDBException {
        this.addUserRepo(user);
    }

    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        this.addUser(user);
        if (password != null) {
            this.updateCredential(user, "default", password);
        }
    }

    private Object addUserRepo(BareJID user) throws UserExistsException, TigaseDBException {
        try {
            byte[] id = this.generateId(user);
            Document userDto = new Document().append(ID_KEY, (Object)user.toString());
            userDto.append(DOMAIN_KEY, (Object)user.getDomain());
            userDto.append("_id", (Object)id);
            this.usersCollection.insertOne((Object)userDto);
            return id;
        }
        catch (MongoWriteException ex) {
            if (ex.getError() != null && ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                throw new UserExistsException("Error adding user to repository: ", (Throwable)ex);
            }
            throw new TigaseDBException("Error adding user to repository: ", (Throwable)ex);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error adding user to repository: ", (Throwable)ex);
        }
    }

    protected byte[] calculateHash(String user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(user.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    private Document createCrit(BareJID user, String subnode, String key) throws TigaseDBException {
        subnode = this.normalizeSubnode(subnode);
        byte[] uid = this.generateId(user);
        Document crit = new Document("uid", (Object)uid);
        if (key != null) {
            crit.append("key", (Object)key);
        }
        if (subnode == null) {
            crit.append("node", (Object)new Document("$exists", (Object)false));
        } else {
            crit.append("node", (Object)subnode);
        }
        return crit;
    }

    private void ensureUserExists(BareJID user, byte[] id) throws TigaseDBException {
        try {
            BasicDBObject userDto = new BasicDBObject();
            userDto.append(DOMAIN_KEY, (Object)user.getDomain());
            if (id == null) {
                id = this.generateId(user);
            }
            userDto.append("_id", (Object)id);
            this.usersCollection.updateOne((Bson)userDto, (Bson)new Document("$set", (Object)new Document((Map)userDto).append(ID_KEY, (Object)user.toString())), new UpdateOptions().upsert(true));
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error adding user to repository: ", (Throwable)ex);
        }
    }

    protected byte[] generateId(BareJID user) throws TigaseDBException {
        return this.calculateHash(user.toString().toLowerCase());
    }

    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        String value = this.getData(user, "account_status");
        return value == null ? AuthRepository.AccountStatus.active : AuthRepository.AccountStatus.valueOf((String)value);
    }

    public Credentials getCredentials(BareJID user, String credentialId) throws TigaseDBException {
        byte[] uid = this.generateId(user);
        List mechanisms = this.getCredentialsDecoder().getSupportedMechanisms();
        Bson projecton = Projections.fields((Bson[])new Bson[]{Projections.include((List)mechanisms), Projections.include((String[])new String[]{"account_status"})});
        Document doc = (Document)this.userCredentialsCollection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"uid", (Object)uid), Filters.eq((String)"username", (Object)credentialId)})).projection(projecton).first();
        if (doc == null) {
            if ("default".equals(credentialId) && this.passwordInUsersCollection) {
                Document userDto = (Document)this.usersCollection.findOneAndUpdate(Filters.eq((String)"_id", (Object)uid), Updates.unset((String)"password"));
                if (userDto == null) {
                    throw new UserNotFoundException("User " + user + " not found in repository");
                }
                String password = userDto.getString((Object)"password");
                if (password != null) {
                    AuthRepository.AccountStatus accountStatus = userDto.getString((Object)"account_status") == null ? AuthRepository.AccountStatus.active : AuthRepository.AccountStatus.valueOf((String)userDto.getString((Object)"account_status"));
                    this.updateCredential(user, "default", password);
                    return new AuthRepository.SingleCredential(user, accountStatus, (Credentials.Entry)new PlainCredentialsEntry(password));
                }
            }
            return null;
        }
        ArrayList<AuthRepository.DefaultCredentials.RawEntry> entries = new ArrayList<AuthRepository.DefaultCredentials.RawEntry>();
        AuthRepository.AccountStatus accountStatus = AuthRepository.AccountStatus.valueOf((String)doc.getString((Object)"account_status"));
        for (String mechanism : mechanisms) {
            String value = doc.getString((Object)mechanism);
            if (value == null) continue;
            entries.add(new AuthRepository.DefaultCredentials.RawEntry(mechanism, value));
        }
        return new AuthRepository.DefaultCredentials(user, accountStatus, entries, this.getCredentialsDecoder());
    }

    public String getData(BareJID user, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        String value = this.getData(user, subnode, key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public String getData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            Document result = this.getDataInt(user, subnode, key);
            return result != null ? result.getString((Object)"value") : null;
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data from repository", (Throwable)ex);
        }
    }

    public String getData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        try {
            Document result = this.getDataInt(user, null, key);
            return result != null ? result.getString((Object)"value") : null;
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data from repository", (Throwable)ex);
        }
    }

    public Map<String, String> getDataMap(BareJID user, String subnode) throws TigaseDBException {
        return this.getDataMap(user, subnode, Function.identity());
    }

    public <T> Map<String, T> getDataMap(BareJID user, String subnode, Function<String, T> converter) throws TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, null);
            HashMap<String, T> result = new HashMap<String, T>();
            for (Document doc : this.nodesCollection.find((Bson)crit).projection(Projections.include((String[])new String[]{"key", "value"}))) {
                String value = doc.getString((Object)"value");
                if (value != null) {
                    result.put(doc.getString((Object)"key"), converter.apply(value));
                    continue;
                }
                result.put(doc.getString((Object)"key"), null);
            }
            return result;
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data from repository", (Throwable)ex);
        }
    }

    private Document getDataInt(BareJID user, String subnode, String key) throws TigaseDBException {
        Document crit = this.createCrit(user, subnode, key);
        return (Document)this.nodesCollection.find((Bson)crit).first();
    }

    public String[] getDataList(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            ArrayList<String> values = new ArrayList<String>();
            Document crit = this.createCrit(user, subnode, key);
            FindIterable cursor = this.nodesCollection.find((Bson)crit).batchSize(this.batchSize);
            for (Document it : cursor) {
                if (it.containsKey((Object)"values")) {
                    values.addAll((List)it.get((Object)"values"));
                    continue;
                }
                if (!it.containsKey((Object)"value")) continue;
                values.add((String)it.get((Object)"value"));
            }
            return values.toArray(new String[values.size()]);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving data list from repository", (Throwable)ex);
        }
    }

    public String[] getKeys(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, null);
            List<String> result = this.readAllDistinctValuesForField(this.nodesCollection, "key", crit);
            return result.toArray(new String[result.size()]);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem retrieving keys for " + user + " and subnode " + subnode + " from repository", (Throwable)ex);
        }
    }

    public String[] getKeys(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.getKeys(user, null);
    }

    public String getResourceUri() {
        return this.dataSource.getResourceUri();
    }

    public String[] getSubnodes(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.getSubnodes(user, null);
    }

    public String[] getSubnodes(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        subnode = this.normalizeSubnode(subnode);
        try {
            byte[] uid = this.generateId(user);
            Document crit = new Document("uid", (Object)uid);
            Pattern regex = Pattern.compile("^" + (subnode != null ? subnode + "/" : "") + "[^/]*");
            crit.append("node", (Object)regex);
            List result = this.readAllDistinctValuesForField(this.nodesCollection, "node", crit);
            ArrayList<String> res = new ArrayList<String>();
            for (String node : result) {
                int idx;
                if (subnode != null) {
                    node = node.substring(subnode.length() + 1);
                }
                if ((idx = node.indexOf("/")) > 0) {
                    node = node.substring(0, idx);
                }
                if (res.contains(node)) continue;
                res.add(node);
            }
            return res.isEmpty() ? null : res.toArray(new String[res.size()]);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error getting subnode from repository: ", (Throwable)ex);
        }
    }

    public Collection<String> getCredentialIds(BareJID user) throws TigaseDBException {
        try {
            byte[] uid = this.generateId(user);
            Bson projecton = Projections.include((String[])new String[]{"username"});
            ArrayList<String> credentialIds = new ArrayList<String>();
            this.userCredentialsCollection.find(Filters.eq((String)"uid", (Object)uid)).projection(projecton).map(doc -> doc.getString((Object)"username")).forEach(credentialIds::add);
            return credentialIds;
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error getting list of credentialIds for user " + user + ": ", (Throwable)ex);
        }
    }

    @Deprecated
    public long getUserUID(BareJID user) throws TigaseDBException {
        return 0L;
    }

    public List<BareJID> getUsers() throws TigaseDBException {
        ArrayList<BareJID> users = new ArrayList<BareJID>(1000);
        try {
            FindIterable cursor = this.usersCollection.find().projection((Bson)new Document(ID_KEY, (Object)1)).batchSize(this.batchSize);
            for (Document entry : cursor) {
                users.add(BareJID.bareJIDInstanceNS((String)((String)entry.get((Object)ID_KEY))));
            }
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem loading user list from repository", (Throwable)ex);
        }
        return users;
    }

    public long getUsersCount() {
        try {
            return this.usersCollection.count((Bson)new Document());
        }
        catch (MongoException ex) {
            return -1L;
        }
    }

    public long getUsersCount(String domain) {
        try {
            Document crit = new Document();
            crit.append(DOMAIN_KEY, (Object)domain.toLowerCase());
            return this.usersCollection.count((Bson)crit);
        }
        catch (MongoException ex) {
            return -1L;
        }
    }

    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        try {
            if (this.db == null) {
                MongoDataSource ds = new MongoDataSource();
                ds.initRepository(resource_uri, params);
                this.setDataSource(ds);
            }
        }
        catch (MongoException ex) {
            throw new DBInitException("Could not connect to MongoDB server using URI = " + resource_uri, (Throwable)ex);
        }
    }

    public void loggedIn(BareJID jid) throws TigaseDBException {
    }

    public void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
    }

    private String normalizeSubnode(String subnode) {
        if (subnode != null) {
            String[] split = subnode.split("/");
            subnode = StringUtilities.stringArrayToString((String[])split, (String)"/");
        }
        return subnode;
    }

    public boolean otherAuth(Map<String, Object> authProps) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(authProps);
    }

    public void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }

    protected <T> List<T> readAllDistinctValuesForField(MongoCollection<Document> collection, String field, Document crit) throws MongoException {
        FindIterable cursor = collection.find((Bson)crit).projection((Bson)new BasicDBObject(field, (Object)1)).batchSize(this.batchSize);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Document item : cursor) {
            Object val = item.get((Object)field);
            if (result.contains(val)) continue;
            result.add(val);
        }
        return result;
    }

    public void removeCredential(BareJID user, String credentialId) throws TigaseDBException {
        byte[] uid = this.generateId(user);
        this.userCredentialsCollection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"uid", (Object)uid), Filters.eq((String)"username", (Object)credentialId)}));
    }

    public void removeData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        this.removeData(user, null, key);
    }

    public void removeData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, key);
            this.db.getCollection(NODES_COLLECTION).deleteMany((Bson)crit);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error data from repository: ", (Throwable)ex);
        }
    }

    public void removeSubnode(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        subnode = this.normalizeSubnode(subnode);
        try {
            byte[] uid = this.generateId(user);
            Document crit = new Document("uid", (Object)uid);
            Pattern regex = Pattern.compile("^" + (subnode != null ? subnode : "") + "[^/]*");
            crit.append("node", (Object)regex);
            this.nodesCollection.deleteMany((Bson)crit);
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Error removing subnode from repository: ", (Throwable)ex);
        }
    }

    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        try {
            Document userDto = new Document();
            byte[] id = this.generateId(user);
            userDto.append("_id", (Object)id);
            this.usersCollection.deleteOne((Bson)userDto);
            this.removeSubnode(user, null);
        }
        catch (MongoException e) {
            throw new TigaseDBException("Error removing user from repository: ", (Throwable)e);
        }
    }

    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus status) throws TigaseDBException {
        if (status == null) {
            this.removeData(user, "account_status");
        } else {
            this.setData(user, "account_status", status.name());
        }
        byte[] uid = this.generateId(user);
        this.userCredentialsCollection.updateMany(Filters.eq((String)"uid", (Object)uid), Updates.set((String)"account_status", (Object)status.name()));
    }

    public void setData(BareJID user, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setData(user, null, key, value);
    }

    public void setData(BareJID user, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, key);
            Document dto = new Document((Map)crit).append("value", (Object)value);
            if (subnode == null) {
                dto.remove((Object)"node");
            }
            this.nodesCollection.updateOne((Bson)crit, (Bson)new Document("$set", (Object)dto), new UpdateOptions().upsert(true));
            if (this.autoCreateUser) {
                this.ensureUserExists(user, null);
            }
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem setting values in repository", (Throwable)ex);
        }
    }

    public void setDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        try {
            Document crit = this.createCrit(user, subnode, key);
            Document dto = new Document((Map)crit).append("values", Arrays.asList(list));
            if (subnode == null) {
                dto.remove((Object)"node");
            }
            ArrayList<Object> operation = new ArrayList<Object>();
            operation.add(new DeleteManyModel((Bson)crit));
            operation.add(new InsertOneModel((Object)dto));
            this.nodesCollection.bulkWrite(operation);
            if (this.autoCreateUser) {
                this.ensureUserExists(user, null);
            }
        }
        catch (MongoException ex) {
            throw new TigaseDBException("Problem setting values in repository", (Throwable)ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.dataSource = dataSource;
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, USERS_COLLECTION)) {
            this.db.createCollection(USERS_COLLECTION);
        }
        this.usersCollection = this.db.getCollection(USERS_COLLECTION);
        if (!Helper.collectionExists(this.db, USER_CREDENTIALS_COLLECTION)) {
            this.db.createCollection(USER_CREDENTIALS_COLLECTION);
        }
        this.userCredentialsCollection = this.db.getCollection(USER_CREDENTIALS_COLLECTION);
        this.userCredentialsCollection.createIndex((Bson)new BasicDBObject("uid", (Object)1).append("username", (Object)1), new IndexOptions().unique(true));
        if (!Helper.collectionExists(this.db, NODES_COLLECTION)) {
            this.db.createCollection(NODES_COLLECTION);
        }
        this.nodesCollection = this.db.getCollection(NODES_COLLECTION);
        this.nodesCollection.createIndex((Bson)new BasicDBObject("uid", (Object)1));
        this.nodesCollection.createIndex((Bson)new BasicDBObject("node", (Object)1));
        this.nodesCollection.createIndex((Bson)new BasicDBObject("key", (Object)1));
        this.nodesCollection.createIndex((Bson)new BasicDBObject("uid", (Object)1).append("node", (Object)1).append("key", (Object)1));
        this.passwordInUsersCollection = this.usersCollection.count(Filters.exists((String)"password")) > 0L;
        this.auth = new AuthRepositoryImpl(this){

            public String getPassword(BareJID user) throws TigaseDBException {
                try {
                    return MongoRepository.this.getPassword(user);
                }
                catch (MongoException ex) {
                    throw new TigaseDBException("Error retrieving password for user " + user, (Throwable)ex);
                }
            }
        };
    }

    public void updateCredential(BareJID user, String credentialId, String password) throws TigaseDBException {
        List credentials = this.getCredentialsEncoder().encodeForAllMechanisms(user, password);
        byte[] uid = this.generateId(user);
        AuthRepository.AccountStatus accountStatus = Optional.ofNullable(this.getAccountStatus(user)).orElse(AuthRepository.AccountStatus.active);
        Document doc = new Document().append("uid", (Object)uid).append("username", (Object)credentialId).append("account_status", (Object)accountStatus.name());
        for (String[] pair : credentials) {
            doc.append(pair[0], (Object)pair[1]);
        }
        this.userCredentialsCollection.findOneAndReplace(Filters.and((Bson[])new Bson[]{Filters.eq((String)"uid", (Object)uid), Filters.eq((String)"username", (Object)credentialId)}), (Object)doc, new FindOneAndReplaceOptions().upsert(true));
    }

    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        this.updateCredential(user, "default", password);
    }

    public SchemaLoader.Result updateSchema(Optional<Version> oldVersion, Version newVersion) throws TigaseDBException {
        long usersCount = this.getUsersCount();
        List<BareJID> users = this.getUsers();
        for (Document doc : this.usersCollection.find().batchSize(1000)) {
            try {
                byte[] oldUid = ((Binary)doc.get((Object)"_id")).getData();
                String user = (String)doc.get((Object)ID_KEY);
                byte[] newUid = this.calculateHash(user.toLowerCase());
                if (Arrays.equals(oldUid, newUid)) continue;
                this.nodesCollection.updateMany((Bson)new Document("uid", (Object)oldUid), (Bson)new Document("$set", (Object)new Document("uid", (Object)newUid)));
                Document oldUserFilter = new Document("_id", (Object)oldUid).append(ID_KEY, (Object)user);
                Document oldUserDocument = (Document)this.usersCollection.find((Bson)oldUserFilter).first();
                Document newUserDocument = new Document((Map)oldUserDocument).append("_id", (Object)newUid);
                this.usersCollection.insertOne((Object)newUserDocument);
                this.usersCollection.findOneAndDelete((Bson)oldUserDocument);
            }
            catch (TigaseDBException ex) {
                log.log(Level.SEVERE, "Schema update failed!", ex);
            }
        }
        return SchemaLoader.Result.ok;
    }

    public boolean userExists(BareJID user) {
        try {
            BasicDBObject userDto = new BasicDBObject();
            byte[] id = this.generateId(user);
            userDto.append("_id", (Object)id);
            return this.usersCollection.count((Bson)userDto) > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }
}

