/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam;

import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.spam.ResultsAwareSpamFilter;
import tigase.spam.SpamFilter;
import tigase.spam.filters.KnownSpammersFilter;
import tigase.stats.StatisticsList;
import tigase.vhosts.VHostManager;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Id;

@Id(value="spam-filter")
@Bean(name="spam-filter", parent=SessionManager.class, active=true)
public class SpamProcessor
extends AnnotatedXMPPProcessor
implements XMPPPreprocessorIfc,
RegistrarBean {
    public static final String ID = "spam-filter";
    private static final Logger log = Logger.getLogger(SpamProcessor.class.getCanonicalName());
    @Inject(nullAllowed=true)
    private CopyOnWriteArrayList<SpamFilter> filters = new CopyOnWriteArrayList();
    @Inject(nullAllowed=true)
    private CopyOnWriteArrayList<ResultsAwareSpamFilter> resultsAwareFilters = new CopyOnWriteArrayList();
    @Inject(nullAllowed=false)
    private VHostManager vHostManager;
    @ConfigField(desc="Return error if packet is dropped", alias="return-error")
    private boolean returnError = false;

    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository nonAuthUserRepository, Queue<Packet> queue, Map<String, Object> map) {
        if (packet.getStanzaFrom() != null && packet.getStanzaFrom().getLocalpart() == null && this.vHostManager.getDefVHostItem().equals((Object)packet.getStanzaFrom().getBareJID())) {
            return false;
        }
        for (SpamFilter filter : this.filters) {
            if (filter.filter(packet, session)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "filter {0} detected spam message {1}, sending error = {2}", new Object[]{filter.getId(), packet, this.returnError});
            }
            this.resultsAwareFilters.forEach(resultAware -> resultAware.identifiedSpam(packet, session, filter));
            if (!this.returnError) {
                packet.processedBy(ID);
            }
            return true;
        }
        return false;
    }

    public void register(Kernel kernel) {
    }

    public void unregister(Kernel kernel) {
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.filters.forEach(filter -> filter.getStatistics(this.id(), list));
    }

    public void setFilters(CopyOnWriteArrayList<SpamFilter> filters) {
        if (filters == null) {
            this.filters = new CopyOnWriteArrayList();
        } else {
            Optional<KnownSpammersFilter> knownSpammers = filters.stream().filter(filter -> filter instanceof KnownSpammersFilter).map(filter -> (KnownSpammersFilter)filter).findAny();
            knownSpammers.ifPresent(filter -> {
                filters.remove(filter);
                filters.add(0, (SpamFilter)filter);
            });
            this.filters = filters;
        }
    }

    public void setResultsAwareFilters(CopyOnWriteArrayList<ResultsAwareSpamFilter> resultsAwareFilters) {
        if (resultsAwareFilters == null) {
            resultsAwareFilters = new CopyOnWriteArrayList();
        }
        this.resultsAwareFilters = resultsAwareFilters;
    }
}

