/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.modules;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.push.EncryptedNotification;
import tigase.push.PlainNotification;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.INotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="publish-notification", parent=PushNotificationsComponent.class, active=true)
public class PublishNotificationModule
extends AbstractModule {
    private static final String a = "urn:xmpp:push:0";
    private static final String b = "http://jabber.org/protocol/pubsub";
    private static final Criteria c = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"publish"));
    private String[] d = new String[]{"urn:xmpp:push:0"};
    @Inject(nullAllowed=true)
    private List<IPushProvider> pushProviders;
    private Map<String, IPushProvider> e;
    @Inject
    private IPushRepository repository;
    @ConfigField(desc="Default priority of notifications", alias="def-priority")
    private INotification.Priority defPriority = INotification.Priority.high;

    private static void a(BareJID bareJID, String string) throws ComponentException {
        throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Node " + string + " not found at " + bareJID);
    }

    public String[] getFeatures() {
        return this.d;
    }

    public Criteria getModuleCriteria() {
        return c;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Element element = packet.getElement().getChild("pubsub").getChild("publish");
        String string = element.getAttributeStaticStr("node");
        if (string == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Missing node attribute");
        }
        Element element2 = element.getChild("item");
        if (element2 == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Missing item to push");
        }
        Element element3 = element2.getChild("notification", a);
        if (element3 == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Missing notification to push");
        }
        try {
            this.pushNotification(packet.getStanzaTo().getBareJID(), packet.getStanzaFrom().getBareJID(), string, element3);
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeException(repositoryException);
        }
        this.write(packet.okResult((Element)null, 0));
    }

    public void setPushProviders(List<IPushProvider> pushProviders) {
        if (pushProviders == null) {
            pushProviders = Collections.emptyList();
        }
        this.pushProviders = pushProviders;
        this.e = pushProviders.stream().collect(Collectors.toConcurrentMap(iPushProvider -> iPushProvider.getName(), Function.identity()));
        this.d = (String[])Stream.concat(Stream.of(a), this.pushProviders.stream().map(iPushProvider -> iPushProvider.getName())).toArray(String[]::new);
    }

    protected IPushProvider getProvider(IPushSettings.IDevice device) {
        return this.e.get(device.getProviderName());
    }

    protected void pushNotification(BareJID serviceJid, BareJID senderJid, String node, Element notificationElem) throws ComponentException, TigaseStringprepException, RepositoryException {
        IPushSettings iPushSettings = this.repository.getNodeSettings(serviceJid, node, PublishNotificationModule::a);
        if (!iPushSettings.isOwner(senderJid) && !iPushSettings.getOwnerJid().getDomain().equals(senderJid.getDomain())) {
            throw new ComponentException(Authorization.FORBIDDEN, "Cannot publish item - you are not node owner");
        }
        INotification iNotification = this.parseNotification(iPushSettings.getOwnerJid(), notificationElem);
        for (IPushSettings.IDevice iDevice : iPushSettings.getDevices()) {
            IPushProvider iPushProvider = this.getProvider(iDevice);
            if (iPushProvider == null) {
                this.log.log(Level.FINE, "Could not send push notification to provider " + iDevice.getProviderName() + " - missing push provider!");
                continue;
            }
            iPushProvider.pushNotification(iDevice.getDeviceId(), iNotification);
        }
    }

    protected INotification parseNotification(BareJID userJid, Element notificationElem) throws ComponentException, TigaseStringprepException {
        INotification.Priority priority = Optional.ofNullable(notificationElem.getChild("priority", "tigase:push:priority:0")).map(Element::getCData).map(INotification.Priority::valueOf).orElseGet(() -> notificationElem.getChild("x", "jabber:x:data") == null ? INotification.Priority.low : INotification.Priority.high);
        Element element = notificationElem.getChild("encrypted", "tigase:push:encrypt:0");
        if (element == null) {
            Element element2;
            Long l = this.parseLong(notificationElem, "message-count");
            JID jID = this.parseJID(notificationElem, "last-message-sender");
            String string = DataForm.getFieldValue((Element)notificationElem, (String)"last-message-body");
            String string2 = null;
            Element element3 = notificationElem.getChild("groupchat", "http://tigase.org/protocol/muc#offline");
            if (element3 != null && (element2 = element3.getChild("nickname")) != null) {
                string2 = XMLUtils.unescape((String)element2.getCData());
            }
            return new PlainNotification(userJid, priority, l, jID, string, string2);
        }
        return new EncryptedNotification(userJid, priority, element.getCData(), element.getAttributeStaticStr("iv"));
    }

    protected Long parseLong(Element elem, String field) {
        String string = DataForm.getFieldValue((Element)elem, (String)field);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return Long.parseLong(string);
    }

    protected JID parseJID(Element elem, String field) throws ComponentException, TigaseStringprepException {
        String string = DataForm.getFieldValue((Element)elem, (String)field);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JID.jidInstance((String)string);
    }
}

